﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Business;
using Model;
/// <summary>
/// 新闻操作的展现层
/// </summary>
public class ENews
{
    BNews bnews = new BNews();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public ENews()
    {
        
    }
    /// <summary>
    /// 主页新闻显示的属性
    /// </summary>
    public IList<News> GetIndexNews
    {
        get { return this.bnews.GetIndexNews(); }
    }
    /// <summary>
    /// 显示全部新闻的属性
    /// </summary>
    public IList<News> GetAllNews
    {
        get { return this.bnews.GetAllNews(); }
    }
    /// <summary>
    /// 根据新闻ID删除一条新闻
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <returns>1表示删除成功,0表示删除失败</returns>
    public int Delete(string systemId)
    {
        News news = new News();
        
        try
        {
            news.SystemId = long.Parse(systemId);
            return bnews.DeleteNews(news);
        }
        catch (Exception ex)
        {

            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }

    /// <summary>
    /// 编辑新闻
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <param name="title">标题</param>
    /// <param name="context">正文</param>
    /// <returns>1表示修改成功,0表示修改失败</returns>
    public int EditNews(string systemId,string title,string context)
    {
        News news = new News();

        news.Title = title;
        news.Context = context;
        try
        {
            news.SystemId = long.Parse(systemId);
            return bnews.EditNews(news);
        }
        catch (Exception ex)
        {
            
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 增加一条新闻
    /// </summary>
    /// <param name="title">标题</param>
    /// <param name="context">正文</param>
    /// <returns>1表示增加成功,0表示增加失败</returns>
    public int AddNews(string title, string context)
    {
        News news = new News(title,context);
        try
        {
            return bnews.AddNews(news);
        }
        catch (Exception ex)
        {

            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
    }
    /// <summary>
    /// 显示一条新闻(字符串,包含标题,正文,发布时间用,分割)
    /// </summary>
    /// <param name="systemId">新闻ID</param>
    /// <returns>新闻内容字符串</returns>
    public string ShowOne(string systemId)
    {
        News news = new News();
        System.Text.StringBuilder txt = new System.Text.StringBuilder();
        try
        {
            news.SystemId = long.Parse(systemId);
            News oneNews= bnews.ShowOne(news);
            txt.Append(oneNews.Title+",");
            txt.Append(oneNews.Context + ",");
            txt.Append(oneNews.PublishTime + ",");
            return txt.ToString();
        }
        catch (Exception ex)
        {

            WebConvert.JScript.JsAlert(ex.Message);
            return "";
        }
    }
   
}
