﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: AddDocType
 * Date: 2007-7-24
 * Author: Xing
 * Description: 
 *      添加公文类型
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddDocType : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            LinkButton2.CommandName = "UpdateNext";

            if (!IsPostBack)
            {
                DocTran.BLL.DocType docType = DocTran.BLL.DocType.GetDocTypeByID(int.Parse(Request.QueryString["ID"]));
                if (docType != null)
                {
                    TypeNameTextBox.Text = docType.TypeName;
                    TypeDescTextbox.Text = docType.TypeDesc;
                }
            }
        }
        

    }
    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {
                    if (DocTran.BLL.DocType.IsExistDocType(TypeNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.DocType.InsertDocType(TypeNameTextBox.Text.Trim(), TypeDescTextbox.Text.Trim());
                        //MsgLabel.Text = "添加成功！";
                        //MsgLabel.Visible = true;
                        //TypeNameTextBox.Text = "";
                        //TypeDescTextbox.Text = "";
                        Response.Redirect("DocTypeList.aspx");
                    }
                }
                break;
            case "SaveAdd":
                {
                    if (DocTran.BLL.DocType.IsExistDocType(TypeNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        DocTran.BLL.DocType.InsertDocType(TypeNameTextBox.Text.Trim(), TypeDescTextbox.Text.Trim());
                        MsgLabel.Text = "添加成功！";
                        MsgPanel.Visible = true;
                        TypeNameTextBox.Text = "";
                        TypeDescTextbox.Text = "";

                    }
                }
                break;
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.DocType.UpdateDocType(id, TypeNameTextBox.Text.Trim(), TypeDescTextbox.Text.Trim());
                    Response.Redirect("DocTypeList.aspx");
                }
                break;
            case "UpdateNext":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = DocTran.BLL.DocType.UpdateDocType(id, TypeNameTextBox.Text.Trim(), TypeDescTextbox.Text.Trim());
                    if (bSuccess)
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        MsgPanel.Visible = true;
                        TypeNameTextBox.Text = "";
                        TypeDescTextbox.Text = "";
                    }
                }
                break;

        }
    }
}
