﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: AdminMailList.aspx.cs
 * Date: 2007-7-24
 * Author: Xing
 * Description: 
 *      管理员－所有公文列表
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;
public partial class AdminMailList : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.DocManager))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        } 
        //每页数量
        GridView1.PageSize = PageSize;
    }


    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }
    //分页
    protected void GridView1_DataBound(object sender, EventArgs e)
    {
        PaddingCtrl.GridView_DataBound(sender, e);
        
    }

    //将文档删除
    protected void DelLinkButton_Click(object sender, EventArgs e)
    {
        bool bSucc = false;
        List<bool> bRetValCol = new List<bool>();
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                bSucc = DocTran.BLL.Doc.DelDoc(int.Parse(idCheckBox.Text), DelAccCheckBox.Checked);
                bRetValCol.Add(bSucc);
            }
        }

        if (bRetValCol.Count == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行删除操作！";
            MsgPanel.Visible = true;
        }
        else
        {
            GridView1.DataBind();
            int nSucc = bRetValCol.FindAll(Succ).Count;
            int nFail = bRetValCol.FindAll(Fail).Count;

            MsgLabel.Text = string.Format("针对<strong><font color='red'>{0}</font></strong>项进行了删除操作，<strong><font color='red'>{1}</font></strong>项被成功删除！",
                    nSucc + nFail, nSucc);
            MsgPanel.Visible = true;
        }

    }
    private static bool Succ(bool val)
    {
        return val == true ? true : false;
    }

    private static bool Fail(bool val)
    {
        return val == false ? true : false;
    }


    //求记录总数
    protected void DocDS_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {   //先执行 GetDocs 返回 List　对象
        //在执行 GetDocCount　返回 int
        
        if (e.ReturnValue is Int32)
        {
            PaddingCtrl.RecordCount = (int)e.ReturnValue;
            NumLabel.Text = e.ReturnValue.ToString();
        }
    }

    //有附件的用图显示
    protected string AccPic(int docID)
    {
        /* 显示个数
        int nCount = DocTran.BLL.Accessories.GetAccessoriesByDocIdCount(docID);
        if ( nCount!= 0)
            return "<img src='./images/attach.jpg' alt='有" + nCount.ToString() + "个附件' Title='有" + nCount.ToString() + "个附件' />";
        else
            return "";
        */

        /*显示附件列表*/
        List<DocTran.BLL.Accessories> accList = DocTran.BLL.Accessories.GetAccessoriesByDocID(docID);
        if (accList.Count != 0)
        {
            string file = "";
            foreach (DocTran.BLL.Accessories acc in accList)
            {
                decimal fileSize = 0;
                if (acc.FileSize != 0)
                {
                    fileSize = Utils.XConvert.BytesToMB(acc.FileSize, 2);
                    //if ( int.Parse(acc.FileSize) != 0)
                    
                    if (fileSize == 0) //不够显示MB
                    {
                        fileSize = Utils.XConvert.BytesToKB(acc.FileSize, 2);
                        file += acc.DispName + " (" + fileSize.ToString() + "KB)" + "\n\n";
                    }
                    else
                    {
                        file += acc.DispName + " (" + fileSize.ToString() + "MB)" + "\n\n";
                    }
                }
            }
            return "<img src='../images/attach.jpg'   Title='" + file + "' />";

        }
        else
        {
            return "";
        }
    }

}
