﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: DeptmentList.aspx.cs
 * Date: 2007-7-11
 * Author: Xing
 * Description: 
 *      部门列表
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class DeptmentList : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
       
    }

    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;
               
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");
            //只有可见的CheckBox才做选中操作
            if (idCheckBox != null && idCheckBox.Visible == true)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }

    protected void DelLinkButton_Click(object sender, EventArgs e)
    {   
        bool bSucc=false;
        List<bool> bRetValCol = new List<bool>();

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            //Header 行 Cells[0] 不会出错，因为至少包含一列 :)
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                bSucc = DocTran.BLL.Deptment.DeleteDeptment(int.Parse(idCheckBox.Text));
                bRetValCol.Add(bSucc);
            }
        }

        if (bRetValCol.Count == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行删除操作！";
            MsgPanel.Visible = true;
        }
        else
        {
            GridView1.DataBind();
            int nSucc = bRetValCol.FindAll(Succ).Count;
            int nFail = bRetValCol.FindAll(Fail).Count;
            
            MsgLabel.Text = string.Format("共有<strong><font color='red'>{0}</font></strong>项被成功删除，<strong><font color='red'>{1}</font></strong>项正在使用不能被删除！",
                    nSucc, nFail);
            MsgPanel.Visible = true;
        }
        
    }
    
    private static bool Succ(bool val)
    {
        return val == true ? true : false;
    }

    private static bool Fail(bool val)
    {
        return val == false ? true : false;
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //将权限名称为 "无"的 CheckBox 的Visible设置为不可见
        //在删除的时候根据 Visible属性去扣除删除项
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            CheckBox chkBox = (CheckBox)e.Row.Cells[0].FindControl("IdChkBox");
            Label lbl = (Label)e.Row.Cells[3].FindControl("EditLabel");
            if (chkBox != null && lbl != null && chkBox.Text.Equals("1"))     // 1 为 Admin 管理权限
            {
                chkBox.Visible = false;
                lbl.Visible = false;

            }
        }
    }
}
