﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class UserList : DocTran.UI.AdminBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
       
    }

    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;
               
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Visible == true)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }

    protected void DelLinkButton_Click(object sender, EventArgs e)
    {
        bool bSucc = false;
        List<bool> bRetValCol = new List<bool>();
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                bSucc = DocTran.BLL.User.DeleteUser(int.Parse(idCheckBox.Text));
                bRetValCol.Add(bSucc);
            }
        }

        if (bRetValCol.Count == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行删除操作！";
            MsgPanel.Visible = true;
        }
        else
        {
            GridView1.DataBind();
            int nSucc = bRetValCol.FindAll(Succ).Count;
            int nFail = bRetValCol.FindAll(Fail).Count;

            MsgLabel.Text = string.Format("共操作了<strong><font color='red'>{0}</font></strong>项，<strong><font color='red'>{1}</font></strong>项被成功删除！",
                    nSucc+nFail, nSucc);
            MsgPanel.Visible = true;
        }
        
    }
    private static bool Succ(bool val)
    {
        return val == true ? true : false;
    }

    private static bool Fail(bool val)
    {
        return val == false ? true : false;
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //Admin用户不可选中，不可编辑
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            CheckBox chkBox = (CheckBox)e.Row.Cells[0].FindControl("IdChkBox");
            Label lbl = (Label)e.Row.Cells[6].FindControl("EditLabel");
            if (chkBox != null && lbl != null && chkBox.Text.Equals("1"))     // 1 为 Admin 管理权限
            {
                chkBox.Visible = false;
                lbl.Visible = false;

            }
        }
    }

    public string UserStatus(bool status)
    {
        if (status == true)
        {
            return "<span>激活</span>";
        }
        else
        {
            return "<span style='color:red'>禁用</span>";
        }
    }
}
