﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class Archives_UserArchives : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void SearchBtn_Click(object sender, EventArgs e)
    {
        //查询
        if (SearchTextBox.Text.Length <= 0)
        {
            UserArcDS.SelectParameters["findExp"].DefaultValue = "";
            UserArcDS.DataBind();
            return;
        }

        string key = SearchTextBox.Text.Trim();
        key = key.Replace("'", "''");
        string t = string.Format("ArcName LIKE '%{0}%' OR ArcDesc LIKE '%{0}%'", key);
        UserArcDS.SelectParameters["findExp"].DefaultValue = t;
        UserArcDS.DataBind();
    }

    protected void DelLinkBtn_OnCommand(object sender, CommandEventArgs e)
    {
        //删除档案，删除档案文件，删除实际文件
        //删除档案文件已由Sqlserver里做了级联删除
        try
        {

            int id = int.Parse(e.CommandArgument.ToString());

            //先删除实际文件
            List<DigitWork.BLL.UserArcFile> listfile = DigitWork.BLL.UserArcFile.GetUserArcFilesByArcId(id);
            foreach (DigitWork.BLL.UserArcFile file in listfile)
            {
                DigitWork.BLL.UserArcFile.DeleteFile(file.ID);
            }

            //删除档案数据
            bool retVal = DigitWork.BLL.UserArchive.Delete(id,DocTran.BLL.User.CurrentUser.ID);
            //删除档案文件数据


            if (retVal)
            {
                MsgLabel.Text = "删除成功！";
                MsgPanel.Visible = true;
                GridView1.DataBind();
            }
            else
            {
                MsgLabel.Text = "删除失败！";
                MsgPanel.Visible = true;
            }
        }
        catch (Exception ex)
        {
            MsgLabel.Text = ex.Message;
            MsgPanel.Visible = true;
        }
        finally { }

    }
}
