﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="MyBlogs.aspx.cs" Inherits="MyBlogs" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>我的日志</title>
    <link href="css/free3.3.css" rel="stylesheet" type="text/css" />
    <link href="css/inboxlist.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <div id="main">
            <div class="tagbg">
                <div class="tag" style="text-align: center;">
                    <strong>我的日志</strong>
                    <div style="text-align: right; margin-right: 30px;">
                        <asp:TextBox ID="SearchTextBox" runat="server" CssClass="search_input"></asp:TextBox>
                        <asp:LinkButton ID="SearchBtn" Text="搜" CssClass="searchbtn" runat="server" OnClick="SearchBtn_Click" />
                    </div>
                </div>
            </div>
            <div id="inboxarea">
             <asp:Panel ID="MsgPanel" runat="server" CssClass="option_msg" Visible="false" EnableViewState="false">
                    <asp:Label ID="MsgLabel" runat="server" Style="padding: 15px 0px 5px 30px; display: inline;"
                        EnableViewState="false" />
                </asp:Panel>
                <div class="inboxareaheader">
                    <span class="userbutton">
                        <asp:LinkButton ID="DelLinkButton" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender1" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="DelLinkButton">
                        </ajaxToolkit:ConfirmButtonExtender>
                    </span>
                </div>
                <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataSourceID="BlogDS"
                    AllowPaging="True" AllowSorting="True" CssClass="maillist" PageSize="17">
                    <Columns>
                        <asp:TemplateField HeaderText="　">
                            <ItemTemplate>
                                <img src='images/ico_read.gif' alt='read' />
                                <asp:CheckBox ID="IdChkBox" runat="server" Text='<%# Eval("ID") %>' ForeColor="white">
                                </asp:CheckBox>
                            </ItemTemplate>
                            <HeaderTemplate>
                                <asp:CheckBox ID="AllSelChkBox" runat="server" Text="  全选" Style="margin-left: 5px;"
                                    OnCheckedChanged="AllSelChkBox_CheckedChanged" AutoPostBack="True" />
                            </HeaderTemplate>
                            <ItemStyle Width="70px" HorizontalAlign="Left" CssClass="noread"></ItemStyle>
                            <HeaderStyle CssClass="checjboxth" HorizontalAlign="Center"></HeaderStyle>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="主　题" SortExpression="Title">
                            <ItemTemplate>
                                <a href='readBlog.aspx?ID=<%#Eval("ID")%>' target="_blank">
                                    <%# Eval("Title") %>
                                </a>
                            </ItemTemplate>
                            <ItemStyle CssClass="no_read" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="AddDate" HeaderText="发表日期" SortExpression="AddDate">
                            <ItemStyle Width="140px" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="操　作" SortExpression="Title">
                            <ItemTemplate>
                                <a href='writeBlog.aspx?mode=edit&ID=<%#Eval("ID")%>' target="_blank">编辑 </a>
                            </ItemTemplate>
                            <ItemStyle CssClass="no_read" />
                        </asp:TemplateField>
                    </Columns>
                    <PagerStyle HorizontalAlign="Center" />
                    <PagerSettings Mode="NumericFirstLast" />
                </asp:GridView>
                <div class="inboxareaheader">
                    <span class="userbutton">
                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="delete" OnClick="DelLinkButton_Click">删除</asp:LinkButton>
                        <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender2" runat="server" ConfirmText="确定要删除选定的项吗?"
                            TargetControlID="LinkButton1">
                        </ajaxToolkit:ConfirmButtonExtender>
                    </span>
                </div>
            </div>
        </div>
        <asp:ObjectDataSource ID="BlogDS" runat="server" SelectMethod="GetMyBlogs" TypeName="DigitWork.BLL.Blog"
            SortParameterName="sortExpression">
            <SelectParameters>
                <asp:SessionParameter Name="userId" SessionField="CUR_USER_ID" Type="int32" />
                <asp:Parameter Name="findExp" Type="String" />
                <asp:Parameter DefaultValue="ID" Name="sortExpression" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <span class="cc1"><b></b></span><span class="cc2"><b></b></span>
    </form>

    <script type="text/javascript">
        function framesize(srcframe){
            var framename;
            framename = parent.document.getElementById(srcframe);
            if (framename){
	        framename.style.height = document.body.scrollHeight+30;
	        framename.style.width=document.body.scrollWidth;
	        }
	        
        }
        framesize("mainbody");
    </script>

</body>
</html>

