﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class MyBlogs : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //权限
        GridView1.PageSize = PageSize;
    }

    protected void SearchBtn_Click(object sender, EventArgs e)
    {
        if (SearchTextBox.Text.Length <= 0)
        {
            BlogDS.SelectParameters["findExp"].DefaultValue = "";
            BlogDS.DataBind();
            return;
        }

        string key = SearchTextBox.Text.Trim();
        key = key.Replace("'", "''");
        string t = string.Format("Title LIKE '%{0}%' OR Content LIKE '%{0}%'", key);
        BlogDS.SelectParameters["findExp"].DefaultValue = t;
        BlogDS.DataBind();
    }
    

    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }

    protected void DelLinkButton_Click(object sender, EventArgs e)
    {

        bool bSucc = false;
        List<bool> bRetValCol = new List<bool>();
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                bSucc = DigitWork.BLL.Blog.Delete(int.Parse(idCheckBox.Text),DocTran.BLL.User.CurrentUser.ID);
                bRetValCol.Add(bSucc);
            }
        }

        if (bRetValCol.Count == 0)
        {
            MsgLabel.Text = "您至少需要选中一项，才能进行删除操作！";
            MsgPanel.Visible = true;
        }
        else
        {
            GridView1.DataBind();
            int nSucc = bRetValCol.FindAll(Succ).Count;
            int nFail = bRetValCol.FindAll(Fail).Count;

            MsgLabel.Text = string.Format("针对<strong><font color='red'>{0}</font></strong>项进行了删除操作，<strong><font color='red'>{1}</font></strong>项删除成功！",
                    nSucc + nFail, nSucc);
            MsgPanel.Visible = true;
        }
    }

    private static bool Succ(bool val)
    {
        return val == true ? true : false;
    }

    private static bool Fail(bool val)
    {
        return val == false ? true : false;
    }
}
