﻿/**
 * 大连西数网络技术有限公司 (C) 2007
 * 创建日期: 2007.6.8
 * 描述: 
 *     未阅读过的公文列表（未签收）
 * 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class NoReadMailList : DocTran.UI.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //PaddingCtrl.RecordCount = DocTran.BLL.Doc.GetDocCount();
        //Cache.Remove("noreadlist");
        //清除未读公文缓存
        DocTran.BLL.Doc.ClearDocNoReadCache(DocTran.BLL.User.CurrentUser.ID);

        GridView1.PageSize = PageSize;
    }



    //分页
    protected void GridView1_DataBound(object sender, EventArgs e)
    {
        PaddingCtrl.GridView_DataBound(sender, e);
        
    }

    //求记录总数
    protected void DocDS_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {   //先执行 GetDocs 返回 List　对象
        //在执行 GetDocCount　返回 int
        
        if (e.ReturnValue is Int32)
        {
            PaddingCtrl.RecordCount = (int)e.ReturnValue;
            NumLabel.Text = e.ReturnValue.ToString();
        }
    }

    //有附件的用图显示
    protected string AccPic(int docID)
    {
        /* 显示个数
        int nCount = DocTran.BLL.Accessories.GetAccessoriesByDocIdCount(docID);
        if ( nCount!= 0)
            return "<img src='./images/attach.jpg' alt='有" + nCount.ToString() + "个附件' Title='有" + nCount.ToString() + "个附件' />";
        else
            return "";
        */

        /*显示附件列表*/
        List<DocTran.BLL.Accessories> accList = DocTran.BLL.Accessories.GetAccessoriesByDocID(docID);
        if (accList.Count != 0)
        {
            string file = "";
            foreach (DocTran.BLL.Accessories acc in accList)
            {
                decimal fileSize = 0;
                if (acc.FileSize != 0)
                    fileSize = Math.Round(acc.FileSize / 1048576, 2);
                //if ( int.Parse(acc.FileSize) != 0)

                file += acc.DispName + " (" + fileSize.ToString() + "MB)" + "\n\n";
            }
            return "<img src='./images/attach.jpg'   Title='" + file + "' />";

        }
        else
        {
            return "";
        }
    }

}
