﻿/**
 * DaLian Digitwest Network Technologies Co., Ltd.(C) 2007
 * File: AddDeptment.aspx.cs
 * Date: 2007-7-24
 * Author: Xing
 * Description: 
 *      添加部门
 * history:
 *	 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class AddClientCategory : QMClient.UI.QMClientBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        if (Request.QueryString["ID"] != null && ViewState["bSucc"] == null)
        {
            SaveReturnButton.CommandName = "UpdateReturn";
            //SaveAddNextButton.CommandName = "UpdateNext";
            LinkButton1.CommandName = "UpdateReturn";
            //LinkButton2.CommandName = "UpdateNext";

            if (!IsPostBack)
            {
                QMClient.DAL.Table.ClientCategoryTable t = QMClient.BLL.ClientCategory.GetById(int.Parse(Request.QueryString["ID"]));
                if (t != null)
                {
                    CategoryNameTextBox.Text = t.CategoryName;
                }
            }
        }
        

    }
    protected void OnCommand(object sender, CommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Save":
                {
                    if (QMClient.BLL.ClientCategory.IsExist(DocTran.BLL.User.CurrentUser.ID,CategoryNameTextBox.Text.Trim()))
                    {
                        MsgLabel.Text = "已经存在！";
                        MsgPanel.Visible = true;
                    }
                    else
                    {
                        QMClient.BLL.ClientCategory.Insert(CategoryNameTextBox.Text.Trim(), DocTran.BLL.User.CurrentUser.ID, 0);
                        MsgLabel.Text = "添加成功！";
                        MsgLabel.Visible = true;
                        CategoryNameTextBox.Text = "";
                       
                    }
                }
                break;
            
            case "UpdateReturn":
                {
                    int id = int.Parse(Request.QueryString["ID"]);
                    bool bSuccess = QMClient.BLL.ClientCategory.Update(id, CategoryNameTextBox.Text.Trim(), DocTran.BLL.User.CurrentUser.ID, 0);
                    if (bSuccess)
                    {
                        ViewState["bSucc"] = true;
                        MsgLabel.Text = "更新成功，你可以继续添加项！";
                        MsgPanel.Visible = true;
                        CategoryNameTextBox.Text = "";

                    }
                    //Response.Redirect("DeptmentList.aspx");
                }
                break;
            

        }
    }

    protected void DelLinkButton_Click(object sender, CommandEventArgs e)
    {
        //将要删除的用户的分类id 设置为0
        bool retVal = QMClient.BLL.ClientInfo.ResetCategory(DocTran.BLL.User.CurrentUser.ID, Convert.ToInt32(e.CommandArgument));
            
        /* 如果使用判断,分类没有被使用将无法被删除！
         * if ( retVal){
         * 
         */
            QMClient.BLL.ClientCategory.Delete(Convert.ToInt32(e.CommandArgument));
            Response.Redirect("AddClientCategory.aspx");
        
        
        
    }
}
