﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class AddClienterSmsTask : QMClient.UI.QMClientBasePage
{

    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        //根据客户信息取用户基本资料
        if (!string.IsNullOrEmpty(Request.QueryString["ID"] ) && !IsPostBack)
        {
            QMClient.DAL.Table.ClientInfoTable client = QMClient.BLL.ClientInfo.GetById(int.Parse(Request.QueryString["ID"]));
            if (client == null)
            {
                ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "err", "数据错误!", true);
                Response.End();
            }
            NameLbl.Text = client.CName;
            MobileTextBox.Text = client.Mobile;

        }
        

    }



    //验证
    private bool RequirdField()
    {
        if (string.IsNullOrEmpty(Content.Text))
        {
            MsgLabel.Text = "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        if (string.IsNullOrEmpty(MobileTextBox.Text))
        {
            MsgLabel.Text = "请填写手机!";
            MsgPanel.Visible = true;
            return false;
        }

        return true;
    }


    protected void SendButton_Click(object sender, EventArgs e)
    {
        //验证
        if (RequirdField() == false || string.IsNullOrEmpty(Request.QueryString["ID"]))
            return;

        try
        {

            QMClient.DAL.Table.ClientInfoTable client = QMClient.BLL.ClientInfo.GetById(int.Parse(Request.QueryString["ID"]));

            int hour = int.Parse(TimerControl1.Hour);
            int minute = int.Parse(TimerControl1.Min);
            int cur_user_id = DocTran.BLL.User.CurrentUser.ID;

            if (IsBirthday.Checked)//创建生日
            {

                if (string.IsNullOrEmpty(client.Birth)) //生日为空
                {
                    MsgLabel.Text = "资料里没有填写生日";
                    MsgPanel.Visible = true;
                    return;
                }

                //取出用户的生日
                DateTime birth = DateTime.Parse(client.Birth);

                //今年生日日期
                DateTime nowBirth = new DateTime(DateTime.Today.Year, birth.Month, birth.Day, hour, minute, 0);

                //如果生日已经过了，排到下一年
                if (nowBirth < DateTime.Now)
                    nowBirth = nowBirth.AddYears(1);

                //Idcwest.Utils.Debug.Trace(nowBirth.Date < DateTime.Now.Date);
                QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                      0,
                    int.Parse(CategoryDropDownList.SelectedValue),
                    cur_user_id,
                    client.ID,
                    nowBirth,
                    Content.Text.Trim(),
                    int.Parse(RepDrop.SelectedValue), //重复
                    0, //SendMode //暂无明确用途
                    MobileTextBox.Text.Trim(),
                    0, //发送状态 0:排队中 1:已发送
                    1, //运行状态 1:启用 0:不启用
                    ""
                    );
                smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                //向状态机添加，状态机自动会判断是否应该添加。
                QMClient.SmsTaskStack.AddTask(smsTask);
            }
            else //其它提醒
            {

                DateTime sendDT = DateTime.Parse(Date1.Text + " " + hour + ":" + minute);

                if (sendDT < DateTime.Now) //计划时间比当前日期还晚
                {
                    MsgLabel.Text = "不能晚于当前时间！";
                    MsgPanel.Visible = true;
                    return;
                }

                QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                      0,
                    int.Parse(CategoryDropDownList.SelectedValue),
                    cur_user_id,
                    client.ID,
                    sendDT,
                    Content.Text.Trim(),
                    int.Parse(RepDrop.SelectedValue), //重复
                    0, //SendMode //暂无明确用途
                    MobileTextBox.Text.Trim(),
                    0, //发送状态 0:排队中 1:已发送
                    1, //运行状态 1:启用 0:不启用
                    ""
                    );
                smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                //向状态机添加，状态机自动会判断是否应该添加。
                QMClient.SmsTaskStack.AddTask(smsTask);
            }

            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "ok", "alert('添加成功！')", true);
            SendButton.Visible = false;
        }
        catch (Exception ex)
        {
            System.Diagnostics.Debug.WriteLine(ex.Message);
        }
        
    }

    //是否为生日短信
    protected void IsBirthday_CheckedChanged(object sender, EventArgs e)
    {
        Date1.Visible = !IsBirthday.Checked;

        if (IsBirthday.Checked)
        {
            RepDrop.Items.Clear();
            RepDrop.Items.Add(new ListItem("无", "0"));
            RepDrop.Items.Add(new ListItem("每年", "4"));
        }
        else
        {
            RepDrop.Items.Clear();
            RepDrop.Items.Add(new ListItem("无", "0"));
            RepDrop.Items.Add(new ListItem("每日", "1"));
            RepDrop.Items.Add(new ListItem("每周", "2"));
            RepDrop.Items.Add(new ListItem("每月", "3"));
            RepDrop.Items.Add(new ListItem("每年", "4"));
        }
    }
}
