﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class AddSmsTask : QMClient.UI.QMClientBasePage
{

    //接收人列表
    private List<Pair> InUserList = new List<Pair>();  //pair<username,userid>

    private Idcwest.Utils.WorkThread workThread;


    //接收人ID 用","隔开
    //private string _inceptNo = "";
    protected string InceptNo
    {
        set
        {
            //_inceptNo = value;
            ViewState["inceptNo"] = value;
        }
        get
        {
            if (ViewState["inceptNo"] != null)
                return (string)ViewState["inceptNo"];
            else
                return "";
        }
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }



        if (ViewState["userlist"] != null)
            InUserList = (List<Pair>)ViewState["userlist"];


        #region 第一次运行时加载  通讯录

        if (!IsPostBack)
        {
            FillTree();
            //http://www.cnblogs.com/freeliver54/archive/2007/01/05/612393.html
            TreeView1.Attributes.Add("onclick", "postBackByObject()");   //客户端TreeView选中脚本
        }

        #endregion

        //session 中存储正是运行的线程
        if (Session["AddSmsTask"] != null)
        {
            workThread = (Idcwest.Utils.WorkThread)Session["AddSmsTask"];
            switch (workThread.Status)
            {
                case Idcwest.Utils.WorkThreadStatus.Starting:
                    {
                        Timer1.Enabled = true;
                        MsgLabel.Text = "正在发送!" + workThread.ProcessMsg;
                        MsgPanel.Visible = true;
                        SendButton.Visible = false;
                    }
                    break;
                case Idcwest.Utils.WorkThreadStatus.Stop:
                    {
                        MsgLabel.Text = workThread.ProcessMsg; 
                        MsgPanel.Visible = true;
                        SendButton.Visible = true;
                        Session["work"] = null;
                        Timer1.Enabled = false;
                    }
                    break;
            }
        }
        else
        {
            MsgPanel.Visible = false;
        }

    }


    //填充树
    private void FillTree()
    {
        List<QMClient.DAL.Table.ClientCategoryTable> categoryList = QMClient.BLL.ClientCategory.GetClientCategorys(DocTran.BLL.User.CurrentUser.ID);

        foreach (QMClient.DAL.Table.ClientCategoryTable category in categoryList)
        {
            TreeNode root = new TreeNode(category.CategoryName, category.ID.ToString());
            List<QMClient.DAL.Table.ClientInfoTable> clientInfoList = QMClient.BLL.ClientInfo.GetClientInfos(DocTran.BLL.User.CurrentUser.ID, category.ID);
            root.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理

            foreach (QMClient.DAL.Table.ClientInfoTable client in clientInfoList)
            {

                TreeNode child = new TreeNode(client.CName, client.ID.ToString());
                child.SelectAction = TreeNodeSelectAction.None;
                root.ChildNodes.Add(child);
            }

            TreeView1.Nodes.Add(root);
        }

        //无分类的填充
        TreeNode root2 = new TreeNode("无分类", "0");
        List<QMClient.DAL.Table.ClientInfoTable> clientInfoList2 = QMClient.BLL.ClientInfo.GetClientInfos(DocTran.BLL.User.CurrentUser.ID, 0);
        root2.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理
        foreach (QMClient.DAL.Table.ClientInfoTable client2 in clientInfoList2)
        {

            TreeNode child2 = new TreeNode(client2.CName, client2.ID.ToString());
            child2.SelectAction = TreeNodeSelectAction.None;
            root2.ChildNodes.Add(child2);
        }

        TreeView1.Nodes.Add(root2);
    }

    //验证
    private bool RequirdField()
    {
        //收件人,主题,正文,都不能为空.
        if (InUserList.Count == 0 && !AllSelectChkBox.Checked)
        {
            MsgLabel.Text = "请在右边的通讯录中选择收件人!";
            MsgPanel.Visible = true;
            return false;
        }


        if (string.IsNullOrEmpty(Content.Text))
        {
            MsgLabel.Text += "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        return true;
    }


    //选中接收人
    protected void TreeView1_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);
        //取消全部选中
        AllSelectChkBox.Checked = false;

        //对子节点操作
        SetChildChecked(e.Node);

        //填充接收人列表及接收人TextBox
        FillInUser();
    }

    //递归选中子节点
    private void SetChildChecked(TreeNode parentNode)
    {
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = parentNode.Checked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node); //递归子节点
            }
        }
    }

    //所有部门人员的全选
    private void SetAllChecked(TreeNode parentNode, bool chked)
    {
        parentNode.Checked = chked;
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = chked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //填充接收人列表及接收人TextBox
    protected void FillInUser()
    {
        InUserList.Clear();     //填充前先清空
        InUserTextBox.Text = "";
        InceptNo = "";

        // Fill InUserList
        foreach (TreeNode node in TreeView1.Nodes)
            FillInUserList(node);

        ViewState["userlist"] = InUserList;

        FillInUserTextBox();

    }

    //递归调用填充收件人
    private void FillInUserList(TreeNode rootNode)
    {


        foreach (TreeNode node in rootNode.ChildNodes)
        {
            if (node.Checked)
            {
                InUserList.Add(new Pair(node.Text, node.Value));
            }

            if (node.ChildNodes.Count > 0)
            {
                FillInUserList(node);
            }
        }
    }

    //填充收件人TexBox
    private void FillInUserTextBox()
    {

        if (InUserList.Count != 0)
        {
            string inUsername = "";
            foreach (Pair pair in InUserList)
            {
                inUsername += pair.First.ToString() + ",";
                //InceptNo += pair.Second.ToString() + ",";
            }

            //去除最后一个","
            //InceptNo = InceptNo.Remove(InceptNo.LastIndexOf(","));

            inUsername = inUsername.Remove(inUsername.LastIndexOf(","));
            InUserTextBox.Text = inUsername;
            InUserTextBox.Style.Add("color", "red");
        }
        else if (!AllSelectChkBox.Checked) //未选中全部
        {
            InUserTextBox.Text = "请从右边通讯录选择收件人";
            InUserTextBox.Style.Add("color", "#cccccc");
        }
    }

    //全部发送
    protected void AllSelectChkBox_CheckedChanged(object sender, EventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        //foreach (TreeNode node in TreeView1.Nodes)
        //    SetAllChecked(node, AllSelectChkBox.Checked);

        //FillInUser();
        if (AllSelectChkBox.Checked)
        {
            InUserTextBox.Text = "全部联系人";
            InUserTextBox.Style.Add("color", "Blue");
        }
        else
        {
            InUserTextBox.Text = "请从右边通讯录选择收件人";
            InUserTextBox.Style.Add("color", "#cccccc");
        }
    }


    //创建短信提醒任务
    /*
     * if ( AllSelected )
     *    为每一个人创建任务
     * else
     *    为选中的人创建任务
     */
    protected void SendButton_Command(object sender, CommandEventArgs e)
    {

        //验证
        if (RequirdField() == false)
            return;


        //由于操作对象多，用户界面反应迟钝，采用多线程后台处理
        if (AllSelectChkBox.Checked)
        {
            workThread = new Idcwest.Utils.WorkThread();
            workThread.Work += new Idcwest.Utils.WorkThread.WorkEvent(workThread_Work);
            workThread.UserID = DocTran.BLL.User.CurrentUser.ID;

            workThread.UserList = InUserList;
            Session["AddSmsTask"] = workThread;

            workThread.Run();

            SendButton.Visible = false;
            Timer1.Enabled = true;

            MsgLabel.Text = "正在处理!";
            MsgPanel.Visible = true;
        }
        else
        {
            workThread = new Idcwest.Utils.WorkThread();
            workThread.Work += new Idcwest.Utils.WorkThread.WorkEvent(workThread_Work);
            workThread.UserID = DocTran.BLL.User.CurrentUser.ID;
            //workThread.IsSendAll = false;
            workThread.UserList = InUserList;
            Session["AddSmsTask"] = workThread;

            workThread.Run();

            SendButton.Visible = false;
            Timer1.Enabled = true;

            MsgLabel.Text = "正在处理!";
            MsgPanel.Visible = true;
        }


    }

    //时间钟 显示线程工作进度
    protected void Timer1_Tick(object sender, EventArgs e)
    {
        MsgLabel.Text = workThread.ProcessMsg;
        if (workThread != null && workThread.Status == Idcwest.Utils.WorkThreadStatus.Stop )
            SendButton.Visible = true;
    }

    //线程
    void workThread_Work(object sender, Idcwest.Utils.WorkThread.WorkEventArgs e)
    {


        int hour = int.Parse(TimerControl1.Hour);
        int minute = int.Parse(TimerControl1.Min);
        Idcwest.Utils.WorkThread wt = sender as Idcwest.Utils.WorkThread;
        if (AllSelectChkBox.Checked && IsBirthday.Checked)//全部生日
        {
            int i = 1;
            //获取此用户的所有联系人
            List<QMClient.DAL.Table.ClientInfoTable> clientlist = QMClient.BLL.ClientInfo.GetClientInfos(e.userId, 0, "", "");
            foreach (QMClient.DAL.Table.ClientInfoTable client in clientlist)
            {
                try
                {
                    //取出用户的生日
                    DateTime birth = DateTime.Parse(client.Birth);

                   
                    //今年生日日期
                    DateTime nowBirth = new DateTime(DateTime.Today.Year, birth.Month, birth.Day, hour, minute, 0);

                    //如果生日已经过了，排到下一年
                    if (nowBirth < DateTime.Now)
                        nowBirth = nowBirth.AddYears(1);

                    QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                                      0,
                                      int.Parse(CategoryDropDownList.SelectedValue),
                                      e.userId,
                                      client.ID,
                                      nowBirth,
                                      Content.Text.Trim(),
                                      int.Parse(RepDrop.SelectedValue), //重复
                                      0, //SendMode //暂无明确用途
                                      client.Mobile,
                                      0, //发送状态 0:排队中 1:已发送
                                      1, //运行状态 1:启用 0:不启用
                                      ""
                    );

                    smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                    //向状态机添加，状态机自动会判断是否应该添加。
                    QMClient.SmsTaskStack.AddTask(smsTask);

                    wt.ProcessMsg = string.Format("({0}/{1})正在处理 [{2}]", i++, clientlist.Count, client.CName);
                    System.Threading.Thread.Sleep(1000);

                }
                catch (FormatException ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.Message);
                    Idcwest.Utils.Debug.Trace(ex);

                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.Message);
                    Idcwest.Utils.Debug.Trace(ex);
                }

                finally
                {
                    e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                }
            }
        }
        else if (AllSelectChkBox.Checked)  //全部
        {
            //发送至全部客户手机
            int i = 1;
            DateTime sendDT = DateTime.Parse(Date1.Text + " " + hour + ":" + minute);

            if (sendDT < DateTime.Now) //计划时间比当前日期还晚
            {
                 wt.ProcessMsg = "不能晚于当前时间！"; 
               
                e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                return;
            }

            //获取此用户的所有联系人
            List<QMClient.DAL.Table.ClientInfoTable> clientlist = QMClient.BLL.ClientInfo.GetClientInfos(e.userId, 0, "", "");
            foreach (QMClient.DAL.Table.ClientInfoTable client in clientlist)
            {
                try
                {
                    if (string.IsNullOrEmpty(client.Mobile))
                        continue;

                    QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                                      0,
                                      int.Parse(CategoryDropDownList.SelectedValue),
                                      e.userId,
                                      client.ID,
                                      sendDT,
                                      Content.Text.Trim(),
                                      int.Parse(RepDrop.SelectedValue), //重复
                                      0, //SendMode //暂无明确用途
                                     client.Mobile,
                                      0, //发送状态 0:排队中 1:已发送
                                      1, //运行状态 1:启用 0:不启用
                                      ""
                    );

                    smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                    //向状态机添加，状态机自动会判断是否应该添加。
                    QMClient.SmsTaskStack.AddTask(smsTask);

                    wt.ProcessMsg = string.Format("({0}/{1})正在处理 [{2}]", i++, clientlist.Count, client.CName);
                    System.Threading.Thread.Sleep(1000);
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.Message);
                    Idcwest.Utils.Debug.Trace(ex);
                }
                finally {
                    e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                }

            }
        }
        else if ( IsBirthday.Checked ) //用户自定义部分生日
        {

            int i = 1;
            

            foreach (Pair p in e.userList)
            {
                try
                {
                    int clientid = Convert.ToInt32(p.Second);
                    QMClient.DAL.Table.ClientInfoTable client = QMClient.BLL.ClientInfo.GetById(clientid); //取用户的手机
                   
                    //取出用户的生日
                    DateTime birth = DateTime.Parse(client.Birth);

                    
                    //今年生日日期
                    DateTime nowBirth = new DateTime(DateTime.Today.Year, birth.Month, birth.Day, hour, minute, 0);

                    //如果生日已经过了，排到下一年
                    if (nowBirth < DateTime.Now)
                        nowBirth = nowBirth.AddYears(1);


                    QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                                      0,
                                      int.Parse(CategoryDropDownList.SelectedValue),
                                      e.userId,
                                      clientid,
                                      nowBirth,
                                      Content.Text.Trim(),
                                      int.Parse(RepDrop.SelectedValue), //重复
                                      0, //SendMode //暂无明确用途
                                     client.Mobile,
                                      0, //发送状态 0:排队中 1:已发送
                                      1, //运行状态 1:启用 0:不启用
                                      ""
                    );

                    smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                    //向状态机添加，状态机自动会判断是否应该添加。
                    QMClient.SmsTaskStack.AddTask(smsTask);

                    wt.ProcessMsg = string.Format("({0}/{1})正在处理 [{2}]", i++, e.userList.Count, p.First.ToString());
                    System.Diagnostics.Debug.WriteLine(p.First.ToString() + ":" + p.Second.ToString());
                    System.Threading.Thread.Sleep(1000);
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.Message);
                    Idcwest.Utils.Debug.Trace(ex);
                }
                finally {
                    e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                }
            }

        }
        else  //用户自定义部分
        {

            int i = 1;
            DateTime sendDT = DateTime.Parse(Date1.Text + " " + hour + ":" + minute);

            if (sendDT < DateTime.Now) //计划时间比当前日期还晚
            {
                wt.ProcessMsg = "不能晚于当前时间！";
                
                e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                return;
            }

            foreach (Pair p in e.userList)
            {
                try
                {
                    int clientid = Convert.ToInt32(p.Second);
                    string mobile = QMClient.BLL.ClientInfo.GetById(clientid).Mobile; //取用户的手机
                    if (string.IsNullOrEmpty(mobile))
                        continue;


                    QMClient.DAL.Table.SmsTaskTable smsTask = new QMClient.DAL.Table.SmsTaskTable(
                                      0,
                                      int.Parse(CategoryDropDownList.SelectedValue),
                                      e.userId,
                                      clientid,
                                      sendDT,
                                      Content.Text.Trim(),
                                      int.Parse(RepDrop.SelectedValue), //重复
                                      0, //SendMode //暂无明确用途
                                     mobile,
                                      0, //发送状态 0:排队中 1:已发送
                                      1, //运行状态 1:启用 0:不启用
                                      ""
                    );

                    smsTask.ID = QMClient.BLL.SmsTask.Insert(smsTask);
                    //向状态机添加，状态机自动会判断是否应该添加。
                    QMClient.SmsTaskStack.AddTask(smsTask);

                    wt.ProcessMsg = string.Format("({0}/{1})正在处理 [{2}]", i++, e.userList.Count, p.First.ToString());
                    System.Diagnostics.Debug.WriteLine(p.First.ToString() + ":" + p.Second.ToString());
                    System.Threading.Thread.Sleep(1000);
                }
                catch (Exception ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.Message);
                    //Idcwest.Utils.Debug.Trace(ex);
                }
                finally {
                    e.status = Idcwest.Utils.WorkThreadStatus.Stop;
                }
            }

        }


        wt.ProcessMsg = "操作完成！";
        e.status = Idcwest.Utils.WorkThreadStatus.Stop;
        //workThread.Status = Idcwest.Utils.WorkThreadStatus.Stop;
    }

    public string CodeStatus(int code)
    {
        string retVal = "";
        if (code == 1)
            retVal = "发送成功";
        else if (code == -10)
            retVal = "字数太多";
        else if (code == -30)
            retVal = "余额不足";
        else if (code == -20)
            retVal = "用户或密码错误";
        else if (code == -40)
            retVal = "发送失败";
        else if (code == -1)
            retVal = "发送错误";
        return retVal;

    }

    //是否为生日短信
    protected void IsBirthday_CheckedChanged(object sender, EventArgs e)
    {
        Date1.Visible = !IsBirthday.Checked;

    }
}
