﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class AddSmsTask : QMClient.UI.QMClientBasePage
{

    
    protected void Page_Load(object sender, EventArgs e)
    {
        //if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMSms))
        //{
        //    Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
        //    Response.End();
        //}


        if (Request.QueryString["ID"] != null && !IsPostBack)
        {
           QMClient.DAL.Table.SmsTaskTable task  =  QMClient.BLL.SmsTask.GetById(int.Parse(Request.QueryString["ID"]));
           if (task == null)
           {
               ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "err", "数据错误!", true);
               Response.End();
           }

           CategoryDropDownList.Text = task.TaskCategoryID.ToString();
           MobileTextBox.Text = task.Mobile;
           Content.Text = task.SmsContent;
           Date1.Text = task.TaskDateTime.ToShortDateString();
           TimerControl1.Hour = task.TaskDateTime.Hour.ToString();
           TimerControl1.Min = task.TaskDateTime.Minute.ToString();
           RepDrop.Text = task.RepStatus.ToString();
           RunDrop.Text = task.RunStatus.ToString();  
        }
      

    }



    //验证
    private bool RequirdField()
    {
        if (string.IsNullOrEmpty(Content.Text))
        {
            MsgLabel.Text += "请填写正文!";
            MsgPanel.Visible = true;
            return false;
        }
        if (string.IsNullOrEmpty(MobileTextBox.Text))
        {
            MsgLabel.Text += "请填写手机!";
            MsgPanel.Visible = true;
            return false;
        }

        return true;
    }


    protected void SendButton_Click(object sender, EventArgs e)
    {
        //验证
        if (RequirdField() == false && Request.QueryString["ID"] == null)
            return;

        DateTime sendDT = DateTime.Parse(Date1.Text + " " + TimerControl1.Hour + ":" + TimerControl1.Min);

        if (sendDT < DateTime.Now) //计划时间比当前日期还晚
        {
            MsgLabel.Text = "不能晚于当前时间！";
            MsgPanel.Visible = true;
            return;
        }


        QMClient.DAL.Table.SmsTaskTable task = QMClient.BLL.SmsTask.GetById(int.Parse(Request.QueryString["ID"]));

        
        task.TaskCategoryID = int.Parse(CategoryDropDownList.Text);
        task.Mobile = MobileTextBox.Text.Trim();
        task.SmsContent = Content.Text;

        task.TaskDateTime = sendDT;
        task.RepStatus = int.Parse(RepDrop.SelectedValue);
        task.RunStatus = int.Parse(RunDrop.SelectedValue);
        task.SmsStatus = 0;
        

        if (QMClient.DAL.DataProvider.SmsTask.Update(task))
        {
            
            MsgLabel.Text = "更新成功！";
            MsgPanel.Visible = true;

            //更改状态机中信息的状态
            //如果系统为运行状态则修改，否则从状态机里删除。
            if (task.RunStatus == (int)QMClient.SmsRunStatus.Run)
                QMClient.SmsTaskStack.UpdateTask(task);
            else
                QMClient.SmsTaskStack.DelTask(task);


            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", "alert('更新成功');", true);
        }
    }

    
}
