﻿/**
 * 大连西数网络技术有限公司 (C)2005-2008
 * 创建日期: 2008.6.17
 * 描述: 
 *     短信提醒业务
 * 
 */
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;
public partial class MySmsTask : QMClient.UI.QMClientBasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        GridView1.PageSize = QMClient.BLL.ClientInfo.Settings.PageSize;

        if (!string.IsNullOrEmpty(Request.QueryString["key"]))
        {
            SearchTextBox.Text = Request.QueryString["key"];
        }

       
    }


    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }
  

  
    private static bool Succ(Pair p)
    {
        return Convert.ToInt32(p.Second) == 1 ? true : false;
    }


    protected string SubStr(string str, int length)
    {
        if (str != null && str.Length > length)
            return str.Substring(0, length) + "...";
        return str;
    }

    protected void DelButton_Click(object sender, EventArgs e)
    {
        bool retVal = false;
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                
                int id = int.Parse(idCheckBox.Text);
                retVal = QMClient.BLL.SmsTask.Delete(id);
                if (retVal)
                    QMClient.SmsTaskStack.DelTask(id);
            }
        }

        if (retVal)
        {
            GridView1.DataBind();
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", "alert('删除成功！');", true);

        }
        else
        {
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", "alert('请先选中要删除的项！');", true);
        }
    }

    
   
}
