﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ReadClienter : QMClient.UI.QMClientBasePage
{



    protected void Page_Load(object sender, EventArgs e)
    {

        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.QMClient))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        if (Request.QueryString["ID"] != null)
        {

            if (!IsPostBack)
            {
                QMClient.DAL.Table.ClientInfoTable client = QMClient.BLL.ClientInfo.GetById(int.Parse(Request.QueryString["ID"]));
                if (client != null)
                {
                    CNameLabel.Text = client.CName;
                    //Response.Write(client.Sex.CompareTo("男"));
                    SexLabel.Text = client.Sex;
                    MobileLabel.Text = client.Mobile;
                    PhoneLabel.Text = client.Phone;
                    AddressLabel.Text = client.Address;
                    EmailLabel.Text = client.Email;
                    RemarkLabel.Text = client.Remark;
                    BirthLabel.Text = client.Birth;

                    PhoneCallBtn.CommandArgument = client.Mobile;
                    PhoneCallBtn2.CommandArgument = client.Phone;
                    MobileTxtBox.Text = client.Mobile;
                }
            }
        }


    }

    protected void DelLinkButton_Click(object sender, EventArgs e)
    {
        bool retVal = QMClient.BLL.ClientInfo.Delete(int.Parse(Request.QueryString["ID"]));

        if (retVal)
        {
            //是否需要删除与之相关的短信

            Response.Redirect("MyClienter.aspx");
        }

    }

    //删除短信
    protected void DelButton_Click(object sender, EventArgs e)
    {
        bool retVal = false;
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null && idCheckBox.Checked)
            {
                int id = int.Parse(idCheckBox.Text);
                retVal = QMClient.BLL.SmsTask.Delete(id);
                if (retVal)
                    QMClient.SmsTaskStack.DelTask(id);
            }
        }

        if (retVal)
        {
            GridView1.DataBind();
            
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", "alert('删除成功！');", true);
        }
        else
        {
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", "alert('请先选中要删除的项！');", true);
        }
    }


    protected string SubStr(string str, int length)
    {
        if (str != null && str.Length > length)
            return str.Substring(0, length) + "...";
        return str;
    }
    //全选
    protected void AllSelChkBox_CheckedChanged(object sender, EventArgs e)
    {
        CheckBox selectCheckBox = (CheckBox)sender;

        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            CheckBox idCheckBox = (CheckBox)GridView1.Rows[i].Cells[0].FindControl("IdChkBox");

            if (idCheckBox != null)
            {
                idCheckBox.Checked = selectCheckBox.Checked;
            }
        }
    }

    //返回后刷新改动 
    protected void ClosePanelBtn_Click(object sender, EventArgs e)
    {
        GridView1.DataBind();
        UpdatePanel12.Update();
        ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "at", " framesize('mainbody')", true);
    }


    //打电话和发送短信
    protected void PhoneAndSms_OnCommand(object sender, CommandEventArgs e)
    {
        string phone = e.CommandArgument.ToString();
        switch (e.CommandName)
        {
            case "Phone":
                {

                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "call", "window.location='" + QMClient.Skype.Call(phone) + "'", true);
                }
                break;
            case "Sms":
                {
                    /*
                    QMClient.Sms sms = new QMClient.Sms();
                    int retVal = sms.Send(phone, Content.Text.Trim(), DateTime.Now.ToString());
                    string alert = string.Format("alert('{0}')", sms.CodeStatus(retVal));
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "err", alert, true);
                     * */
                }
                break;

        }
    }

    //发送短信
    protected void OnSendSmsButton(object sender, EventArgs e)
    {

        QMClient.Sms sms = new QMClient.Sms();
        int retVal = sms.Send(MobileTxtBox.Text.Trim(), Content.Text.Trim(), DateTime.Now.ToString());
        string alert = string.Format("alert('{0}')", sms.CodeStatus(retVal));
        ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "err", alert, true);
    }

}
