﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class ReadBlog : System.Web.UI.Page
{
    #region meta

    private string _sendUserName = "";
    public string SendUserName
    {
        set
        {
            _sendUserName = value;
        }
        get
        {
            return _sendUserName;
        }
    }
 

    private string _sendDate = "";
    public string SendDate
    {
        set
        {
            _sendDate = value;
        }
        get
        {
            return _sendDate;
        }
    }

    private string _subject = "";
    public string Subject
    {
        set
        {
            _subject = value;
        }
        get
        {
            return _subject;
        }
    }

    private string _contnet = "";
    public string Content
    {
        set
        {
            _contnet = value;
        }
        get
        {
            return _contnet;
        }
    }
    
    private int _id = 0;
    public int BlogID
    {
        set
        {
            _id = value;
        }
        get
        {
            return _id;
        }
    }

    private List<int> _idList = new List<int>();
    public List<int> IdList
    {
        set { _idList = value; }
        get { return _idList; }
    }
    #endregion meta

    protected void Page_Load(object sender, EventArgs e)
    {
        //权限

        DigitWork.BLL.Blog blog = null;

        if (Request.QueryString["ID"] != null)
        {
            BlogID = int.Parse(Request.QueryString["ID"]);

            blog = DigitWork.BLL.Blog.GetById(BlogID);
            if (blog != null)
            {
                // ViewState["mail"] = mail;
                //取评论
                BlogForum1.BlogID = BlogID;
                BlogForum1.Page = this.Page;

                
                if (blog.IsLog &&　
                    blog.UserID != DocTran.BLL.User.CurrentUser.ID   //自己不记录
                    && DocTran.BLL.User.CurrentUser.ID != 1　　　　　//超级管理员不记录
                    && DocTran.BLL.User.CurrentUser.ID != 0          //有时超时，不记录
                    )
                {
                    //记录查看的人
                    DigitWork.BLL.WhoSee.Insert(BlogID, DocTran.BLL.User.CurrentUser.ID);
                                       
                }
                
                ////显示查看过日志的人
                DispWhoSee();

                //显示日志
                SendUserName = blog.FullName;
                SendDate = FormatDate(blog.AddDate);
                Subject = blog.Title;
                Content = blog.Content;

                //初始上一个，下一个
                InitPrvNextLink();

                //如果是自己的blog编辑可见
                if (DocTran.BLL.User.CurrentUser.ID == blog.UserID || DocTran.BLL.User.CurrentUser.ID ==1)
                {
                    EditLink.Visible = true;
                    EditLink.NavigateUrl = "~/WriteBlog.aspx?mode=edit&ID=" + BlogID.ToString();
                }
            }

        }
               
    }

    protected void DispWhoSee()
    {
        //取出查看的人
        List<DigitWork.BLL.WhoSee> whoSeeList = DigitWork.BLL.WhoSee.GetWhoSees(BlogID);
        if (whoSeeList.Count > 0)
        {
            WhoSeeListRepCtrl.DataSource = whoSeeList;
            WhoSeeListRepCtrl.DataBind();
        }
       
    }
     

    protected void InitPrvNextLink()
    {
        #region 提取上一个,下一个
        
        List<DigitWork.BLL.Blog> blogList = null;
        
        blogList = DigitWork.BLL.Blog.GetBlogs("", "", 0, 0);
        
        for (int i = 0; i < blogList.Count; i++)
        {
            if (BlogID == blogList[i].ID)
            {
                if (i != 0) //上一个   
                {
                    //应用在未读公文
                    string url = "readBlog.aspx?ID=" + blogList[i - 1].ID.ToString(); ;
                    PrvLink.Text = "上一篇: "+blogList[i-1].Title;
                    PrvLink.NavigateUrl = url;
                  
                }
                else
                {
                    PrvLink.Visible = false;
                  
                }
                //下一个                
                if (i != blogList.Count - 1)
                {
                    string url = "readBlog.aspx?ID=" + blogList[i + 1].ID.ToString(); ;
                    NextLink.Text =  "下篇更精彩: "+blogList[i+1].Title;
                    NextLink.NavigateUrl = url;
                    
                }
                else
                {
                    NextLink.Visible = false;
                }

                break;
            }
        }

        #endregion
    }

    protected string FormatDate(DateTime dt)
    {
        if (dt.Date == DateTime.Today)
            return "今天&nbsp" + dt.ToShortTimeString();
        else if (dt.Date == DateTime.Today.AddDays(-1))
            return "昨天&nbsp " + dt.ToShortTimeString();

        return dt.ToString();
    }

    protected string FormatDate2(DateTime dt)
    {
        string sVal = "";

        //当前时间-发布时间
        TimeSpan v = DateTime.Now.Subtract(dt);

        if (Convert.ToInt32(v.TotalDays) != 0)
        {
            //大于一天
            sVal = Math.Abs(Convert.ToInt32(v.TotalDays)) + "天前";
        }
        else
        {
            if ((Convert.ToInt32(v.TotalMinutes) < 5) && (Convert.ToInt32(v.TotalHours) == 0))
            {
                sVal = "刚才";
            }
            else if ((Convert.ToInt32(v.TotalMinutes) > 5) && (Convert.ToInt32(v.TotalHours) == 0))
            {
                sVal = Convert.ToInt32(v.TotalMinutes) % 60 + " 分钟前";
            }
            else if (Convert.ToInt32(v.TotalHours) != 0)
            {
                sVal = "" + Convert.ToInt32(v.TotalHours) + " 小时" + Convert.ToInt32(v.TotalMinutes) % 60 + " 分前";
            }
            else
            {
                sVal = Convert.ToInt32(v.TotalMinutes) % 60 + " 分钟前";
            }
        }
        return sVal;
    }
}
