﻿/**
 * 大连西数网络技术有限公司 (C) 2007
 * 文件名: ReadUserMail.aspx.cs
 * 创建日期: 2007.6.17
 * 描述: 
 *      阅读已发公文
 * 
 */

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Utils = Idcwest.WebLibrary.Utils;

public partial class ReadUserMail : DocTran.UI.BasePage
{

    //public DocTran.BLL.Doc Mail
    //{
    //    get
    //    {
    //        if (ViewState["mail"] != null)
    //        {
    //            _mail = (DocTran.BLL.Doc)ViewState["mail"];
    //        }
    //        else
    //        {
    //            if (Request.QueryString["ID"] != null)
    //            {
    //                int docId = int.Parse(Request.QueryString["ID"]);
    //                _mail = DocTran.BLL.Doc.GetDocByID(docId);
    //                if (_mail != null)
    //                    ViewState["mail"] = _mail;

    //            }
    //        }
    //    }
    //}

    /// <summary>
    /// 发件人
    /// </summary>
    private string _sendUserName = "";
    public string SendUserName
    {
        set
        {
            _sendUserName = value;
        }
        get
        {
            return _sendUserName;
        }
    }
    private string _inceptUserName = "";
    public string InceptUserName
    {
        set
        {
            _inceptUserName = value;
        }
        get
        {
            return _inceptUserName;
        }
    }

    private string _sendDate = "";
    public string SendDate
    {
        set
        {
            _sendDate = value;
        }
        get
        {
            return _sendDate;
        }
    }

    private string _subject = "";
    public string Subject
    {
        set
        {
            _subject = value;
        }
        get
        {
            return _subject;
        }
    }

    private string _contnet = "";
    public string Content
    {
        set
        {
            _contnet = value;
        }
        get
        {
            return _contnet;
        }
    }

    private string _acc = "";
    public string Acc
    {
        set
        {
            _acc = value;
        }
        get
        {
            return _acc;
        }
    }

    private int _docId = 0;
    public int DocID
    {
        set
        {
            _docId = value;
        }
        get
        {
            return _docId;
        }
    }

    private List<int> _idList = new List<int>();
    public List<int> IdList
    {
        set { _idList = value; }
        get { return _idList; }
    }


    private int _prvIndex = 0;
    public int PrvIndex
    {
        set { _prvIndex = value; }
        get { return _prvIndex; }
    }

    private int _nextIndex = 0;
    public int NextIndex
    {
        set { _nextIndex = value; }
        get { return _nextIndex; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        DocTran.BLL.Doc mail = null;

        if (Request.QueryString["ID"] != null)
        {
            DocID = int.Parse(Request.QueryString["ID"]);
            mail = DocTran.BLL.Doc.GetDocByID(DocID);
            if (mail != null)
            {

                InceptUserName = NoListToNameList(mail.InceptNo, 0);
                SendDate = mail.SendDate.ToString();
                Subject = mail.Title;
                Content = mail.Content;
                //Acc = mail.Accessories;

                InitPrvNextLink();

            }

        }

        //if (Request.QueryString["fid"] != null && Request.QueryString["fid"] == "all")
        //{
        //    DocHyperLink.NavigateUrl = "MailList.aspx";
        //    DocHyperLink2.NavigateUrl = "MailList.aspx";
        //}

    }

    /// <summary>
    /// 将接收用户号转换成真实姓名
    /// </summary>
    /// <param name="noList">用户号列表</param>
    /// <param name="bShort">是否只显示部分</param>
    /// <returns></returns>
    protected string NoListToNameList(string noList, int len)
    {
        string temp = "";
        if (ViewState["list"] != null)
        {
            temp = (string)ViewState["list"];
        }
        else
        {
            ViewState["list"] = DocTran.BLL.User.UserNoToUserName(noList);
            temp = (string)ViewState["list"];
        }
        if (temp == "") return "";

        if (len != 0)
            return temp.Substring(0, len) + "...";
        else
            return temp;
    }

    protected void InitPrvNextLink()
    {
        #region 提取上一个,下一个
        //List<DocTran.BLL.Doc> docList = null;
        //if (Cache["noreadlist"] != null)
        //{
        //    docList = (List<DocTran.BLL.Doc>)Cache["noreadlist"];
        //}
        //else
        //{
        //    docList = DocTran.BLL.Doc.GetDocNoRead(DocTran.BLL.User.CurrentUserID, "", 0, int.MaxValue - 1);
        //    Cache.Insert("noreadlist", docList);
        //}
        List<DocTran.BLL.Doc> docList = null;


        docList = DocTran.BLL.Doc.GetDocsByUserID(DocTran.BLL.User.CurrentUser.ID, "", 0, int.MaxValue - 1);


        for (int i = 0; i < docList.Count; i++)
        {
            if (DocID == docList[i].ID)
            {
                if (i != 0) //上一个   
                {
                    string url = "readUserMail.aspx?ID=" + docList[i - 1].ID.ToString(); ;

                    PrvLink.NavigateUrl = url;
                    PrvLink2.NavigateUrl = url;
                }
                else //第一个
                {
                    PrvLink.Visible = false;
                    PrvLink2.Visible = false;
                }



                if (i != docList.Count - 1)
                {
                    string url = "readUserMail.aspx?ID=" + docList[i + 1].ID.ToString(); ;

                    NextLink.NavigateUrl = url;
                    NextLink2.NavigateUrl = url;
                }
                else //最后一个
                {
                    NextLink.Visible = false;
                    NextLink2.Visible = false;
                }

                break;
            }
        }

        #endregion
    }

    public string BytesToMBOrKb(decimal bytes)
    {
        if (bytes == 0)
            return "0";

        decimal size = Utils.XConvert.BytesToMB(bytes, 2);
        string retVal = size.ToString() + "MB";
        if (size == 0)
        {
            size = Utils.XConvert.BytesToKB(bytes, 2);
            retVal = size.ToString() + "KB";
        }
        return retVal;
    }

    public string SignStatus(DateTime signDate)
    {
        bool retVal = DocTran.BLL.DocSign.IsSign(signDate);

        if (retVal)
            return "已签收";
        else
            return "<span style='color:red;'>未签收</span>";

    }

   //根据用户ID 取部门
    public string GetDeptmentByUserId(int userID)
    {
        return DocTran.BLL.User.GetDeptmentByUserId(userID);
    }
}
