﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

using Brettle.Web.NeatUpload;

public partial class Sms : DocTran.UI.BasePage
{
    
    //接收人列表
    private List<Pair> InUserList = new List<Pair>();  //pair<username,userid>
       

    //接收人ID 用","隔开
    //private string _inceptNo = "";
    protected string InceptNo
    {
        set
        {
            //_inceptNo = value;
            ViewState["inceptNo"] = value;
        }
        get
        {
            if (ViewState["inceptNo"] != null)
                return (string)ViewState["inceptNo"];
            else
                return "";
        }
    }
   

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!DocTran.Rule.IsInRole(DocTran.BLL.User.CurrentUser, DocTran.Role.SendSMS))
        {
            Idcwest.WebLibrary.Utils.JavaScript.AlertBack("您没有主够的操作权限！");
            Response.End();
        }

        if (ViewState["userlist"] != null)
            InUserList = (List<Pair>)ViewState["userlist"];


        #region 第一次运行时加载  通讯录

        if (!IsPostBack)
        {
            FillTree();
            //http://www.cnblogs.com/freeliver54/archive/2007/01/05/612393.html
            TreeView1.Attributes.Add("onclick", "postBackByObject()");   //客户端TreeView选中脚本


            SendUserNameTextBox.Text = DocTran.BLL.User.CurrentUser.FullName;
            SignatureTextBox.Text = Settings.Signature;
        }

        #endregion

      

    }


    /// <summary>
    /// 填充部门用户树
    /// </summary>
    private void FillTree()
    {
        List<DocTran.BLL.Deptment> deptList = DocTran.BLL.Deptment.GetDeptments();
        foreach (DocTran.BLL.Deptment dept in deptList)
        {
            TreeNode root = new TreeNode(dept.DeptName, dept.ID.ToString());
            List<DocTran.BLL.User> userList = DocTran.BLL.User.GetUsersByDeptID(dept.ID);
            root.SelectAction = TreeNodeSelectAction.None; //节点不响应事件处理

            foreach (DocTran.BLL.User user in userList)
            {
                if (user.ID == DocTran.BLL.User.CurrentUser.ID)  //不在列表中添加自己的姓名
                    continue;

                TreeNode child = new TreeNode(user.FullName, user.ID.ToString());
                child.SelectAction = TreeNodeSelectAction.None;
                root.ChildNodes.Add(child);
            }

            TreeView1.Nodes.Add(root);
        }
    }

   

    //选中接收人
    protected void TreeView1_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        //对子节点操作
        SetChildChecked(e.Node);

        //填充接收人列表及接收人TextBox
        FillInUser();
    }

    //单个部门的全部选定与取消
    private void SetChildChecked(TreeNode parentNode)
    {
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = parentNode.Checked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //所有部门人员的全选
    private void SetAllChecked(TreeNode parentNode, bool chked)
    {
        parentNode.Checked = chked;
        foreach (TreeNode node in parentNode.ChildNodes)
        {
            node.Checked = chked;

            if (node.ChildNodes.Count > 0)
            {
                SetChildChecked(node);
            }
        }
    }

    //填充接收人列表及接收人TextBox
    protected void FillInUser()
    {
        InUserList.Clear();
        InUserTextBox.Text = "";
        InceptNo = "";

        // Fill InUserList
        foreach (TreeNode node in TreeView1.Nodes)
            FillInUserList(node);

        ViewState["userlist"] = InUserList;

        FillInUserTextBox();

    }

    //递归调用填充收件人
    private void FillInUserList(TreeNode rootNode)
    {


        foreach (TreeNode node in rootNode.ChildNodes)
        {
            if (node.Checked)
            {
                InUserList.Add(new Pair(node.Text, node.Value));
            }

            if (node.ChildNodes.Count > 0)
            {
                FillInUserList(node);
            }
        }
    }

    //填充收件人TexBox
    private void FillInUserTextBox()
    {

        if (InUserList.Count != 0)
        {
            string inUsername = "";
            foreach (Pair pair in InUserList)
            {
                inUsername += pair.First.ToString() + ",";
                //InceptNo += pair.Second.ToString() + ",";
            }

            //去除最后一个","
            //InceptNo = InceptNo.Remove(InceptNo.LastIndexOf(","));

            inUsername = inUsername.Remove(inUsername.LastIndexOf(","));
            InUserTextBox.Text = inUsername;
            InUserTextBox.Style.Add("color", "red");
        }
        else
        {
            InUserTextBox.Text = "请从右边通讯录选择收件人";
            InUserTextBox.Style.Add("color", "#cccccc");
        }
    }

    /// <summary>
    /// 通讯录全选
    /// </summary>
    protected void AllSelectChkBox_CheckedChanged(object sender, EventArgs e)
    {
        //System.Threading.Thread.Sleep(3000);

        foreach (TreeNode node in TreeView1.Nodes)
            SetAllChecked(node, AllSelectChkBox.Checked);

        FillInUser();
    }


    //发送短信
    protected void SendButton_Command(object sender, CommandEventArgs e)
    {

        if (Content.Text.Length > 70)
        {
            MsgLabel.Text = "不能超过35个字！";
            MsgPanel.Visible = true;
            return;
        }

        SmsService sms = new SmsService();
        if (sms.GetBalance(Settings.CoreId) <= 0)
        {
            MsgLabel.Text = "余额不足，请充值！";
            MsgPanel.Visible = true;
            return;
        }
       
        List<Pair> smsRetValList = null; //发短信的返回结果 <username,retval>

       smsRetValList = DocTran.BLL.User.CurrentUser.SendSMS(InUserList, 
            Idcwest.WebLibrary.Utils.Helper.ClearHtml(Content.Text.Trim()),
            Idcwest.WebLibrary.Utils.Helper.ClearHtml(SendUserNameTextBox.Text.Trim()),
            Idcwest.WebLibrary.Utils.Helper.ClearHtml(SignatureTextBox.Text.Trim()));
        
        string t = "";
        foreach (Pair var in smsRetValList)
        {
            t += "发送结果: " + var.First + ":" + CodeStatus((int)var.Second) + "　";
            if (t.Length >= 40)
                t += "<br/>";
        }
        ResultLabel.Text = t;
         
    }

    //格式化返回状态
    public string CodeStatus(int code)
    {
        string retVal = "";
        if (code == 1)
            retVal = "发送成功";
        else if (code == -10)
            retVal = "字数太多";
        else if (code == -30)
            retVal = "余额不足";
        else if (code == -40)
            retVal = "号码为空";
        else if (code == -50)
            retVal = "内容为空";
        else
            retVal = "发送失败";
        return retVal;

    }
}
