<meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
<pre>
<?php
require_once("inc/functions.php");
$db = db_connect();

echo "创建Agent表：";
$sql = "DROP TABLE IF EXISTS `Agent`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Agent` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '代理ID',
  `Name` varchar(80) NOT NULL COMMENT '代理名称',
  `Level` tinyint(3) unsigned NOT NULL COMMENT '代理级别',
  `HeadID` int(10) unsigned NOT NULL COMMENT '上级代理ID',
  `Head` varchar(80) NOT NULL COMMENT '上级代理名称',
  `Ancestors` varchar(50) NOT NULL COMMENT '祖先的集合',
  `CityID` int(10) unsigned NOT NULL COMMENT '所属城市',
  `City` varchar(10) NOT NULL COMMENT '所属城市名称',
  `Username` varchar(20) NOT NULL COMMENT '用户名称',
  `Password` varchar(32) NOT NULL COMMENT '密码',
  `Privileges` varchar(1000) NOT NULL COMMENT '用户权限',
  `Realname` varchar(20) NOT NULL DEFAULT '无名氏' COMMENT '责任人（联系人）姓名',
  `Telephone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `Mobile` varchar(14) DEFAULT NULL COMMENT '手机',
  `Memo` varchar(255) DEFAULT NULL COMMENT '备注',
  `LastIp` varchar(15) DEFAULT NULL COMMENT '上次登录IP',
  `LastTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '上次登录时间',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Username` (`Username`),
  KEY `Head` (`HeadID`),
  KEY `CityId` (`CityID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='代理' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建AgentLog表：";
$sql = "DROP TABLE IF EXISTS `AgentLog`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `AgentLog` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `AgentID` int(10) unsigned NOT NULL COMMENT '代理ID',
  `Name` varchar(80) NOT NULL COMMENT '代理名称',
  `CityID` int(10) unsigned NOT NULL COMMENT '所属城市',
  `City` varchar(10) NOT NULL COMMENT '所属城市名称',
  `Realname` varchar(10) NOT NULL COMMENT '姓名',
  `Username` varchar(20) NOT NULL COMMENT '用户名称',
  `OpTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  `IP` char(15) NOT NULL COMMENT 'IP地址',
  `Operation` enum('添加','登录','登出','修改密码','查看客户列表','屏蔽客户','删除客户','修改客户资料','查看餐馆列表','添加餐馆','删除餐馆','修改餐馆资料','添加餐品','删除餐品','修改餐品资料','添加餐品分类','删除餐品分类','修改餐品分类资料','查看短信记录','短信群发','短信单发','删除短信记录','短信平台设置','查看留言列表','留言回复','留言屏蔽','留言删除','查看城市列表','添加城市','删除城市','修改城市信息','添加区域','删除区域','修改区域信息','查看代理列表','添加代理','删除代理','修改代理信息','主页设置','用户帮助页设置','联系我们页设置','关于我们页设置','功能页面右侧设置','系统设置','查看客户操作日志','查看代理操作日志') NOT NULL COMMENT '操作种类',
  `Data` text COMMENT '附加数据或描述',
  PRIMARY KEY (`ID`),
  KEY `AgentID` (`AgentID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='代理操作日志' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Cart表：";
$sql = "DROP TABLE IF EXISTS `Cart`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Cart` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(10) unsigned DEFAULT NULL COMMENT '客户ID',
  `GuestID` varchar(36) DEFAULT NULL COMMENT '访客ID',
  `Json` TEXT NOT NULL COMMENT  '订餐车Json',
  `LastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`),
  KEY `GuestID` (`GuestID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订餐车' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}


echo "创建City表：";
$sql = "DROP TABLE IF EXISTS `City`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `City` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '城市ID',
  `Name` varchar(10) NOT NULL COMMENT '城市名称',
  `Latitude` decimal(12,9) NOT NULL COMMENT '坐标纬度',
  `Longitude` decimal(12,9) NOT NULL COMMENT '坐标经度',
  `ZoomLevel` tinyint(3) unsigned NOT NULL COMMENT '地图缩放倍数',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='城市' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}


echo "创建Custom表：";
$sql = "DROP TABLE IF EXISTS `Custom`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Custom` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '客户ID',
  `Email` varchar(80) DEFAULT NULL COMMENT '电子邮箱',
  `Mobile` char(14) DEFAULT NULL COMMENT '手机号码',
  `Username` varchar(20) DEFAULT NULL COMMENT '用户名',
  `Password` varchar(32) DEFAULT NULL COMMENT '密码',
  `CityHint` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示城市选择提示',
  `WelcomeHint` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示顶部欢迎广告提示',
  `MapHint` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示地图操作提示',
  `LastCity` int(11) unsigned DEFAULT NULL COMMENT '上次访问的城市',
  `LastIp` char(15) DEFAULT NULL COMMENT '上次登录IP',
  `LastTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '上次访问时间',
  `Corporation` int(11) unsigned DEFAULT NULL COMMENT '关联企业',
  `EmailVerified` tinyint(1) NOT NULL DEFAULT '0' COMMENT '邮箱地址是否通过验证',
  `MobileVerified` tinyint(1) NOT NULL DEFAULT '0' COMMENT '手机号码是否通过验证',
  `MobileVerifying` BOOLEAN NOT NULL DEFAULT  '0' COMMENT  '手机号吗是否处于等待验证状态',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客户' AUTO_INCREMENT=1 ";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建CustomAddress表：";
$sql = "DROP TABLE IF EXISTS `CustomAddress`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `CustomAddress` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(10) unsigned NOT NULL COMMENT '客户ID',
  `Address` varchar(255) DEFAULT NULL COMMENT '客户地址',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客户常用地址' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}


echo "创建CustomLog表：";
$sql = "DROP TABLE IF EXISTS `CustomLog`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `CustomLog` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(10) unsigned NOT NULL COMMENT '客户ID',
  `Username` varchar(20) NOT NULL COMMENT '用户名',
  `Email` varchar(80) NOT NULL COMMENT '电子邮箱',
  `Mobile` int(14) NOT NULL COMMENT '手机号码',
  `OpTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  `IP` char(15) NOT NULL COMMENT 'IP地址',
  `Operation` enum('注册','登录','登出','设置','订餐','取消订单','确认送餐','评价送餐') NOT NULL COMMENT '操作种类',
  `data` text COMMENT '附加数据或描述',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客户操作日志' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Dish表：";
$sql = "DROP TABLE IF EXISTS `Dish`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Dish` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Name` varchar(80) NOT NULL COMMENT '品名',
  `SectionID` int(10) unsigned NOT NULL COMMENT '分类ID',
  `Section` varchar(80) NOT NULL COMMENT '分类名称',
  `RestaurantID` int(10) unsigned NOT NULL COMMENT '餐馆ID',
  `Restaurant` varchar(80) NOT NULL COMMENT '餐馆名称',
  `Annotation` varchar(80) DEFAULT NULL COMMENT '注释',
  `Price` decimal(8,2) NOT NULL COMMENT '价格',
  `DiscountPrice` decimal(8,2) DEFAULT NULL COMMENT '优惠价格',
  `DenyOrder` tinyint(1) NOT NULL DEFAULT '0' COMMENT '不接受订餐',
  `LastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `Hide` (`Hide`),
  KEY `RestaurantID` (`RestaurantID`),
  KEY `SectionID` (`SectionID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='餐品' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建EmailCode表：";
$sql = "DROP TABLE IF EXISTS `EmailCode`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `EmailCode` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Email` varchar(80) NOT NULL COMMENT '电子邮箱',
  `Code` varchar(36) NOT NULL COMMENT '验证码',
  `Expire` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '有效时间',
  `Passed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否通过',
  `PassedTime` timestamp NULL DEFAULT NULL COMMENT '通过的时间',
  PRIMARY KEY (`ID`),
  KEY `Email` (`Email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email验证码' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建EmailTemplate表：";
$sql = "DROP TABLE IF EXISTS `EmailTemplate`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `EmailTemplate` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Type` enum('VERIFICATION','ADVERTISMENT') NOT NULL COMMENT '模板类型',
  `Subject` varchar(255) NOT NULL COMMENT 'Email标题',
  `Content` text NOT NULL COMMENT 'Email内容',
  `IsHtml` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否html邮件',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Email模板' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建FavRestaurant表：";
$sql = "DROP TABLE IF EXISTS `FavRestaurant`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `FavRestaurant` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(10) unsigned DEFAULT NULL COMMENT '客户ID',
  `GuestID` varchar(36) DEFAULT NULL COMMENT '访客ID',
  `RestaurantID` int(10) unsigned NOT NULL COMMENT '餐馆ID',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`),
  KEY `GuestID` (`GuestID`),
  KEY `RestaurantID` (`RestaurantID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='餐馆定制' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Guest表：";
$sql = "DROP TABLE IF EXISTS `Guest`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Guest` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `GuestID` varchar(36) NOT NULL COMMENT '访客ID，UUID',
  `CityHint` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示城市选择提示',
  `WelcomeHint` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示顶部欢迎广告提示',
  `MapHint` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示地图操作提示',
  `LastCity` int(10) unsigned DEFAULT NULL COMMENT '上次访问的城市',
  `LastIp` varchar(15) DEFAULT NULL COMMENT '访问IP',
  `LastTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '上次访问时间',
  `CustomID` INT UNSIGNED NULL COMMENT  '客户ID（用于记住登录状态）',
  `IsLogined` BOOLEAN NOT NULL DEFAULT  '0' COMMENT  '客户是否登录',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `GuestID` (`GuestID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='访客' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Menu表：";
$sql = "DROP TABLE IF EXISTS `Menu`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Menu` (
  `IDText` char(4) NOT NULL COMMENT '菜单的ID字符串，形如X_xx',
  `Label` varchar(30) NOT NULL COMMENT '菜单的文字',
  `Icon` varchar(30) NOT NULL COMMENT '菜单的图标',
  `Widget` varchar(50) DEFAULT NULL COMMENT '子菜单项对应的widget，仅子菜单拥有',
  `ShowAtHome` tinyint(1) DEFAULT NULL COMMENT '是否显示在欢迎页，仅子菜单拥有',
  `BigIcon` varchar(30) DEFAULT NULL COMMENT '菜单的大图标，仅子菜单拥有',
  PRIMARY KEY (`IDText`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统菜单';
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Order表：";
$sql = "DROP TABLE IF EXISTS `Order`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Order` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(10) unsigned NOT NULL COMMENT '客户ID',
  `RestaurantID` int(10) unsigned NOT NULL COMMENT '餐馆ID',
  `DishJson` text NOT NULL COMMENT '餐品列表JSON',
  `Mobile` varchar(14) NOT NULL COMMENT '手机号码',
  `Address` varchar(255) NOT NULL COMMENT '详细地址',
  `Notes` varchar(255) DEFAULT NULL COMMENT '要求',
  `CreateTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `Status` enum('创建','取消','失败','等待响应','等待送餐','等待客户确认','等待餐馆确认','等待评价','成功结束') NOT NULL DEFAULT '创建' COMMENT '状态',
  `LastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`),
  KEY `RestaurantID` (`RestaurantID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订餐订单' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建OrderItem表：";
$sql = "DROP TABLE IF EXISTS `OrderItem`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `OrderItem` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `OrderID` int(10) unsigned NOT NULL COMMENT '订单ID',
  `DishID` int(11) NOT NULL COMMENT '餐品ID',
  `Name` varchar(80) NOT NULL COMMENT '餐品名称',
  `Price` decimal(8,2) NOT NULL COMMENT '餐品实际成交价',
  `Count` int(11) NOT NULL COMMENT '餐品成交数量',
  `RestaurantID` int(10) unsigned NOT NULL COMMENT '餐馆ID',
  `Restaurant` varchar(80) NOT NULL COMMENT '餐馆名称',
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`OrderID`),
  KEY `RestaurantID` (`RestaurantID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单项' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建QA表：";
$sql = "DROP TABLE IF EXISTS `QA`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `QA` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `CustomID` int(11) unsigned DEFAULT NULL COMMENT '客户ID',
  `Email` varchar(80) DEFAULT NULL COMMENT '电子邮件',
  `Name` VARCHAR( 80 ) NOT NULL COMMENT  '用户名',
  `Question` text NOT NULL COMMENT '疑问内容',
  `QTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '提问时间',
  `Answer` text COMMENT '答复内容',
  `ATime` timestamp NULL DEFAULT NULL COMMENT '答复时间',
  `Show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否在首页显示',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `CustomID` (`CustomID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='答疑' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Region表：";
$sql = "DROP TABLE IF EXISTS `Region`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Region` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '区域ID',
  `Name` varchar(30) NOT NULL COMMENT '区域名称',
  `CityID` int(10) unsigned NOT NULL COMMENT '城市ID',
  `City` varchar(10) NOT NULL COMMENT '城市名称',
  `Latitude` decimal(12,9) NOT NULL COMMENT '坐标纬度',
  `Longitude` decimal(12,9) NOT NULL COMMENT '坐标经度',
  `ZoomLevel` tinyint(3) unsigned NOT NULL COMMENT '地图缩放倍数',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `CityID` (`CityID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='城市区域' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Restaurant表：";
$sql = "DROP TABLE IF EXISTS `Restaurant`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Restaurant` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '餐馆ID',
  `UUID` char(6) NOT NULL COMMENT '餐馆UUID',
  `Name` varchar(80) NOT NULL COMMENT '名称',
  `Telephone` varchar(20) NOT NULL COMMENT '电话号码',
  `CityId` int(10) unsigned NOT NULL COMMENT '所属城市ID',
  `City` varchar(10) NOT NULL COMMENT '所属城市',
  `CityDefault` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为城市默认餐馆',
  `AgentId` int(10) unsigned NOT NULL COMMENT '所属代理机构ID',
  `Agent` varchar(80) NOT NULL COMMENT '所属代理机构',
  `Rating` tinyint(4) NOT NULL DEFAULT '2' COMMENT '评级',
  `Mobile` char(14) NOT NULL COMMENT '手机号码',
  `BusinessHour` varchar(80) DEFAULT NULL COMMENT '外卖时间',
  `BusinessMemo` varchar(255) DEFAULT '该餐厅多数情况能送外卖' COMMENT '外卖说明',
  `Fee` decimal(5,2) DEFAULT NULL COMMENT '送餐费用，单位：元',
  `MinMoney` decimal(5,2) DEFAULT NULL COMMENT '起送金额，单位：元',
  `Scope` int(11) DEFAULT '500' COMMENT '送餐范围，单位：米',
  `Discount` decimal(3,2) DEFAULT '9.99' COMMENT '折扣',
  `Notice` varchar(255) DEFAULT '为了您的准时用餐，请提前20分钟订餐。' COMMENT '公告',
  `DenyOrder` tinyint(1) NOT NULL DEFAULT '0' COMMENT '不接受订餐',
  `Latitude` decimal(12,9) NOT NULL COMMENT '坐标纬度',
  `Longitude` decimal(12,9) NOT NULL COMMENT '坐标经度',
  `Address` varchar(255) DEFAULT NULL COMMENT '地址',
  `Linkman` varchar(50) DEFAULT NULL COMMENT '联系人',
  `LinkPhone` varchar(255) DEFAULT NULL COMMENT '联系电话',
  `Keyword` varchar(255) DEFAULT '外卖,菜单,订餐,电话,送餐,外送' COMMENT '关键字',
  `Memo` varchar(255) DEFAULT NULL COMMENT '备注',
  `LastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `CityId` (`CityId`),
  KEY `AgencyId` (`AgentId`),
  KEY `Hide` (`Hide`),
  KEY `Latitude` (`Latitude`),
  KEY `Longitude` (`Longitude`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='餐馆' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Section表：";
$sql = "DROP TABLE IF EXISTS `Section`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Section` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Name` varchar(80) NOT NULL COMMENT '分类名称',
  `RestaurantID` int(10) unsigned NOT NULL COMMENT '餐馆ID',
  `Restaurant` varchar(80) NOT NULL COMMENT '餐馆名称',
  `DenyOrder` tinyint(1) NOT NULL DEFAULT '0' COMMENT '不接受订餐',
  `LastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `RestaurantID` (`RestaurantID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='餐馆食品分类' AUTO_INCREMENT=1 ;
";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Setting表：";
$sql = "DROP TABLE IF EXISTS `Setting`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Setting` (
  `Property` varchar(20) NOT NULL COMMENT '属性',
  `Value` varchar(255) NOT NULL COMMENT '值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统设置';";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建Sms表：";
$sql = "DROP TABLE IF EXISTS `Sms`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `Sms` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Receiver` varchar(14) NOT NULL COMMENT '接收手机号码',
  `Content` varchar(255) NOT NULL COMMENT '内容',
  `SentTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '发送时间',
  `RecvTime` timestamp NULL DEFAULT NULL COMMENT '接收时间',
  `Success` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否发送成功',
  `ReturnCode` int(11) DEFAULT NULL COMMENT 'API返回代码',
  `Status` enum('PENDING','SENT','FAILED') NOT NULL DEFAULT 'PENDING' COMMENT '状态',
  `CustomID` int(10) unsigned DEFAULT NULL COMMENT '客户ID',
  `Hide` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`ID`),
  KEY `Hide` (`Hide`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='短信发送记录' AUTO_INCREMENT=1 ;";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}


echo "创建SmsCode表：";
$sql = "DROP TABLE IF EXISTS `SmsCode`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `SmsCode` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Type` enum('登录','手机号码验证') NOT NULL COMMENT  '验证码类型',
  `CustomID` int(10) unsigned NULL COMMENT  '相关的客户ID',
  `Mobile` varchar(14) NOT NULL COMMENT '手机号码',
  `Code` char(6) NOT NULL COMMENT '验证码',
  `Expire` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '有效时间',
  `Passed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否通过',
  `PassedTime` timestamp NULL DEFAULT NULL COMMENT '通过的时间',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Mobile` (`Mobile`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='短信验证码' AUTO_INCREMENT=1 ;";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "创建SmsQueue表：";
$sql = "DROP TABLE IF EXISTS `SmsQueue`;";
$db->query($sql);
if($db->result!==FALSE){
	echo "drop成功。\n";
}
else{
	echo "drop失败。\n";
}
$sql = "
CREATE TABLE IF NOT EXISTS `SmsQueue` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `Receiver` varchar(14) NOT NULL COMMENT '接收手机号码',
  `Content` varchar(255) NOT NULL COMMENT '内容',
  `CustomID` int(10) unsigned DEFAULT NULL COMMENT '客户ID',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='短信群发队列' AUTO_INCREMENT=1 ;";
$db->query($sql);
if($db->result!==FALSE){
	echo "创建成功。\n";
}
else{
	echo "创建失败。\n";
}

echo "初始化Agent表数据：";
$sql = "INSERT DELAYED IGNORE INTO `Agent` (`ID`, `Name`, `Level`, `HeadID`, `Head`, `Ancestors`, `CityID`, `City`, `Username`, `Password`, `Privileges`, `Realname`, `Telephone`, `Mobile`, `Memo`, `LastIp`, `LastTime`, `Hide`) VALUES
(1, '总代理', 0, 0, ' ', '0', 0, ' ', 'admin', '14e1b600b1fd579f47433b88e8d85291', '客户管理,客户列表,屏蔽客户,删除客户,修改客户资料,餐馆管理,餐馆列表,添加餐馆,删除餐馆,修改餐馆资料,添加餐品,删除餐品,修改餐品资料,网站设置,主页设置,用户帮助页,联系我们页,关于我们页,功能页面右侧,短信管理,短信平台设置,短信记录,短信群发,短信单发,删除短信记录,留言管理,留言列表,留言回复,留言屏蔽,留言删除,城市管理,城市列表,添加城市,删除城市,修改城市信息,添加区域,删除区域,修改区域信息,代理管理,代理列表,添加代理,删除代理,修改代理信息,系统管理,系统设置,客户操作日志,代理操作日志', '系统管理员', NULL, NULL, NULL, '127.0.0.1', '2012-01-26 14:33:35', 0);";
$db->query($sql);
if($db->result!==FALSE){
	echo "成功。\n";
}
else{
	echo "失败。\n";
}

echo "初始化EmailTemplate表：";
$sql = "INSERT DELAYED IGNORE INTO `EmailTemplate` (`ID`, `Type`, `Subject`, `Content`, `IsHtml`) VALUES
(1, 'VERIFICATION', '感谢注册，请验证email', '您好, #username#\r\n\r\n感谢您的注册，请点击下面的链接验证您的Email:\r\n#baseurl#verify.php?code=#code#', 0);";
$db->query($sql);
if($db->result!==FALSE){
	echo "成功。\n";
}
else{
	echo "失败。\n";
}

echo "初始化Menu表：";
$sql = "INSERT DELAYED IGNORE INTO `Menu` (`IDText`, `Label`, `Icon`, `Widget`, `ShowAtHome`, `BigIcon`) VALUES
('1', '客户管理', 'menu_custom', NULL, NULL, NULL),
('1_1', '客户列表', 'list', 'widget.CustomList', 1, 'custom_big'),
('2', '餐馆管理', 'menu_restaurant', NULL, NULL, NULL),
('2_1', '餐馆列表', 'list', 'widget.RestaurantList', 1, 'restaurant_big'),
('2_2', '添加餐馆', 'restaurant_add', 'widget.AddRestaurant', 1, 'restaurant_add_big'),
('3', '网站设置', 'menu_page', NULL, NULL, NULL),
('3_1', '主页设置', 'page_home', 'widget.HomePageSetting', 1, 'home_page_big'),
('3_2', '用户帮助页', 'page_help', 'widget.HelpPageSetting', 0, NULL),
('3_3', '联系我们页', 'page_contact', 'widget.ContactPageSetting', 0, NULL),
('3_4', '关于我们页', 'page_about', 'widget.AboutPageSetting', 0, NULL),
('3_5', '功能页面右侧', 'page_right', 'widget.RightSideSetting', 0, NULL),
('4', '短信管理', 'menu_phone', NULL, NULL, NULL),
('4_1', '短信平台设置', 'phone', 'widget.SmsServerSetting', 1, 'sms_setting_big'),
('4_2', '短信记录', 'list', 'widget.SmsList', 1, 'sms_list_big'),
('4_3', '短信群发', 'phone_sound', 'widget.SmsGroupSend', 1, 'sms_big'),
('4_4', '短信单发', 'phone_add', 'widget.SmsSingleSend', 1, 'sms_single_big'),
('5', '留言管理', 'menu_help', NULL, NULL, NULL),
('5_1', '留言列表', 'list', 'widget.QAList', 1, 'qa_big'),
('6', '城市管理', 'menu_map', NULL, NULL, NULL),
('6_1', '城市列表', 'map_edit', 'widget.CityList', 1, 'city_big'),
('6_2', '添加城市', 'map_add', 'widget.AddCity', 1, 'city_add_big'),
('7', '代理管理', 'menu_agent', NULL, NULL, NULL),
('7_1', '代理列表', 'agent', 'widget.AgentList', 1, 'agent_big'),
('7_2', '添加代理', 'agent_add', 'widget.AddAgent', 1, 'agent_add_big'),
('8', '系统管理', 'menu_setting', NULL, NULL, NULL),
('8_1', '系统设置', 'setting', 'widget.SystemSetting', 1, 'setting_big'),
('8_2', '客户操作日志', 'calendar', 'widget.CustomLog', 1, 'calendar_big'),
('8_3', '代理操作日志', 'calendar', 'widget.AgentLog', 1, 'calendar_big');";
$db->query($sql);
if($db->result!==FALSE){
	echo "成功。\n";
}
else{
	echo "失败。\n";
}

$db->close();
?>
</pre>