Ext.define('AddRegionWindow', {
	extend: 'Ext.window.Window',
	resizable : false,
	layout : 'fit',
	closeAction : 'hide',
	
	initComponent : function() {
		Ext.apply(this, {
			modal : true,
			title: '添加'+this.city+'区域',
			items: [{
				xtype : 'form',
				id : 'add_region_window_form_'+this.cityId,
				autoScroll : true,
				frame: false,
				border: false,
				bodyPadding: 10,
				defaultType: 'textfield',
				items : [{
						fieldLabel: '名称',
						labelWidth: 30,
						width: 200,
						name: 'name',
			            msgTarget: 'side',
			            labelAlign: 'right',
						allowBlank: false,
						blankText : '区域名称不能为空',
						enforceMaxLength : true,
						maxLength : 15,
						maxLengthText : '区域名称不能超过15个汉字'
					},
					this.createMapPanel(),
					{
		    			xtype: 'panel',
						layout:'hbox',
						margin: '10px,0,0,0',
						border: false,
		    			items: [{
			    			id: 'add_region_window_longitude_hiddenfield',
			    			fieldLabel: '经度',
			    			labelWidth: 30,
			    			labelAlign: 'right',
			    			width: 150,
			    			readOnly: true,
							allowBlank: false,
							blankText : '区域经度不能为空，请移动地图获取经度',
							xtype: 'textfield',
							name: 'longitude'
						},{
			    			id: 'add_region_window_latitude_hiddenfield',
			    			fieldLabel: '纬度',
			    			labelWidth: 40,
			    			labelAlign: 'right',
			    			width: 150,
			    			readOnly: true,
							allowBlank: false,
							blankText : '区域纬度不能为空，请移动地图获取纬度',
							xtype: 'textfield',
							name: 'latitude'
						},{
			    			id: 'add_region_window_zoomlevel_hiddenfield',
			    			fieldLabel: '缩放',
			    			labelWidth: 40,
			    			labelAlign: 'right',
			    			width: 80,
			    			readOnly: true,
							allowBlank: false,
							blankText : '区域缩放倍数不能为空，请缩放地图获取缩放倍数',
							xtype: 'textfield',
							name: 'zoomlevel'
						}]
		    		}
				],
				buttonAlign: 'center',
				buttons: [{
		            text: '保存',
		            handler: this.submitForm,
		            scope: this
//		        },{
//		            text: '重置',
//		            handler: function() {Ext.getCmp('add_region_window_form').getForm().reset();},
//		            scope: this
		        }]
			}]
		});
		this.callParent(arguments);
	},
	
	submitForm : function() {
		var form = Ext.getCmp('add_region_window_form_'+this.cityId).getForm();
		if (form.isValid()) {
			form.submit({
				url:'add_region.php',
				params: {cityid: this.cityId, city: this.city},
				waitTitle : '请稍候',
				waitMsg : '正在保存区域数据...',
				method : 'POST',
		        success: this.addRegionSuccess,
		        failure: this.addRegionFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('区域名称不能为空并且不能超过15个汉字。','输入有误。');
		}
	},
	
	addRegionSuccess : function( form, action ) {
		showSuccessMsg('保存区域信息到数据成功。','操作成功。');
		if(this.store) this.store.load();
	},
	
	addRegionFailure : function( form, action ) {
		showFormFailureMsg( action, '保存区域信息到数据失败' );
		if(this.store) this.store.load();
	},
	
	createMapPanel : function() {
		var mapCanvasHtml = '<div id="add_region_window_map_canvas_id_'+this.cityId+'" style="height:100%; width: 100%;">' +
				'</div><img src="images/center.png" style="left: 183px; top: 171px; position: absolute;">';
		EditRegionMap = Ext.extend(Ext.panel.Panel,{
			title: '请通过缩放和移动地图，使区域位置位于地图中心。',
			layout: 'auto',
			height: 400,
			width: 400,
			html: mapCanvasHtml,
			
			cityId : this.cityId,
			latitude : this.latitude,
			longitude : this.longitude,
			zoomlevel : this.zoomlevel,
			
			afterRender : function (){
				EditRegionMap.superclass.afterRender.apply(this, arguments);
				
				this.map = makeMapInDiv("add_region_window_map_canvas_id_"+this.cityId, this.latitude, this.longitude, this.zoomlevel);
				var theMap = this.map;
				
				var lat = Ext.getCmp("add_region_window_latitude_hiddenfield");
				var lng = Ext.getCmp("add_region_window_longitude_hiddenfield");
				var zoom = Ext.getCmp("add_region_window_zoomlevel_hiddenfield");
				
				lat.setValue(this.latitude);
				lng.setValue(this.longitude);
				zoom.setValue(this.zoomlevel);
				
				google.maps.event.addListener(theMap, 'dragend', function() {
					var center = theMap.getCenter();
					lat.setValue(toPrecision(center.lat(),9));
					lng.setValue(toPrecision(center.lng(),9));
			    });
				google.maps.event.addListener(theMap, 'zoom_changed', function() {
					var center = theMap.getCenter();
					lat.setValue(toPrecision(center.lat(),9));
					lng.setValue(toPrecision(center.lng(),9));
					zoom.setValue(theMap.getZoom());
			    });
			}
		});
		
		this.mapPanel = new EditRegionMap();
		return this.mapPanel;
	}
});