if (!Ext.ModelManager.isRegistered('AgentLogWidget')){
Ext.define('AgentLogWidget', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.AgentLogWidget',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'AgentLog',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'agentlogs.php',
				reader: {
					type: 'json',
					root: 'agentlogs',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		this.cityStore = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'City',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'cities.php',
				reader: {
					type: 'json',
					root: 'cities',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true,
			listeners: {
				'load': function(store, records,successful,op){
					var r = Ext.create('City', {
						id: '0',
						name: '全部'
					});
					store.insert(0, r);
				}
			}
		});
		
		Ext.apply(this, {
			id : 'widget.AgentLogWidget',
			title : '代理操作日志',
			closable : true,
			autoScroll : true,
	        columns: [
	        	{
	        		xtype	 : 'rownumberer',
	                width    : 40
	        	},
	        	{
	                text     : '代理名称',
	                width    : 180,
	                sortable : true,
	                dataIndex: 'Name'
	            },
	            {
	                text     : '所属城市',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'City'
	            },
	            {
	                text     : '操作员姓名',
	                width    : 75,
	                sortable : true,
	                dataIndex: 'Realname'
	            },
	            {
	                text     : '用户名称',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'Username'
	            },
	            {
	                text     : '操作时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'OpTime'
	            },
	            {
	                text     : 'IP地址',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'IP'
	            },
	            {
	                text     : '操作种类',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Operation'
	            },
	            {
	                text     : '附加数据或描述',
	                flex	 : 1,
	                minWidth : 200,
	                sortable : true,
	                dataIndex: 'Data'
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: ['搜索',{
					xtype: 'textfield',
					name: 'searchText',
					tooltip:{text:'可以在此输入代理名称、城市名称、操作员姓名、用户名、附加数据或描述等进行模糊查询。',title:'搜索提示'},
					hideLabel: true,
					width: 130,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchText = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 },
						 afterrender: {
						 	fn: function(field) {
							 		if(field.tooltip.text){   
					                    new Ext.ToolTip({
					                        target:field.id,
					                        trackMouse:false,
					                        draggable:true,
					                        maxWidth:300,
					                        minWidth:100,
					                        title:"<span style='color:green'>" + field.tooltip.title + "</span>",
					                        html:"<span style='color:green'>" + field.tooltip.text + "</span>"
					                    }); 
					                }  
							 	}
						 }
					}
				},'　所属城市',{
					xtype: 'combo',
					width: 80,
					name: 'searchCity',
					hideLabel: true,
					store: this.cityStore,
					queryMode: 'local',
					displayField: 'name',
					valueField: 'id',
					listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchCityId = value[0].data.id;
						}
					}
				},'　从',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateFrom',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateFrom = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourFrom',
					id: 'agent_log_widget_search_hour_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourFrom = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteFrom',
					id: 'agent_log_widget_search_minute_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteFrom = newValue;
						}
					}
				},'　到',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateEnd',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateEnd = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourEnd',
					id: 'agent_log_widget_search_hour_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourEnd = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteEnd',
					id: 'agent_log_widget_search_minute_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteEnd = newValue;
						}
					}
				},'　IP',{
					xtype: 'textfield',
					name: 'searchIP',
					hideLabel: true,
					width: 110,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchIP = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 }
					}
				},'　操作类型',{
					xtype: 'combo',
					width: 130,
					name: 'searchOperation',
					hideLabel: true,
					store: [
	                    ['','全部'],['添加','添加'],
						['登录','登录'],
						['登出','登出'],
						['修改密码','修改密码'],
						['查看客户列表','查看客户列表'],
						['屏蔽客户','屏蔽客户'],
						['删除客户','删除客户'],
						['修改客户资料','修改客户资料'],
						['查看餐馆列表','查看餐馆列表'],
						['添加餐馆','添加餐馆'],
						['删除餐馆','删除餐馆'],
						['修改餐馆资料','修改餐馆资料'],
						['添加餐品','添加餐品'],
						['删除餐品','删除餐品'],
						['修改餐品资料','修改餐品资料'],
						['添加餐品分类','添加餐品分类'],
						['删除餐品分类','删除餐品分类'],
						['修改餐品分类资料','修改餐品分类资料'],
						['查看短信记录','查看短信记录'],
						['短信群发','短信群发'],
						['短信单发','短信单发'],
						['删除短信记录','删除短信记录'],
						['短信平台设置','短信平台设置'],
						['查看留言列表','查看留言列表'],
						['留言回复','留言回复'],
						['留言屏蔽','留言屏蔽'],
						['留言删除','留言删除'],
						['查看城市列表','查看城市列表'],
						['添加城市','添加城市'],
						['删除城市','删除城市'],
						['修改城市信息','修改城市信息'],
						['添加区域','添加区域'],
						['删除区域','删除区域'],
						['修改区域信息','修改区域信息'],
						['查看代理列表','查看代理列表'],
						['添加代理','添加代理'],
						['删除代理','删除代理'],
						['修改代理信息','修改代理信息'],
						['主页设置','主页设置'],
						['用户帮助页设置','用户帮助页设置'],
						['联系我们页设置','联系我们页设置'],
						['关于我们页设置','关于我们页设置'],
						['功能页面右侧设置','功能页面右侧设置'],
						['系统设置','系统设置'],
						['查看客户操作日志','查看客户操作日志'],
						['查看代理操作日志','查看代理操作日志']
	                ],
	                lazyRender: true,
	                listClass: 'x-combo-list-small',
	                listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchOperation = value[0].data.field1;
						}
					}
				},{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		proxy.extraParams.searchCityId = this.searchCityId;
		if(this.searchDateFrom!='' && this.searchDateFrom!=null){
			if(this.searchHourFrom==null || this.searchHourFrom==''){
				this.searchHourFrom = 0;
				Ext.getCmp('agent_log_widget_search_hour_from').setValue(0);
			}
			if(this.searchMinuteFrom==null || this.searchMinuteFrom==''){
				this.searchMinuteFrom = 0;
				Ext.getCmp('agent_log_widget_search_minute_from').setValue(0);
			}
		}
		proxy.extraParams.searchDateFrom = this.searchDateFrom;
		proxy.extraParams.searchHourFrom = this.searchHourFrom;
		proxy.extraParams.searchMinuteFrom = this.searchMinuteFrom;
		if(this.searchDateEnd!='' && this.searchDateEnd!=null){
			if(this.searchHourEnd==null || this.searchHourEnd==''){
				this.searchHourEnd = 23;
				Ext.getCmp('agent_log_widget_search_hour_end').setValue(23);
			}
			if(this.searchMinuteEnd==null || this.searchMinuteEnd==''){
				this.searchMinuteEnd = 59;
				Ext.getCmp('agent_log_widget_search_minute_end').setValue(59);
			}
		}
		proxy.extraParams.searchDateEnd = this.searchDateEnd;
		proxy.extraParams.searchHourEnd = this.searchHourEnd;
		proxy.extraParams.searchMinuteEnd = this.searchMinuteEnd;
		proxy.extraParams.searchIP = this.searchIP;
		proxy.extraParams.searchOperation = this.searchOperation;
		store.loadPage(1);
	}
});
}