Ext.apply(Ext.form.VTypes, {
    daterange : function(val, field) {
        var date = field.parseDate(val);

        if(!date){
            return;
        }
        if (field.startDateField && (!this.dateRangeMax || (date.getTime() != this.dateRangeMax.getTime()))) {
            var start = field.startDateField;
            start.setMaxValue(date);
            start.validate();
            this.dateRangeMax = date;
        } 
        else if (field.endDateField && (!this.dateRangeMin || (date.getTime() != this.dateRangeMin.getTime()))) {
        	var end = field.endDateField;
            end.setMinValue(date);
            end.validate();
            this.dateRangeMin = date;
        }
        return true;
    },
    
    password : function(val, field) {
        if (field.initialPassField) {
            return (val == field.initialPassField.getValue());
        }
        return true;
    },

    passwordText : '两次输入密码不一致'
});

if (!Ext.ModelManager.isRegistered('ChangePasswordWindow')){
Ext.define('ChangePasswordWindow', {
	extend : 'Ext.Window',
	alias  : 'widget.AboutPageSetting',
	id : 'changePasswordWindow',
//	width : 250,
//	height : 170,
	title : '修改密码',
	closeAction : 'hide',
	resizable : false,
	layout : 'fit',
	border : false,
	buttonAlign : 'center',
    initComponent : function(){
    	this.oldPasswordField = new Ext.form.TextField({
            fieldLabel: '原密码',
            name: 'oldPassword',
            blankText: '原密码不能为空',
	        msgTarget: 'under',
	        width: 250,
			labelAlign: 'right',
			inputType:"password",
    		allowBlank: false
        });
    	this.newPassword1Field = new Ext.form.TextField({
            fieldLabel: '新密码',
            name: 'newPassword1',
            blankText: '新密码不能为空',
	        width: 250,
			labelAlign: 'right',
	        msgTarget: 'under',
	        inputType:"password",
    		allowBlank: false
        });
    	this.newPassword2Field = new Ext.form.TextField({
            fieldLabel: '再次输入新密码',
            name: 'newPassword2',
            blankText: '新密码不能为空',
	        width: 250,
			labelAlign: 'right',
	        msgTarget: 'under',
	        inputType:"password",
            initialPassField: this.newPassword1Field,
            vtype: 'password',
    		allowBlank: false
        });
        
    	this.myMask = new Ext.LoadMask(Ext.getBody(), {msg : "正在操作..."});  
    	
    	Ext.apply(this,{
    		items : new Ext.form.FormPanel({
    			border : false,
		        labelWidth: 100, // label settings here cascade unless overridden
		        frame:true,
		        bodyStyle:'padding:5px 5px 0',
//		        width: 350,
				labelAlign : 'right',
		        defaults: {width: 200, inputType : 'password'},		
				keys : {
					key : Ext.EventObject.ENTER,
					fn : function(){ 
						event.keyCode=9; 
					},
					scope : this
				},
		        items: [this.oldPasswordField, this.newPassword1Field, this.newPassword2Field]
    		}),
	        buttons: [{
	            text: '确定',
	            handler: this.changePassword,
	            scope: this
	        },{
	            text: '取消',
	            handler: function () {this.hide();},
	            scope: this
	        }]
    	});
    	ChangePasswordWindow.superclass.initComponent.apply(this, arguments);
    	this.on('beforehide',this.clearFields)
    },
    
	onRender : function() { 
    	ChangePasswordWindow.superclass.onRender.apply(this, arguments);
	}, // eo function onRender
	
	changePassword : function() {
		var v1 = this.oldPasswordField.validate();
		var v2 = this.newPassword1Field.validate();
		var v3 = this.newPassword2Field.validate();
		if (!( v1 && v2 && v3 )) return
		
    	Ext.Ajax.request({
		    url:'change_password.php',
			method: 'POST',
			params: {oldpassword: md5(this.oldPasswordField.getValue()), newpassword: md5(this.newPassword1Field.getValue())},
			success: this.changePswRequestSuccess,
			failure: this.changePswRequestFailure,
			scope:this 
		})
		this.myMask.show();
	},
	
	changePswRequestSuccess : function(response, options) {
    	showAjaxResponseMsg( response, '修改密码' );
		this.myMask.hide();
		
	},
	
	changePswRequestFailure : function(response, options) {
    	showAjaxResponseMsg( response, '修改密码' );
		this.myMask.hide();
	},
	
	clearFields : function() {
		this.oldPasswordField.reset();
		this.newPassword1Field.reset();
		this.newPassword2Field.reset();
	}
});
}
var passwordWindows;

function showPasswordWindow(from)
{
	if(!passwordWindows){
		passwordWindows = new ChangePasswordWindow();
	}
	passwordWindows.show(from);
}
