if (!Ext.ModelManager.isRegistered('CustomList')){
Ext.define('CustomList', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.CustomList',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'Custom',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'customs.php',
				reader: {
					type: 'json',
					root: 'customs',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		Ext.apply(this, {
			id : 'widget.CustomList',
			title : '客户列表',
			closable : true,
			autoScroll : true,
	        viewConfig: {
	            stripeRows: true
	        },
	        selModel: Ext.create('Ext.selection.CheckboxModel'),
			columns:[{
	                text     : '用户名',
	                width    : 80,
	                sortable : true,
	                dataIndex: 'Username'
	            },
	            {
	                text     : 'Email',
	                width    : 160,
	                sortable : true,
	                dataIndex: 'Email'
	            },
	            {
	                text     : '手机号码',
	                width    : 130,
	                sortable : true,
	                dataIndex: 'Mobile'
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '城市选择提示',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'CityHint',
	                hidden	 : true
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '主页欢迎提示',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'WelcomeHint',
	                hidden	 : true
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '地图操作提示',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'MapHint',
	                hidden	 : true
	            },
	            {
	                text     : '注册时间',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'RegTime'
	            },
	            {
	                text     : '注册方式',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'RegType'
	            },
	            {
	                text     : '客户端类型(上次)',
	                width    : 110,
	                sortable : true,
	                dataIndex: 'LastClient'
	            },
	            {
	                text     : '上次访问城市',
	                width    : 80,
	                sortable : true,
	                dataIndex: 'LastCity'
	            },
	            {
	                text     : '上次登录IP',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'LastIp'
	            },
	            {
	                text     : '上次访问时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'LastTime'
	            },
	            {
	                text     : '关联企业',
	                width    : 75,
	                sortable : true,
	                dataIndex: 'Corporation'
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '邮箱地址是否通过验证',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'EmailVerified',
	                hidden	 : true
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '手机号码是否通过验证',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'MobileVerified',
	                hidden	 : true
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '手机号吗是否处于等待验证状态',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'MobileVerifying',
	                hidden	 : true
	            },
	            {
	                xtype: 'actioncolumn',
	                flex: 1,
	                items: [/*{
	                    icon   : 'images/coins.png',
	                    altText: '查看客户消费记录',
	                    tooltip: '查看客户消费记录',
	                    handler: this.showCustomConsumption,
	                    scope: this
	                },{
	                    icon   : 'images/map.png',
	                    altText: '查看客户地址',
	                    tooltip: '查看客户地址',
	                    handler: this.showCustomAddress,
	                    scope: this
	                },{
	                    icon   : 'images/edit.png',
	                    altText: '修改客户信息',
	                    tooltip: '修改客户信息',
	                    handler: this.editCustom,
	                    scope: this
	                },{
	                    icon   : 'images/key.png',
	                    altText: '重置密码',
	                    tooltip: '重置客户密码',
	                    handler: this.resetCustomPassword,
	                    scope: this
	                },*/{
	                    icon   : 'images/phone_add.png',
	                    altText: '添加到短信队列',
	                    tooltip: '添加到短信队列',
	                    handler: this.addCustomToSmsQueue,
	                    scope: this
	                },/*{
	                    icon   : 'images/cancel.png',
	                    altText: '屏蔽客户',
	                    tooltip: '屏蔽客户',
	                    handler: this.hideCustom,
	                    scope: this
	                },*/{
	                    icon   : 'images/delete.png',
	                    altText: '删除客户',
	                    tooltip: '删除客户',
	                    handler: this.deleteCustom,
	                    scope: this
	                }]
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: [{
					text: '添加到短信队列',
					tooltip: '添加所选客户到短信队列',
					iconCls: 'phone_add',
					scope: this,
					handler: this.addSelectedCustomsToSmsQueue
				}, /*'-', {
					text:'屏蔽客户',
					tooltip:'批量屏蔽所选的客户',
					iconCls:'cancel',
					scope: this,
					handler: this.hideSelectedCustoms
				},*/'-',{
					
					text:'删除客户',
					tooltip:'批量删除所选的客户',
					iconCls:'delete',
					scope: this,
					handler: this.deleteSelectedCustoms
				},'-','搜索',{
					xtype: 'textfield',
					name: 'searchText',
					tooltip:{text:'可以在此输入客户用户名、手机号码、Email地址、IP地址等进行模糊查询。',title:'搜索提示'},
					hideLabel: true,
					width: 200,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchText = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 },
						 afterrender: {
						 	fn: function(field) {
							 		if(field.tooltip.text){   
					                    new Ext.ToolTip({
					                        target:field.id,
					                        trackMouse:false,
					                        draggable:true,
					                        maxWidth:300,
					                        minWidth:100,
					                        title:"<span style='color:green'>" + field.tooltip.title + "</span>",
					                        html:"<span style='color:green'>" + field.tooltip.text + "</span>"
					                    }); 
					                }  
							 	}
						 }
					}
				},'注册方式',{
					xtype: 'combo',
					width: 100,
					name: 'searchRegType',
					hideLabel: true,
					store: [
	                    ['','全部'],
	                    ['Email+用户名','Email+用户名'],
	                    ['短信','短信'],
	                    ['手机客户端','手机客户端']
	                ],
	                lazyRender: true,
	                listClass: 'x-combo-list-small',
	                listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchRegType = value[0].data.field1;
						}
					}
				},'客户端类型',{
					xtype: 'combo',
					width: 80,
					name: 'searchClient',
					hideLabel: true,
					store: [
	                    ['','全部'],
	                    ['网站','网站'],
	                    ['Android','Android'],
	                    ['iPhone','iPhone']
	                ],
	                lazyRender: true,
	                listClass: 'x-combo-list-small',
	                listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchClient = value[0].data.field1;
						}
					}
				},{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function () {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		proxy.extraParams.searchRegType = this.searchRegType;
		proxy.extraParams.searchClient = this.searchClient;
		store.loadPage(1);
	},
	
	showCustomConsumption : function() {
		console.log('showCustomConsumption');
	},
	
	showCustomAddress : function() {
		console.log('showCustomAddress');
	},
	
	editCustom : function() {
		console.log('editCustom');
	},
	
	resetCustomPassword : function() {
		console.log('resetCustomPassword');
	},
	
	addCustomToSmsQueue : function(grid, rowIndex, colIndex) {
		var custom = grid.store.data.items[rowIndex].data;
		var reg = /^((\+86)?|(86)?)(13[0-9]{9}|15[0|1|2|3|5|6|7|8|9]\d{8}|18[0|5|6|7|8|9]\d{8})$/;
		if(!reg.test(custom.Mobile)){
			showErrorMsg('客户填写的手机号码不是有效的手机号码','错误');
			return;
		}
		
		Ext.Ajax.request({
			url: 'sms_queue_addone.php',
			params: {CustomID: custom.id, Receiver: custom.Mobile},
			method: 'POST',
			success: this.addOneSuccess,
			failure: this.addOneFailure,
			scope: this
		});
	},
	
    addOneSuccess : function(response, opts) {
    	showAjaxResponseMsg( response, "添加短信接收手机号码", true);
    },
    
    addOneFailure : function(response, opts) {
    	showAjaxResponseMsg( response, "添加短信接收手机号码");
    },
	
	hideCustom : function() {
		console.log('hideCustom');
	},
	
	deleteCustom : function(grid,rowIndex,colIndex) {
		var custom = grid.store.data.items[rowIndex].data;
		if(confirm("确定要删除该客户吗？"))
		Ext.Ajax.request({
			url: 'delete_custom.php',
			params:{CustomID:custom.id},
			method:'POST',
			success:this.deleteCustomSuccess,
			failure:this.deleteCustomFailure,
			scope:this.store.load()
		});
		//console.log('deleteCustom');
	},
	
	deleteCustomSuccess:function(response,opts){
		showAjaxResponseMsg( response, "删除成功", true);
	},
	deleteCustomFailure:function(response,opts){
		showAjaxResponseMsg( response, "删除失败：稍后请重试！");
	},
	
	addSelectedCustomsToSmsQueue : function(btn) {
		var reg = /^((\+86)?|(86)?)(13[0-9]{9}|15[0|1|2|3|5|6|7|8|9]\d{8}|18[0|5|6|7|8|9]\d{8})$/;
		var _grid=Ext.getCmp("widget.CustomList");
		selModel=this.selModel;
		var selRecords = selModel.getSelection();
		var Ids = "";
		var Tels = "";
		if(selModel.hasSelection()){
			for(var i = 0; i < selRecords.length; i++){
				if(!reg.test(selRecords[i].get("Mobile"))){
					showErrorMsg('客户填写的手机号码:'+ selRecords[i].get("Mobile") +'不是有效的手机号码','错误');
					return;
				}
				
				Ids += selRecords[i].get("id");
				Tels += selRecords[i].get("Mobile");
			    if(i < selRecords.length-1) {
			    	Ids += ",";
			    	Tels += ",";
			    }
			}
			Ext.MessageBox.confirm("提示信息","确定批量添加吗？",function(btn){
				if(btn == "yes"){
					Ext.Ajax.request({
						url:"sms_queue_addmore.php",
						method:"POST",
						params:{ids:Ids,tels:Tels},
						success:function(){
							alert("批量添加成功！");
						},
						failure:function(){
							alert("批量添加失败！");
						},
						scope:_grid.store.load()
					});
				}
			});
			
		}else{
			Ext.MessageBox.alert("提示","请至少选择一条记录操作！");
		}
	},
	
	hideSelectedCustoms : function() {
		console.log('hideSelectedCustoms');
	},
	
	deleteSelectedCustoms : function(btn) {
		var _grid=Ext.getCmp("widget.CustomList");
		selModel=this.selModel;
		var selRecords = selModel.getSelection();
		var Ids = null;
		if(selModel.hasSelection()){
			for(var i = 0; i < selRecords.length; i++){
				Ids += selRecords[i].get("id");
			    if(i < selRecords.length-1) Ids += ",";
			}
			
			Ext.MessageBox.confirm("提示信息","确定删除吗？",function(btn){
				if(btn == "yes"){
					Ext.Ajax.request({
						url:"delete_customs.php",
						method:"POST",
						params:{ids:Ids},
						success:this.deleteCustomSuccess,
						failure:this.deleteCustomFailure,
						scope:_grid.store.load()
					});
				}
			});
			
		}else{
			Ext.MessageBox.alert("提示","请至少选择一条记录操作！");
		}
}
});
}
