if (!Ext.ModelManager.isRegistered('GiftConvertWidget')) {
	Ext
			.define(
					'GiftConvertWidget',
					{
						extend : 'Ext.grid.Panel',
						alias : 'widget.GiftConvertWidget',
						theGiftEdit : null,
						theGiftEdit_add : null,
						combStore : null,
						initComponent : function() {
							this.store = Ext.create('Ext.data.Store', {
								autoDestroy : true,
								model : 'giftConvertRecord',
								pageSize : 20,
								proxy : {
									type : 'ajax',
									url : 'giftConvertRecord.php',
									extraParams : {
										'action' : 'init'
									},
									reader : {
										type : 'json',
										root : 'records',
										totalProperty : 'total',
										id : 'id'
									}
								},
								autoLoad : true
							});
							gift_store = this.store;// 给外部变量赋值

							// ////////////////////////////////////////////////////////////////////////

							// 添加，新属性
							Ext
									.apply(
											this,
											{
												id : 'widget.GiftConvertWidget',
												title : '礼品兑换记录',
												closable : true,
												autoScroll : true,
												listeners : {
													'itemdblclick' : function(obj,record, item, index,e, eOpts) {
														var stat=obj.store.getAt(index).get('status');//得到‘已经发货’
														var convertId=obj.store.getAt(index).get('convertId');//得到选中行的Id
														this.createWin(stat,convertId);
													}
												},
												columns : [ {
													xtype : 'rownumberer',
													width : 40
												}, {
													text : 'convertId',
													width : 80,
													sortable : true,
													dataIndex : 'convertId',
													hidden : false
												}, {
													text : '礼品名称',
													width : 180,
													sortable : true,
													dataIndex : 'lpName'
												}, {
													text : '客户名称',
													width : 180,
													sortable : true,

													dataIndex : 'customName'
												},

												{
													text : '收货地址',
													width : 140,
													sortable : true,

													dataIndex : 'address'
												}, {
													text : '附加说明',
													width : 100,
													sortable : true,

													dataIndex : 'notice'
												}, {
													text : '创建时间',
													width : 200,
													sortable : true,
													dataIndex : 'createTime'
												}, {
													text : '结束时间',
													width : 200,
													sortable : true,

													dataIndex : 'endTime'
												}, {
													id : 'stateCb',
													text : '兑换状态',
													width : 100,
													editor : 'combo',
													dataIndex : 'status'
											
												} ],
												// plugins : [ this
												// .createEdit_plugins() ],
												dockedItems : [
														{
															xtype : 'pagingtoolbar',
															store : this.store, // same
															dock : 'bottom',
															displayInfo : true
														}
//														,
//														{
//															xtype : 'toolbar',
//															items : [
//																	'搜索',
//																	{
//																		xtype : 'textfield',
//																		name : 'searchText',
//																		tooltip : {
//																			text : '可以在此输入礼品名称进行模糊查询。',
//																			title : '搜索提示'
//																		},
//																		hideLabel : true,
//																		width : 130,
//																		listeners : {
//																			change : {
//																				fn : function(
//																						field,
//																						newValue,
//																						oldValue) {
//																					this.searchText = newValue;
//																				},
//																				scope : this,
//																				buffer : 100
//																			}
//																		}
//																	},
//																	{
//																		text : '开始搜索',
//																		tooltip : '开始搜索',
//																		iconCls : 'search',
//																		scope : this,
//																		handler : this.startSearch
//																	},
//																	]
//														} 
														]
											});

							this.callParent(arguments);
						},
//						startSearch : function() {
//							var store = this.store;
//							var proxy = store.getProxy();
//							proxy.extraParams.query = this.searchText;
//							proxy.extraParams.action = 'query';
//							store.loadPage(1);
//						
//
//						},
						createcombStore : function() {
							this.combStore = Ext.create('Ext.data.Store', {
								fields : [ 'dm', 'vm' ],
								data : [ {
									"dm" : "等待发货",
									"vm" : "等待发货"
								}, {
									"dm" : "已经发货",
									"vm" : "已经发货"
								} ]
							});
							return this.combStore;
						},
						createWin : function(stat,convertId) {
							Ext.create('Ext.window.Window', {
								title : '更改记录状态',
								height : 200,
								width : 300,
								layout : 'fit',
								items : { 
									xtype : 'form',
									id:'theFormPanel',
									border : false,
									items : [ {
										fieldLabel : '请选择状态：',
										id:'cbStatus_',
										xtype : 'combo',
										store : this.createcombStore(),
										queryMode : 'local',
										displayField : 'dm',
										valueField : 'vm',
										value:stat,
										editable :false
									} ],
									buttons : [
												{
													text : '重置',
													handler : function() {
														var form = this
														.up('form');
														form.getForm().reset();
													}
												},
												{
													text : '提交',
													formBind : true,
													disabled : false,
													handler : function() {
														//得到当前钱的 ID
														var form = this
																.up('form')
																.getForm();
														var theCbValue= Ext.getCmp('cbStatus_').value;
														
														
														if (form
																.isValid()) {
															form.submit({
																		url : 'giftConvertRecordEdit.php',
																		params : {
																			grId :convertId,
																			cbState:theCbValue
																		},

																		success : function(
																				vform,
																				action) {
																			gift_store
																					.load();//重新加载数据
																			Ext.Msg
																					.alert(
																							'提示',
																							'更新成功！');
																			vform
																					.reset();
																			Ext.getCmp('theFormPanel').up('window').close();

																		},
																		failure : function(
																				vform,
																				action) {
																			Ext.Msg
																					.alert(
																							'失败提示',
																							action.result.errors);
																			vform
																					.reset();
																			Ext.getCmp('theFormPanel').up('window').close();
																		}
																	});
														}
													}
												} ]
								}
								
							}).show();
						}
					});

}
var gift_store = null;