if (!Ext.ModelManager.isRegistered('HistoryOrderList')){
Ext.define('HistoryOrderList', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.HistoryOrderList',
	
	initComponent : function() {		
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'Order',
			proxy: {
				type: 'ajax',
				url: 'historyorders.php',
				reader: {
					type: 'json',
					root: 'orders',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		Ext.apply(this, {
			id : 'widget.HistoryOrderList',
			title : '历史订单',
			autoScroll : true,
			closable : true,
			viewConfig: {
	            stripeRows: true
	        },
			columns: [{
	                xtype: 'actioncolumn',
	                width: 20,
	                items: [{
	                    icon   : 'images/list.png',
	                    altText: '查看详情',
	                    tooltip: '查看详情',
	                    handler: this.showDetail,
	                    scope: this
	                }]
	            },{
	                text     : 'ID',
	                width    : 50,
	                sortable : true,
	                dataIndex: 'id'
	            },
	            {
	                text     : '餐馆',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'Restaurant'
	            },{
	                text     : '代理',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'Agent'
	            },{
	                text     : '客户',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'CustomName'
	            },{
	                text     : '类型',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Takeout'
	            },{
	                text     : '客户手机号码',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Mobile'
	            },{
	                text     : '客户地址',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Address'
	            },{
	                text     : '就餐时间',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'TimeNote'
	            },{
	                text     : '验证码',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'VeriCode'
	            },{
	                text     : '要求',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Notes'
	            },{
	                text     : '合计',
	                width    : 50,
	                sortable : true,
	                dataIndex: 'Total'
	            },{
	                text     : '折扣',
	                width    : 50,
	                sortable : true,
	                dataIndex: 'Discount'
	            },{
	                text     : '折后价',
	                width    : 50,
	                sortable : true,
	                dataIndex: 'DiscountTotal'
	            },{
	                text     : '状态',
	                width    : 80,
	                sortable : true,
	                dataIndex: 'Status'
	            },{
	                text     : '催餐',
					xtype	 : 'checkcolumn',
	                width    : 40,
	                sortable : true,
	                dataIndex: 'Urged'
	            },{
	                text     : '已发短信',
					xtype	 : 'checkcolumn',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'SmsSent'
	            },{
	                text     : '创建时间',
	                width    : 130,
	                sortable : true,
	                dataIndex: 'CreateTime'
	            },{
	                text     : '开始送餐时间',
	                width    : 130,
	                sortable : true,
	                dataIndex: 'CTime'
	            },{
	                text     : '结束时间',
	                width    : 130,
	                sortable : true,
	                dataIndex: 'EndTime'
	            }],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			}]
		});
		this.callParent(arguments);
	},
	
	showDetail : function(grid, rowIndex, colIndex) {
		var order = this.store.data.items[rowIndex].data;
		var detailWin = Ext.create('OrderDetailWindow',{order : order});
		detailWin.show();
	}
});
}