if (!Ext.ModelManager.isRegistered('HomePageSetting')){
Ext.define('HomePageSetting', {
	extend : 'Ext.form.Panel',
	alias  : 'widget.HomePageSetting',
	
	id : 'widget.HomePageSetting',
	title : '主页设置',
	closable : true,
	autoScroll : true,
    bodyPadding: 10,
    fieldDefaults : {
        msgTarget: 'side',
        labelWidth: 100,
        labelAlign: 'right'
    },
    
    html: '<img id="home_page_setting_image_preview" ' +
    		' style="visibility:hidden; position:absolute;left:0;top:0;"/>',
	
	initComponent : function() {
		var pageSettings =  Ext.create('Ext.data.Store', {
			model: 'PageSetting',
			proxy: {
				type: 'ajax',
				url: 'page_settings_get.php',
				reader: {
					type: 'json',
					root: 'settings'
				}
			},
			listeners: {
				'load': function(store, records, options) {
					if(records && records.length>0){
						this.getForm().loadRecord(records[0]);
					}
				},
				scope: this
			}
		});
		pageSettings.load();
		
		Ext.apply(this, {
			items: [{
		    	xtype: 'fieldset',
		    	title: '欢迎图片',
				defaultType: 'textfield',
				padding: 10,
		    	items: [{
					fieldLabel: '欢迎图片',
					width: 400,
					name: 'HOME_WELCOME_IMAGE',
					value: 'images/welcome_intro.png',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
            		xtype: 'label',
            		text: '请输入图片的相对地址。按回车键察看图片以确认输入无误，双击图片可以隐藏图片。',
            		cls: 'form_tips'
            	}]
			},{
		    	xtype: 'fieldset',
		    	title: '图片轮播',
				defaultType: 'textfield',
				padding: 10,
		    	items: [{
					fieldLabel: '图片1',
					width: 400,
					name: 'HOME_HELLO_IMAGE1',
					value: 'images/index_hero_1.jpg',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
					fieldLabel: '图片2',
					width: 400,
					name: 'HOME_HELLO_IMAGE2',
					value: 'images/index_hero_3.jpg',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
					fieldLabel: '图片3',
					width: 400,
					name: 'HOME_HELLO_IMAGE3',
					value: 'images/index_hero_5.jpg',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
					fieldLabel: '图片4',
					width: 400,
					name: 'HOME_HELLO_IMAGE4',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
					fieldLabel: '图片5',
					width: 400,
					name: 'HOME_HELLO_IMAGE5',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
					fieldLabel: '图片6',
					width: 400,
					name: 'HOME_HELLO_IMAGE6',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
            		xtype: 'label',
            		text: '请输入图片的相对地址。按回车键察看图片以确认输入无误，双击图片可以隐藏图片。',
            		cls: 'form_tips'
            	}]
			},{
		    	xtype: 'fieldset',
		    	title: '提示文字',
				defaultType: 'textareafield',
				padding: 10,
		    	items: [{
					fieldLabel: '餐厅定制提示',
					width: 400,
					height: 40,
					value: '小提示：以下餐厅仅为示例，可能无法为您提供外卖，您可以删除它们，定制您附近的外卖餐厅。',
					name: 'HOME_LEFT_HINT'
		    	},{
					fieldLabel: '在线订餐提示',
					width: 400,
					height: 40,
					value: '(点击左侧的餐品，然后这里下单，外卖自动上门啦)',
					name: 'HOME_CART_HINT'
		    	},{
		    		xtype: 'textfield',
					fieldLabel: '订餐鼓励标题',
					width: 400,
					value: '还是不太敢在线订餐？',
					name: 'HOME_ENCOURAGE_TITLE'
		    	},{
					fieldLabel: '订餐鼓励',
					width: 400,
					height: 40,
					value: '别担心，你的订单会立刻得到处理，外卖进度还会实时反馈给你。很多人已经用上瘾了，你也试一次吧。',
					name: 'HOME_ENCOURAGE'
		    	}]
			},{
				xtype: 'panel',
				border: false,
				frame: false,
				buttonAlign: 'left',
				buttons: [{
		            text: '保存',
		            handler: this.submitForm,
		            scope: this
		        },{
		            text: '重置',
		            handler: function() {this.getForm().reset();},
		            scope: this
		        }]
			}]
		});
		this.callParent(arguments);
	},
	
	imagePriview : function(field, e) {
		if(e.getKey()==e.ENTER) {
			var img = Ext.get('home_page_setting_image_preview');
		    img.dom.src=baseUrl+field.getValue();
			var preview = Ext.create('Ext.resizer.Resizer', {
		        target: img,
		        preserveRatio: true
		    });
		    var previewEl = preview.getEl();
		    previewEl.on('dblclick', function(){
		        previewEl.hide(true);
		    });
		    img.show();
			previewEl.setX(field.getEl().getX() + field.getEl().getWidth());
			previewEl.setY(field.getEl().getY());
			previewEl.show(true);
		}
	},
	
	submitForm : function() {
		var form = this.getForm();
		if (form.isValid()) {
			this.submit({
				url:'page_settings_save.php',
				waitTitle : '请稍候',
				waitMsg : '正在保存系统配置...',
				method : 'POST',
		        success: this.saveSettingsSuccess,
		        failure: this.saveSettingsFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('某些输入项不符合规定，请检查各字段的输入。','输入有误。');
		}
	},
	
	saveSettingsSuccess : function (form, action) {
		showSuccessMsg('保存主页设置成功。');
	},
	
	saveSettingsFailure : function (form, action) {
		showFormFailureMsg( action, '保存主页设置失败');
	}
});
}

/** 
* @class Ext.app.ColorPicker 
* @extends Ext.container.Container 
* 定义颜色选取类 
*/ 

Ext.define ('Ext.app.ColorPicker', { 
	extend: 'Ext.container.Container', 
	alias: 'widget.smmcolorpicker', 
	layout: 'hbox', 
	
	initComponent:function() { 
		var mefieldLabel = this.fieldLabel; 
		var mename = this.name; 
		var meheight = this.height; 
		var meid = this.id; 
		var value = this.value;
		var initValue = value;
		this.items = [{ 
			xtype: 'textfield', 
			height: meheight, 
			id:meid+'x', 
			fieldLabel:mefieldLabel, 
			name: mename,
			value: value,
			flex: 1, 
			listeners: {
				scope: this,
				change:function(me, newValue, oldValue) { 
					me.bodyEl.down('input').setStyle('background-image', 'none'); 
					me.bodyEl.down('input').setStyle('background-color', newValue);
				},
				afterrender : function( me, eOpts ){
					me.bodyEl.down('input').setStyle('background-image', 'none'); 
					me.bodyEl.down('input').setStyle('background-color', this.value);
				}
			} 
		}, 
		{
			xtype:'button', 
			width:18, 
			height: meheight, 
			menu: { 
				xtype:'colormenu', 
				listeners: { 
					select: function(picker, color) { 
						var amclr = Ext.getCmp(meid+'x'); 
						amclr.setValue('#'+color); 
					} 
				} 
			} 
		}, 
		{
			xtype:'button', 
			width:18, 
			height: meheight, 
			cls: 'undo',
			handler: function () {
				var amclr = Ext.getCmp(meid+'x');
				amclr.setValue(initValue); 
				amclr.bodyEl.down('input').setStyle('background-image', 'none'); 
				amclr.bodyEl.down('input').setStyle('background-color', initValue);
			}
		}]; 
		
		this.callParent(arguments); 
	}
}); 
