if (!Ext.ModelManager.isRegistered('MainWin')) {
Ext.define('MainWin', {
	extend : 'Ext.container.Viewport',
	isrestaurant : null,
	initComponent : function() {
		var head_html = '<div class="head">'
				+ '<div class="logo"><img src="images/logo.jpg"/></div>'
				+ '<div class="head_right">'
				+ '<div id="head_password"><a id="head_password_button" href="#"><img src="images/key.png"/>修改密码</a></div>'
				+ '<div id="head_timer">'
				+ getCurrentTimeText()
				+ '</div>'
				+ '<div class="clr"></div>'
				+ '<div id="head_logout"><a id="head_logout_button" href="#"><img src="images/logout.png"/>退出</a></div>'
				+ '<div id="user_info">' + this.realname + '</div>'
				+ '<div id="agent_info">' + this.displayname + '</div>'
				+ '<div class="clr"></div>' + '</div>'
				+ '<div class="clr"></div>' + '</div>';
		//isrestaurant: isrestaurant, realname: realname, displayname: displayname, privileges: privileges
		var header = {
			region : 'north',
			html : head_html,
			autoHeight : true,
			border : false
		};
		
		Ext.apply(this, {
			layout : 'border',
			items : [header, this.createMenuPanel(), this.createContentPanel()]
		});

		this.callParent(arguments);
		
	},
	
	createMenuPanel : function() {
		this.menuPanel =  Ext.create('widget.MyMenuPanel');
		return this.menuPanel;
	},
	
	createContentPanel : function() {
		this.contentPanel = Ext.create('Ext.panel.Panel',{
			region : 'center',
            layout: 'border',
			items : [{
				id : 'content-panel',
				xtype : 'tabpanel',
				region : 'center',
				activeTab : 0, // First tab active by default
				items : {
					id : 'welcome-tab',
					autoScroll : true,
					title : '　欢迎　',
					html : ''
				}
			},
			this.createCurrentOrderPanel()]
		});
		return this.contentPanel;
	},
	
	createCurrentOrderPanel : function() {
		this.currentOrderPanel = Ext.create('widget.CurrentOrderList');
		return this.currentOrderPanel;
	},

	afterRender : function() {
		MainWin.superclass.afterRender.apply(this, arguments);
		Ext.get("head_logout_button").on('click', this.showLogoutConfirm);
		Ext.get("head_password_button").on('click', this.showPasswordWin);
		
		this.menuPanel.setDisabled(true);
		this.menuMask = new Ext.LoadMask(this.menuPanel, {msg: "正在加载菜单..."});
		this.menuMask.show();
		this.mainMask = new Ext.LoadMask(Ext.getCmp('welcome-tab').getEl(), {msg: "正在加载欢迎页..."});
		this.mainMask.show();
		
		Ext.Ajax.request({
			url: 'menus.php',
			timeout: 60000,
			scope: this,
			success: this.loadMenuSuccess,
			failure: this.loadMenuFailed
		})
	},
	
	loadMenuSuccess : function(response, opts) {
		var json;
		
		try {
			json = Ext.decode(response.responseText);
		}
		catch(e){
			Ext.Msg.alert("系统错误", "菜单数据格式不对。");
			this.menuMask.hide();
			this.mainMask.hide();
		}
		
		if(json && json.success){
			this.addMenus(json.menus);
		}
		else {
			Ext.Msg.alert("装载菜单失败", json.msg);
			this.menuMask.hide();
			this.mainMask.hide();
			
			if(json && json.url){
				window.location.href = json.url;
			}
		}
	},
	
	loadMenuFailed : function(response, opts) {
		var msg = "由于网络或者服务器的原因，装载菜单失败：" +
				"<br>状态代码："+response.status +
				"<br>状态描述："+response.statusText;
		Ext.Msg.alert("装载菜单失败", msg);;
		this.menuMask.hide();
		this.mainMask.hide();
	},
	
	addMenus : function(menus){
		if(menus && menus.length>0){
			for(var i=0; i<menus.length; i++){
				this.addMenu(menus[i]);
			}
		}
		
		this.mainMask.hide();
		this.menuMask.hide();
		this.menuPanel.setDisabled(false);
	},
	
	addMenu : function(menu){
		if(!menu) return;
		
		var menuItems = "";
		var menuItemIds = new Array();
		var welcomeTab = Ext.get("welcome-tab-body");
		if(menu.items && menu.items.length>0){
			for(var i=0; i<menu.items.length; i++){
				var menuItem = menu.items[i];
				menuItemIds.push('menu_'+menuItem.widget);
				menuItems += '<div id="menu_'+menuItem.widget+'" ' +
						'class="menu_item '+menuItem.icon+'">' +
						menuItem.label +
						'</div>';
				if(menuItem.showAtHome && welcomeTab){
					var welcomeIcon = '<div id="welcome_'+menuItem.widget+'" class="welcome_icon '+menuItem.bigIcon+'">'+menuItem.label+'</div>';
					var e = Ext.DomHelper.append(welcomeTab, welcomeIcon,true);
					e.on('click', this.onClickWelcomeIcon)
				}
			}
		}
		
		this.menuPanel.add(new Ext.panel.Panel({
			frame: false,
			border: false,
			title: menu.label,
			iconCls: menu.icon,
			width: '100%',
			anchor: '100%',
			collapsible : true,
			html: menuItems
		}));
		
		for(var j=0; j<menuItemIds.length; j++){
			Ext.get(menuItemIds[j]).on('click',this.onClickMenu);
		}
	},
	
	onClickMenu : function(){
		if(this.id.substring(0,5)!="menu_") return;
		var widget = this.id.substring(5);
		var main = Ext.getCmp("content-panel");
		var tab = main.getComponent(widget);
		if(tab) {
			main.setActiveTab(tab);
		}
		else {
			var newTab = main.add(Ext.create(widget));
			main.setActiveTab(newTab)
		}
	},
	
	onClickWelcomeIcon: function() {
		if(this.id.substring(0,8)!="welcome_") return;
		var widget = this.id.substring(8);
		var main = Ext.getCmp("content-panel");
		var tab = main.getComponent(widget);
		if(tab) {
			main.setActiveTab(tab);
		}
		else {
			var newTab = main.add(Ext.create(widget));
			main.setActiveTab(newTab)
		}
	},

	showLogoutConfirm : function() {
		var config = {
			title : '确认退出',
			msg : '确定要退出吗？',
			closable : false,
			buttons : Ext.MessageBox.OKCANCEL,
			icon : Ext.MessageBox.QUESTION,
			animateTarget : 'head_logout_button',
			fn : function(btn, txt) {
				if (btn == "ok") {
					window.location.href = 'logout.php';
					}
				}
		};

		Ext.MessageBox.show(config);
	},
	
	showPasswordWin : function() {
		showPasswordWindow('head_password_button');
	}
});
}

function updateHeadTimer() {
	var headTimer = document.getElementById("head_timer");
	if (headTimer) {
		headTimer.innerHTML = getCurrentTimeText();
	}
	setTimeout(updateHeadTimer, 1000);
}

function getCurrentTimeText() {
	var d = new Date();
	d.setTime(d.getTime()-timeDiff);
	return d.getFullYear()+"年"+(d.getMonth()+1)+"月"+d.getDate()+"日 "+d.toLocaleTimeString();
//	return new Date().toLocaleString(); //chrome格式化的字符串不是我们想要的形式
}

setTimeout(updateHeadTimer, 1000);