/**
 * 
 */
function makeMapInDiv(divId, lat, lng, zoom){
	if(!lat) lat = 34.884267663;
	if(!lng) lng = 103.751163;
	if(!zoom) zoom = 3;
	var latlng = new google.maps.LatLng(lat, lng);
	var myOptions = {
		zoom: zoom,
		center: latlng,
		streetViewControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
    };
	var map = new google.maps.Map(document.getElementById(divId), myOptions);
	
	return map;
}

/**
 * 此函数用于将number四舍五入到小数点后指定的位数。经纬度需要进行此操作。
 * @param {} number
 * @param {} precision
 * @return {}
 */
function toPrecision ( number, precision ) {
	return Math.round(number * Math.pow(10, precision)) / Math.pow(10, precision);
}