if (!Ext.ModelManager.isRegistered('MonthlyReport')){
Ext.define('MonthlyReport', {
	extend : 'Ext.tree.Panel',
	alias  : 'widget.MonthlyReport',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.TreeStore',{
			autoDestroy: true,
			model: 'CommissionTreeNode',
			proxy: {
				type: 'ajax',
				url: 'commissions.php',
				extraParams: {
					close : true
				},
				timeout : 30*60*1000
			},
			sorters: [{
				property: 'leaf',
				direction: 'ASC'
//			},{
//				property: 'text',
//				direction: 'ASC'
			}],
			folderSort: true,
			root: {
				text: '根节点',
				id: 0,
				expanded: true
			},
			listeners: {
				load: function(store,node, records, successful, opts) {
					store.getProxy().extraParams.close = false;
				}
			}
		});
		
		
		Ext.apply(this, {
			id : 'widget.MonthlyReport',
			title : '财务管理-按月查询',
			closable : true,
			autoScroll : true,
			useArrows: true,
			rootVisible: false,
			multiSelect: true,
			
	        columns: [
//	        	{
//	        		xtype	 : 'rownumberer',
//	                width    : 40
//	        	},
	        	{
					xtype: 'treecolumn',
	                text     : '名称',
	                width    : 400,
	                sortable : true,
	                dataIndex: 'text'
	            },
	            {
	                text     : '年份',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'Year',
	                align : 'center'
	            },
	            {
	                text     : '月份',
	                width    : 40,
	                sortable : true,
	                dataIndex: 'Month',
	                align : 'center'
	            },
	            {
	                text     : '时间',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'Days',
	                align : 'center'
	            },
	            {
	                text     : '销售额（元）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Sale',
	                align : 'right'
	            },
	            {
	                text     : '佣金比率（%）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Rate',
	                align : 'right'
	            },
	            {
	                text     : '佣金费（元）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Commission',
	                align : 'right'
	            },
	            {
	                text     : '状态',
	                minWidth : 200,
	                sortable : true,
	                dataIndex: 'Status',
	                align	 : 'center',
	                editor: {
						xtype: 'combo',
						store: [
		                    ['已结算','已结算'],
		                    ['未结算','未结算']
		                ],
		                lazyRender: true,
		                listClass: 'x-combo-list-small',
		                listeners: {
							scope: this,
							'select' : function(combobox, value){
								//this.searchOperation = value[0].data.field1;
							}
						}
	                }
	            }
	        ],
	        dockedItems: [{
				xtype: 'toolbar',
				items: ['搜索：　',{
					xtype: 'numberfield',
					width: 60,
					name: 'searchYear',
					value: new Date().getFullYear(),
					hideLabel: true,
					minValue: 2012,
					maxValue: 2030,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchYear = newValue;
						}
					}
				},'年　',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMonth',
					hideLabel: true,
					value: (new Date().getMonth()+1),
					minValue: 1,
					maxValue: 12,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMonth = newValue;
						}
					}
				},'月　',{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchYear = this.searchYear;
		proxy.extraParams.searchMonth = this.searchMonth;
		proxy.extraParams.type = 'monthly';
		//解决一个BUG：
		//@see http://blog.csdn.net/fruitsdrink/article/details/7072435
		var delNode;
		while (delNode = this.getRootNode().childNodes[0]) {
			this.getRootNode().removeChild(delNode);
		}
		store.load();
	}
});
}