if (!Ext.ModelManager.isRegistered('QAList')){
Ext.define('QAList', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.QAList',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'QA',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'qas.php',
				reader: {
					type: 'json',
					root: 'qas',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		this.rowEditing = Ext.create('Ext.ux.grid.plugin.RowEditing', {
			clicksToEdit : 1,		//双击进入编辑
			clicksToMoveEditor: 2,	//编辑过程中单击其他行开始编辑其他行
			autoCancel: false,		//编辑过程中单击其他行是否自动取消本行的数据保存，否
			errorSummary : false
		});
		
		Ext.apply(this, {
			id : 'widget.QAList',
			title : '留言列表',
			closable : true,
			autoScroll : true,
	        columns: [
	        	{
	        		xtype	 : 'rownumberer',
	                width    : 40
	        	},
	        	{
	                text     : '用户名',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Name'
	            },
	            {
	                text     : '电子邮件',
	                width    : 160,
	                sortable : true,
	                dataIndex: 'Email'
	            },
	            {
	                text     : 'IP地址',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'IP'
	            },
	            {
	                text     : '疑问内容',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'Question',
	                editor: {
						xtype : 'textarea',
						height : 70,
						readOnly : true
					}
	            },
	            {
	                text     : '提问时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'QTime'
	            },
	            {
	                text     : '答复内容',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'Answer',
	                editor: {
						xtype: 'textarea',
						height: 70
					}
	            },
	            {
	                text     : '答复时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'ATime'
	            },
	            {
					xtype	 : 'checkcolumn',
	                text     : '首页显示',
	                width	 : 60,
	                sortable : true,
	                editable : false, //由我扩展，哈哈。
	                dataIndex: 'Show',
					editor: {
						xtype: 'checkbox',
						cls: 'x-grid-checkheader-editor'
					}
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: ['搜索',{
					xtype: 'textfield',
					name: 'searchText',
					tooltip:{text:'可以在此输入代理名称、城市名称、操作员姓名、用户名、附加数据或描述等进行模糊查询。',title:'搜索提示'},
					hideLabel: true,
					width: 130,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchText = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 },
						 afterrender: {
						 	fn: function(field) {
							 		if(field.tooltip.text){   
					                    new Ext.ToolTip({
					                        target:field.id,
					                        trackMouse:false,
					                        draggable:true,
					                        maxWidth:300,
					                        minWidth:100,
					                        title:"<span style='color:green'>" + field.tooltip.title + "</span>",
					                        html:"<span style='color:green'>" + field.tooltip.text + "</span>"
					                    }); 
					                }  
							 	}
						 }
					}
				},' 留言时间：从',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateFrom',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateFrom = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourFrom',
					id: 'qa_list_widget_search_hour_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourFrom = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteFrom',
					id: 'qa_list_widget_search_minute_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteFrom = newValue;
						}
					}
				},'　到',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateEnd',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateEnd = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourEnd',
					id: 'qa_list_widget_search_hour_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourEnd = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteEnd',
					id: 'qa_list_widget_search_minute_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteEnd = newValue;
						}
					}
				},'　IP',{
					xtype: 'textfield',
					name: 'searchIP',
					hideLabel: true,
					width: 110,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchIP = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 }
					}
				},{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}],
			plugins: [this.rowEditing],
			listeners: {
				scope: this,
				'edit' : this.afterEdit,
				'canceledit' : this.cancelEdit,
				'beforeedit' : this.beforeEdit,
				'select' : this.onRowSelected
			}
//	        ,plugins: [{
//	        	pluginId : 'qalist_rowexpander',
//	            ptype: 'rowexpander',
//	            rowBodyTpl : [
//	                '<p><b>提问内容:</b> {Question}</p>',
//	                '<p><b>回答内容:</b> {Answer}</p>'
//	            ]
//	        }]
		});
		this.pendingQaRequest = new Ext.util.MixedCollection();
		this.callParent(arguments);
	},
	
	afterEdit : function(editor) {
		if(editor.record.dirty){ //编辑记录，并且数据已经变更
			var request = Ext.Ajax.request({
    			url: 'update_qa.php',
    			params: editor.record.data,
    			method: 'POST',
    			success: this.updateQASuccess,
    			failure: this.updateQAFailure,
    			scope: this
    		});
		}
    	this.pendingQaRequest.add(request.id,editor.record);
		if(this.selectedRow) this.selectedRow.style.height = '25px';
		this.getSelectionModel().setLocked(false);
	},
	
	updateQASuccess : function(response, opts) {
    	var success = showAjaxResponseMsg( response, "修改答疑回复", true);
    	var record = this.pendingQaRequest.getByKey(response.requestId);
    	if (record) {
    		if(success){
    			record.data.ATime = Ext.Date.format(new Date(), 'Y-m-d H:i:s');
    			record.commit();
    		}
    		else {
    			record.reject();
    		}
    	}
    	this.pendingQaRequest.removeAtKey(response.requestId);
    },
    
    updateQAFailure : function(response, opts) {
    	showAjaxResponseMsg( response, "修改答疑回复");
    	
    	var record = this.pendingQaRequest.getByKey(response.requestId);
    	if (record) {
    		record.reject();
    	}
    	this.pendingQaRequest.removeAtKey(response.requestId);
    },
    
	cancelEdit : function(grid, eOpts) {
		if(this.selectedRow) this.selectedRow.style.height = '25px';
		this.getSelectionModel().setLocked(false);
	},
	
	beforeEdit : function(editor, e) {
		if(this.selectedRow) this.selectedRow.style.height = '80px';
		this.getSelectionModel().setLocked(true);
	},
	
	onRowSelected : function ( rowModel, record, index, eOpts ) {
		if(this.selectedRow) this.selectedRow.style.height = '25px';
		this.selectedRow = this.view.getNode(index);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		if(this.searchDateFrom!='' && this.searchDateFrom!=null){
			if(this.searchHourFrom==null || this.searchHourFrom==''){
				this.searchHourFrom = 0;
				Ext.getCmp('qa_list_widget_search_hour_from').setValue(0);
			}
			if(this.searchMinuteFrom==null || this.searchMinuteFrom==''){
				this.searchMinuteFrom = 0;
				Ext.getCmp('qa_list_widget_search_minute_from').setValue(0);
			}
		}
		proxy.extraParams.searchDateFrom = this.searchDateFrom;
		proxy.extraParams.searchHourFrom = this.searchHourFrom;
		proxy.extraParams.searchMinuteFrom = this.searchMinuteFrom;
		if(this.searchDateEnd!='' && this.searchDateEnd!=null){
			if(this.searchHourEnd==null || this.searchHourEnd==''){
				this.searchHourEnd = 23;
				Ext.getCmp('qa_list_widget_search_hour_end').setValue(23);
			}
			if(this.searchMinuteEnd==null || this.searchMinuteEnd==''){
				this.searchMinuteEnd = 59;
				Ext.getCmp('qa_list_widget_search_minute_end').setValue(59);
			}
		}
		proxy.extraParams.searchDateEnd = this.searchDateEnd;
		proxy.extraParams.searchHourEnd = this.searchHourEnd;
		proxy.extraParams.searchMinuteEnd = this.searchMinuteEnd;
		proxy.extraParams.searchIP = this.searchIP;
		store.loadPage(1);
	}
});
}