if (!Ext.ModelManager.isRegistered('RightSideSetting')){
Ext.define('RightSideSetting', {
	extend : 'Ext.form.Panel',
	alias  : 'widget.RightSideSetting',
	
	title : '总体设置',
	closable : true,
	autoScroll : true,
    bodyPadding: 10,
    fieldDefaults : {
        msgTarget: 'side',
        labelWidth: 100,
        labelAlign: 'right'
    },
    
    html: '<img id="right_setting_image_preview" ' +
    		' style="visibility:hidden; position:absolute;left:0;top:0;"/>',
	
	initComponent : function() {
		var pageSettings =  Ext.create('Ext.data.Store', {
			model: 'PageSetting',
			proxy: {
				type: 'ajax',
				url: 'page_settings_get.php',
				reader: {
					type: 'json',
					root: 'settings'
				}
			},
			listeners: {
				'load': function(store, records, options) {
					if(records && records.length>0){
						this.getForm().loadRecord(records[0]);
					}
				},
				scope: this
			}
		});
		pageSettings.load();
		
		Ext.apply(this, {
			items: [{
		    	xtype: 'fieldset',
		    	title: '网站Logo',
				defaultType: 'textfield',
				padding: 10,
		    	items: [{
					fieldLabel: '网站Logo',
					width: 400,
					name: 'LOGO_IMAGE',
					value: 'images/logo.png',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
            		xtype: 'label',
            		text: '请输入图片的相对地址。按回车键察看图片以确认输入无误，双击图片可以隐藏图片。',
            		cls: 'form_tips'
            	},{
            		xtype: 'label',
            		text: '网站的标题图标（收藏夹图标）请自行替换根目录下的favicon.ico来更改。',
            		cls: 'form_tips'
            	}]
			},{
		    	xtype: 'fieldset',
		    	title: '背景',
				defaultType: 'textfield',
				padding: 10,
		    	items: [{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '背景颜色',
					width: 200,
					name: 'BG_COLOR',
					value: '#F3F3F3'
		    	},{
					fieldLabel: '背景图片',
					width: 400,
					name: 'BG_IMAGE',
					listeners: 	{
						scope: this,
						specialkey: this.imagePriview
					}
		    	},{
            		xtype: 'label',
            		text: '请输入图片的相对地址。按回车键察看图片以确认输入无误，双击图片可以隐藏图片。',
            		cls: 'form_tips'
            	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '右侧背景颜色',
					width: 200,
					name: 'RIGHT_BG_COLOR',
					value: '#0F91CF'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '右侧文字颜色',
					width: 200,
					name: 'RIGHT_TEXT_COLOR',
					value: '#FFFFFF'
		    	}]
			},{
		    	xtype: 'fieldset',
		    	title: '操作结果提示框',
				defaultType: 'textfield',
				padding: 10,
		    	items: [{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '成功提示背景颜色',
					width: 200,
					name: 'SUCCESS_BG_COLOR',
					value: '#7ED10E'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '成功提示文字颜色',
					width: 200,
					name: 'SUCCESS_TEXT_COLOR',
					value: '#FFFFFF'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '错误提示背景颜色',
					width: 200,
					name: 'ERROR_BG_COLOR',
					value: '#F23030'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '错误提示文字颜色',
					width: 200,
					name: 'ERROR_TEXT_COLOR',
					value: '#FFFFFF'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '信息提示背景颜色',
					width: 200,
					name: 'INFO_BG_COLOR',
					value: '#FC9C0F'
		    	},{
		    		xtype: 'smmcolorpicker',
					fieldLabel: '信息提示文字颜色',
					width: 200,
					name: 'INFO_TEXT_COLOR',
					value: '#FFFFFF'
		    	}]
			},{
				xtype: 'panel',
				border: false,
				frame: false,
				buttonAlign: 'left',
				buttons: [{
		            text: '保存',
		            handler: this.submitForm,
		            scope: this
		        },{
		            text: '重置',
		            handler: function() {this.getForm().reset();},
		            scope: this
		        }]
			}]
		});
		this.callParent(arguments);
	},
	
	imagePriview : function(field, e) {
		if(e.getKey()==e.ENTER) {
			var img = Ext.get('right_setting_image_preview');
		    img.dom.src=baseUrl+field.getValue();
			var preview = Ext.create('Ext.resizer.Resizer', {
		        target: img,
		        preserveRatio: true
		    });
		    var previewEl = preview.getEl();
		    previewEl.on('dblclick', function(){
		        previewEl.hide(true);
		    });
		    img.show();
			previewEl.setX(field.getEl().getX() + field.getEl().getWidth());
			previewEl.setY(field.getEl().getY());
			previewEl.show(true);
		}
	},
	
	submitForm : function() {
		var form = this.getForm();
		if (form.isValid()) {
			this.submit({
				url:'page_settings_save.php',
				waitTitle : '请稍候',
				waitMsg : '正在保存系统配置...',
				method : 'POST',
		        success: this.saveSettingsSuccess,
		        failure: this.saveSettingsFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('某些输入项不符合规定，请检查各字段的输入。','输入有误。');
		}
	},
	
	saveSettingsSuccess : function (form, action) {
		showSuccessMsg('保存主页设置成功。');
	},
	
	saveSettingsFailure : function (form, action) {
		showFormFailureMsg( action, '保存主页设置失败');
	}
});
}
