<?php
require_once 'inc/functions.php';
$orders = get_history_orders_list();

include 'header_account.php';
?>
<link rel="stylesheet" type="text/css" media="screen" href="css/common.table.css"/>
<style type="text/css">
.order_list {
	font-size:12px;
}
.common_table {
	width:570px;
	margin-left:auto;
	margin-right:auto;
}
.table_outer {
	padding-bottom:20px;
	border-bottom:1px solid #ddd;
}
#pager a ,
#pager span {
	padding:0 3px;
}
.current_page {
	color:#000;
	text-decoration:none;
	background:none;
}
.sidebar_header {
	font-size:14px;
}
</style>

<script type="text/javascript">
document.title = "<?php echo $_SESSION['session_Setting_SITE_NAME']; ?> / 订单历史";
</script>

<div class="columns">
<div class="inner_columns">
<div class="left">
	<div id="content">
		<div id="settings_nav" class="tab_nav">
			<ul>
				<li>
					<a href="custom_account.php">帐号密码</a>
				</li>
				<li>
					<a href="custom_mobile.php">手机号码</a>
				</li>
				<li>
					<a href="custom_addresses.php">常用地址</a>
				</li>
				<li>
					<a href="custom_support.php">我的答疑</a>
				</li>
				<li class="current">
					<a href="custom_orders_list.php">订单历史</a>
				</li>
				<?php if(!empty($_SESSION['session_hasActiveOrder'])) { ?>
				<li>
					<a href="orders_myactive.php">当前订单</a>
				</li>
				<?php } ?>
			</ul>
		</div>
		<div class="table_outer">
			<table class="common_table order_list">
				<tr class="even">
					<th>时间</th>
					<th>餐厅名字</th>
					<th>总价</th>
					<th>状态</th>
				</tr>
				<?php foreach($orders as $index => $order) { ?>
				<tr class="<?php echo $index%2 ? "even" : "odd";?>">
					<td>
						<a href="orders_show.php?id=<?php echo $order['ID']; ?>"><?php echo $order['CreateTime']; ?></a>
					</td>
					<td>
						<a href="restaurant.php?uuid=<?php echo getRestaurantUUIDByID($order['RestaurantID']); ?>" target="_blank"><?php echo $order['Restaurant']; ?></a>
					</td>
					<td>
						<?php echo $order['Total']; ?>
					</td>
					<td>
						<?php echo $order['Status']; ?>
					</td>
				</tr>
				<?php } ?>
			</table>
		</div>
		<div id="pager">
			<div class="page_control">
			</div>
		</div>
	</div>
</div>
<div class="right">
	<div id="side">
		<div class="section">
			<div class="section-header">
				<h3 class="sidebar_header">
					订单历史
				</h3>
			</div>
			<p>
				您可以在这里查看到您的所有历史订单记录。
			</p><br/>
		</div>
	</div>
</div>
</div>
</div>

<?php include 'footer.php'; ?>