/*!
 * Name: GlassBubble.js
 **/
/**
 * An GlassBubble is like an info window, but it displays
 * under the marker, opens quicker, and has flexible styling.
 * @param {GLatLng} latlng Point to place bar at
 * @param {Map} map The map on which to display this GlassBubble.
 * @param {Object} opts Passes configuration options - content,
 *   offsetVertical, offsetHorizontal, className, height, width
 **/
function GlassBubble(opts) {
  google.maps.OverlayView.call(this);
  this.latlng_ = opts.latlng;
  this.map_ = opts.map;
  this.content_ = opts.content;
  if (opts.size == 'tiny') {
	  this.height_ = 56;
	  this.width_ = 134;
  } else if (opts.size == 'small') {
	  this.height_ = 114;
	  this.width_ = 358;
  } else {
	  this.height_ = 247;
	  this.width_ = 358;
  }
  this.offsetVertical_ =  -(this.height_ + 18) + (opts.offsetVertical||0);
  this.offsetHorizontal_ = -(this.width_ / 2 + 4) + (opts.offsetHorizontal||0);
  this.color_ = '#fff';
  this.size_ = opts.size;

  var me = this;
  this.boundsChangedListener_ =
    google.maps.event.addListener(this.map_, "bounds_changed", function() {
      return me.panMap.apply(me);
    });

  // Once the properties of this OverlayView are initialized, set its map so
  // that we can display it.  This will trigger calls to panes_changed and
  // draw.
  this.setMap(this.map_);
}

/* GlassBubble extends GOverlay class from the Google Maps API
 */
GlassBubble.prototype = new google.maps.OverlayView();

/* Creates the DIV representing this GlassBubble
 */
GlassBubble.prototype.remove = function() {
  if (this.div_) {
    this.div_.parentNode.removeChild(this.div_);
    this.div_ = null;
  }
};

/* Redraw the Bar based on the current projection and zoom level
 */
GlassBubble.prototype.draw = function() {
  // Creates the element if it doesn't exist already.
  this.createElement();
  if (!this.div_) return;

  // Calculate the DIV coordinates of two opposite corners of our bounds to
  // get the size and position of our Bar
  var pixPosition = this.getProjection().fromLatLngToDivPixel(this.latlng_);
  if (!pixPosition) return;

  // Now position our DIV based on the DIV coordinates of our bounds
  this.div_.style.width = this.width_ + "px";
  this.div_.style.left = (pixPosition.x + this.offsetHorizontal_) + "px";
  this.div_.style.height = this.height_ + "px";
  this.div_.style.top = (pixPosition.y + this.offsetVertical_) + "px";
  this.div_.style.display = 'block';
};

/* Creates the DIV representing this GlassBubble in the floatPane.  If the panes
 * object, retrieved by calling getPanes, is null, remove the element from the
 * DOM.  If the div exists, but its parent is not the floatPane, move the div
 * to the new pane.
 * Called from within draw.  Alternatively, this can be called specifically on
 * a panes_changed event.
 */
GlassBubble.prototype.createElement = function() {
  var panes = this.getPanes();
  var div = this.div_;
  if (!div) {
    // This does not handle changing panes.  You can set the map to be null and
    // then reset the map to move the div.
    div = this.div_ = document.createElement("div");
    div.style.border = "0px none";
    div.style.position = "absolute";
	if ($('body').hasClass('ie8')
			|| $('body').hasClass('ie9')
			|| $('body').hasClass('safari')
			|| $('body').hasClass('firefox')
			|| $('body').hasClass('opera')) {
		var backgroundData = this.normalBackground;
		if (this.size_ == 'small') {
			backgroundData = this.smallBackground;
		} else if (this.size_ == 'tiny') {
			backgroundData = this.tinyBackground;
		}
		div.style.background =   "url('data:image/png;base64," + backgroundData + "') 0 0 no-repeat";
	} else {
		var fileName = 'glass_bubble_bg';
		if (this.size_ == 'small') {
			fileName = 'glass_bubble_small_bg';
		} else if (this.size_ == 'tiny') {
			fileName = 'glass_bubble_tiny_bg';
		}
		var extName = (navigator.userAgent.toLowerCase().indexOf("msie 6")!=-1&&document.all) ? 'gif' : 'png';
		div.style.background =   "url('images/" + fileName + "." + extName + "') 0 0 no-repeat";
	}
    div.style.width = this.width_ + "px";
    div.style.height = this.height_ + "px";
    div.style.color = this.color_;
    div.style.cursor = 'default';
    var contentDiv = document.createElement("div");
    contentDiv.style.padding = "10px"
    $(contentDiv).append(this.content_ || '');

    var topDiv = document.createElement("div");
    topDiv.style.textAlign = "right";
	/*
    var closeImg = document.createElement("img");
    closeImg.style.width = "32px";
    closeImg.style.height = "32px";
    closeImg.style.cursor = "pointer";
    closeImg.style.display = "none";
    closeImg.src = "http://gmaps-samples.googlecode.com/svn/trunk/images/closebigger.gif";
    topDiv.appendChild(closeImg);

    function removeGlassBubble(ib) {
      return function() {
        ib.setMap(null);
      };
    }

    google.maps.event.addDomListener(closeImg, 'click', removeGlassBubble(this));
	*/

    div.appendChild(topDiv);
    div.appendChild(contentDiv);
    div.style.display = 'none';
    panes.floatPane.appendChild(div);
    this.panMap();
  } else if (div.parentNode != panes.floatPane) {
    // The panes have changed.  Move the div.
    div.parentNode.removeChild(div);
    panes.floatPane.appendChild(div);
  } else {
    // The panes have not changed, so no need to create or move the div.
  }
}

GlassBubble.prototype.close = function() {
	this.setMap(null);
}

/* Pan the map to fit the GlassBubble.
 */
GlassBubble.prototype.panMap = function() {
  // if we go beyond map, pan map
  var map = this.map_;
  var bounds = map.getBounds();
  if (!bounds) return;

  // The position of the infowindow
  var position = this.latlng_;

  // The dimension of the infowindow
  var iwWidth = this.width_;
  var iwHeight = this.height_;

  // The offset position of the infowindow
  var iwOffsetX = this.offsetHorizontal_;
  var iwOffsetY = this.offsetVertical_;

  // Padding on the infowindow
  var padX = 40;
  var padY = 40;

  // The degrees per pixel
  var mapDiv = map.getDiv();
  var mapWidth = mapDiv.offsetWidth;
  var mapHeight = mapDiv.offsetHeight;
  var boundsSpan = bounds.toSpan();
  var longSpan = boundsSpan.lng();
  var latSpan = boundsSpan.lat();
  var degPixelX = longSpan / mapWidth;
  var degPixelY = latSpan / mapHeight;

  // The bounds of the map
  var mapWestLng = bounds.getSouthWest().lng();
  var mapEastLng = bounds.getNorthEast().lng();
  var mapNorthLat = bounds.getNorthEast().lat();
  var mapSouthLat = bounds.getSouthWest().lat();

  // The bounds of the infowindow
  var iwWestLng = position.lng() + (iwOffsetX - padX) * degPixelX;
  var iwEastLng = position.lng() + (iwOffsetX + iwWidth + padX) * degPixelX;
  var iwNorthLat = position.lat() - (iwOffsetY - padY) * degPixelY;
  var iwSouthLat = position.lat() - (iwOffsetY + iwHeight + padY) * degPixelY;

  // calculate center shift
  var shiftLng =
      (iwWestLng < mapWestLng ? mapWestLng - iwWestLng : 0) +
      (iwEastLng > mapEastLng ? mapEastLng - iwEastLng : 0);
  var shiftLat =
      (iwNorthLat > mapNorthLat ? mapNorthLat - iwNorthLat : 0) +
      (iwSouthLat < mapSouthLat ? mapSouthLat - iwSouthLat : 0);

  // The center of the map
  var center = map.getCenter();

  // The new map center
  var centerX = center.lng() - shiftLng;
  var centerY = center.lat() - shiftLat;

  // center the map to the new shifted center
  map.panTo(new google.maps.LatLng(centerY, centerX));

  // Remove the listener after panning is complete.
  if (this.boundsChangedListener_ != null) {
	  google.maps.event.removeListener(this.boundsChangedListener_);
  }
  this.boundsChangedListener_ = null;
};
GlassBubble.prototype.normalBackground = 'iVBORw0KGgoAAAANSUhEUgAAAWYAAAD3CAYAAAAua/5EAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAC55JREFUeNrs3U2LG/cdwPGZkdb22kmdBjsUkuyh9Ine+gJKDj33bmjBpxxS+kSh76AvoSWHppRAAin0VuitFF96zaWUHkKSOix4/RA7ZNfOrp46Y0vhv6O/ZkcjaTyKPx8Q+2i7bKVvfvrNaDZNmkkTAOqYbCKw6ZJ/TrQB8a3+2qRpmNPI++kZXwcQ6er3J2cF+qxpOAxyumSsAZ71IJc/N6kT6PSMKJ8K8vXr11/e29t749y5cz/KP3xuMpn4vwIgNuGmj7N5eHJy8o+bN2+++fbbb+9HAh2N86Iwl6OcXrt27XsvvfTSHy9eung1/wfPDYfDbDwe++kDRGRZlvT7/XE+wJ48PHp45/bt26+/9957/42EeVIV5nKUs9nf/9prr72ce/eFr7/wjV7WO//w0cMkD3NiYgZYPDHnYU4u7l5MRuPR8YP7D27t7+//5MaNG8XkPJtqx7E4Z5GJOdwlF1/v5f/A671+72oe4vOHR4fJYDAQZYAKRSOLVhbNLNpZNLRoadHUoL2x43envphEJubiL+jdu3fvh3n5LxwfHyej0chPHKCmoplFO4uGFi2ddXXa2OhJFf0F0/IszI9v4/H40ng0zorRPHXiBcBS8n4WU/Pjlk67Wt4vp+Eqox9ZZSRhlGffUxzomx5lBGAJxVojWP/2S2EeTdt76htiE3MWrjL8WAHWpmhqeNBvHDQ4evBv9rlyoAFYjyzS2VP6SXz5PD8xzx03BGCFiXlUmphnpT1V6jC9aVB0EzPAeifmsLFzo28suoteaALA+sIcu95QNMyxU+YsMADWJy3FeW5R3I9Mykl0YvZCP4DmJgsn5rkGL1plpInDfQCbnJoXdjZbVOwzPgdA8yhXfi4TX4BuRdsZFwAdI8wAHdOv+40Tp2UANLZMQ03MAB0jzADCDECV2jvmNPHbSwBMzAAm5sX8VmyA5pZpqIkZoGOEGUCYAahSe8fsIqAAJmYAE3MlJ2UANLdEQ03MAB0jzADCDIAwAwgzAE35DSYALVimoS77CdAxVhkAwgyAMANsERfKB2iBC+UDPAsTs8t+ArTDxAwgzABUcT1mgDa4HjPA9hJmAGEGQJgBhBmAplyPGaAFyzTUxAywrROzC+UDtMPEDCDMAFRxPWaAFrgeM8AWE2YAYQZAmAGEGQBhBhBmAIQZQJgBaJtfxgrQhiUa6nrMAK10uX5D60/M6fQGwEbZMQMIMwBV/AYTgG0Nc+J6zADNTTZw8E+WAVbo8hLfa8cM0DHCDCDMAAgzgDADIMwAwgyAMAMIMwDCDPCMq/+SbNfKAGhsmYaamAE6RpgBhBmAKn7nH4CJGYD1TMxOygBobomGmpgBOkaYAYQZgCq1d8zD0TBJU6dlADQx2cRvyR4MB8IM0KUwDwcmZoA2wmzHDNAxwgzQMfUv++lnBdDYMg3tb+avBaBpQ60yADrGtTIAujUw2zEDdKzLdswAXUuzVQZAx0ZmqwyAbnW5fpj9ZimAdjhdDkCYAaiyxI7ZlhmgqYmzMgA6V+barDIAOsYqA6CVgdkqA6BrZa7NKgOgY6wyAFoZmK0yALpW5k1MzAC00GWX/QToWpqtMgA6NjI7KwOgY4QZQJgBqOI8ZoAWOI8ZoHtl3sTEDEALXV5mYpZmgOZlrt9QB/8AOsbBP4A2BmYH/wA6V+ZNTMwAtNBlB/8A2imzg38AW6v+KsPEDLDCwLyBg39pmj6+AdCVidnPCqD5xLyJMDv4B7BKmR38A9haDv4BtDIwm5gBvvoTc7G5dr0MgKYjc/1vNTEDdIwwA3TMcpf9tMkAMDEDmJgXTcxOlwMwMQOYmCsnZj8sgE6F2ZE/gHZYZQBs68Ts4B+AiRnAxGxiBjAxAyDMAMIMwBKWuh4zAB0Ks4vkA7TDKgNgaydmp8sBmJgBTMyVI7MfFkCnwuzgH4CJGUCYTcwAT5+DfwDbOjEbmAE6FmarDAATM4Awm5gBnj4H/wC2dWI2MAN0LMxWGQAmZgBhNjEDPH0O/gFs68RsYAboWJitMgBMzADPJDtmgG2dmK0yADoWZl0GaIdVBsC2TsxWGQAdC7MuA7TDKgNgWyfmycTIDGBiBhBmAJ42qwwAEzMAwgywRbzABGBbw6zLAO2wygDY1onZKgOgY2HWZYB2WGUACDMAVbzyD6AlaZqamAG2kTADCDMAVeyYAVpixwywpYQZQJgBEGaALeLgH4CJGYA6YT5rHE79qABWdlZLJ3Un5kmxxrDKAGgu6OiZMc0itS7fksFgcCNN04fiDNAsykVDi5ZWtTYW5smCsXp87969v+Z/6e2i0eIMsFyUi3YWDS1aWjS1oreP9ZInO4/wlgW34uv9R48eHe/u7h7u7Ox8M//4XP4P7fhx8zTUfUlrgwcObGxSzt89ODo6eufg4ODf+fuj/Dac3kbTUI/DyTkW5CLGRXj707fnixgXt8uXL7985cqVn/b7/R/M4ryJBwpUuFDcJ9dxv5sG+Ti/feHHyib+Y5/fTwfD4fD9u3fvvvPZZ5/t5586md6K+91gGudBOdDlMKfTIPengT5XivPO9G3/6tWr38//8Sz4s8X/GJVmbcNx5P30xRdf/HGWZd/K37+0SpynD5yj8Xj8waeffvq34GnkJPbUEmo8m5vdX57ENU3Hd+7c+c80vifTAIdRPilNz5MwzElkYu4FE/NOEOUvwxx8X3kdAusM86lV2/nz5y/u7e29sUqcp08vj0aj0Qc3b9588/j4+GESPxAjzCx11wpuo+AWhnlQen8YfN+4KsxZEOZeEOJZlMNVR/hnhJl1hzkW5yyP86U8zj/L4/ztZeM8jfIX+dvbH3/88e/yKB+Fk0opysJMkzCPg1u4qjgJYhxOy6PSn5mU7/izwPaC8Ib75n4pyuWJGda9wigfA3l8/5zG+efLxDmMcu739+/f/6T8gIgE2uRMkziHU/AwOb1Pnr0dB2E+dd9LKx4AWTA190u3WJSzBQ8uWGViDgeG8BldMTk/n8f5F3XiPN0pn+Tfc+vg4KCI8v+mD4TwAVQOsyBTN8Yz44o4h7fZtFweDObCnEQeBL3SLRblLLFjZv0Tc+w0ztn97st124ULF55/9dVXf1kV5+A80kcPHjz4w61bt95PTu/2ynG2a2aVaTn8D3w5zovuc+G5zZNFTxvTYKWRld72SvFOhZkNxzkr3Q9PPYML4vydWJzzMBdPGx8dHh7+aX9//1+R6SU2OSemZlYI86QU3fD+Fb6NvgIwPePBkAQPhizylNJBPzYd5iyZX6/NVmw7weT8tTzOvyrHefJkXP48j/Jb0yjPDsQMSk8rR5GnlaZlVgl07PjFOIhyefWRxMKcJPNHwmdxzmpMyeW3sGqcFx2UDqO8E0zORZx/PYvz9GDf5ycnJ3//6KOP/hJEuHxi/zBZvGeGujFOIs+2YtPzuBTluWdnacWkkkTimy1YeQgy656Wk8jUHB7rCG+zc+yzYq2xt7f3m/z97xZ3/OFw+M8PP/zwzwuiXJ6Yw6PjsQcdLBPoWJzLX4tFPRrTtGKCXvR+Is5sKNDhMFA+EB2ewvnlNL27u/vcK6+88tvRaPRJHuW3pnf4cKccm5jnjowLMg2jnCyYhKvOk58kNUOanjFJCzFtrDKSZH7PHF1lJPMHp2dPFxedTxpGeSTMtLDeSJIa58inNR8gy3wM65yYy3HuReIcC3N4xw9PVTrrjIxFDyBoOj3X+XjlqAoxbYc5nJ5j59aXz7OPhTmcjgfJ/Pmkzl+mzVCLLF+pOIfn14cveCpfuyUW5nByHifzB/xEmU7d8WHb4lx+BWq44ijfr8Mwx07wF2WEGdYY53D3nCTzL3qKnUNaddEiUUaYYcU4l688l0bCHHslViLKCDNsLs6xSTkW5kU3UUaYYU1xTpL4BbTK9+uql8uKMsIMa77f1n3RU52T/UGYYY333UUfV53YL8oIM3TkPizIAE8p2AYPttL/BRgAjGNNK/i1SZMAAAAASUVORK5CYII=';

GlassBubble.prototype.smallBackground = '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';

GlassBubble.prototype.tinyBackground = 'iVBORw0KGgoAAAANSUhEUgAAAIYAAAA4CAYAAAA4uYCUAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAB0hJREFUeNrsnO9rI0UYx2d2dtO0aa93/UHv3f0A4fCNb0QQPXxX8B8QfHHnjzt8d+A/4HtBhMJxL+61ioIggniggiCirw5B9NB3bWpb24OSJk02abK74zO9SZxMnslue7lkdzsDw2x+7Wbn+eT7fGeyO5ScrlBiS5YKfxYBpif8nIUmncHnJ3l/0gBTQ2tByAYo3NAaIaEJgKDItumxLekDwvSYG+BBg4kpQw+AO3fuvLS0tHSTMfY853wZqg1Digulx2GrRFH0V6VS+XRtbe1nDQqjksSlC0duO7dv3761vLz8fqlUKsABXYDCgQPa3k85GFBFkELf94/29/c/u3///ofwOEIA6YPDBIYKBVtdXX1xfn7+3rVr1xY6nQ5rt9skDMMne7GqkWowQN1JoVAg09PTZHd3t1Eulz948ODB1xKOLhCRDoaDpJI+KMR2o9F4b2Fh4Vyr1WLNZpMEQXAMhIUi5WYD4iNiJWJ2eHhIPM8rHBwcvCHj62hWoS9juAa16EEh2mq1elXsVCiFTR/ZBASUXiiIBz/yq4uLi3OQVg7ly6GWObgKBuYtHAkHgx2XxPMCCqsS2Szd2Lmu6xSLxfPwlK+AEOmjEnfIqESF49hTSJdrS/Yh6cZWNZ5UhcMx+Au1urYrc5damGIVMJ+BBl19U/fDNoXkSzG6YIQyvpGeNVyDK3U09bBg5KuoGSHSYs9NHoNqcDALRi49BkVSCY8zn7oBPXa11nzmY+iqzWMQzGM4hhGJTpMt+YIDNZzDhqsmI2pTSb4KNdSez3CTfsCCkVswyGkUo1dqhzXrMfJhPI1ZAQMjNuIRKIbF4uyUxIrBBWlWMSwYg4oBw1WrGRaMwdzErWDkYag6ejDsBFc+yOAWDFvGkErs9Rh5EAt+4lQS934aWTByAQZ5Mh0eaz3chDv0QTG44ziWjIyDAXGM6vV6Lc6Pugg5AxX8xVaz2bxYhGJVI7tQdKAAGJtHUMjgnWgnUozjD9dqtS8AiOfoBeq5rsssHNmDQgwe/IbfgvI96b+nBL3hyEUkRb8Jhe/s7DwqFApfQiq5IVTDgwJwOFnpmC7I8s6s0eVrpE0hFBEIRQAi0fJ9/9uNjY0fDED09xkZvAjYVaoHdQpqQdSVlZUXZmdnXwdArkIHn8sSGKIC3MWZmZlZ+P6jyNUB/PqaUpbTDEYd1GKj0Wh8t7u7+xCeassqvndH1kDWqCsI2KV8OhgqHJ5sxWtMqbF/446bBa0lAAO7dOnSm3Nzcy9PFYunhkPKcnjUavn7+/ufg5r+SuKXGRgbB0oNZZC7Qe9CcCTB6Mg2UGovUzCDephuJSBI8LlCWhorfxJPHoFX+gMU44JD6QpISKE3tk9YRZ4WtX101Dg4OPhqe3v7J+R4oRKUcVf12KEMdqgFP5RQhLpKqECzGCgIGbz8T92BulP1i4UThgE9vqCjWq3+WSqVzoNiXIT0UpBXISWqAopOu10HWf6xXC5/o51vOMHzx4DAoNCfV/uqz3eYrvNkSrpQ00q37d3XSvALS9OSTrDzogCFd/ny5RvT09OvwCgrUVoRUARBUIdh+y9g4D6Bxx1NstFb/cacRgiSSiINio7SYiCjYAzct2qARAeDpAwM7Hyoek4Agwtw3IRB1quwPRQOaTYb7Xb79/X19XuwrXcqRySZTxAMgqhJiKQSFAodDEL6rwxnBkAcDYo0Gk+TWvSdi1SOt6ampoxwSG/RgCHf35ubm3dhEFJXOhjL09GETSjXphwizYiq25ECNppKiMFfYClDBSJtYFADHOp5qKon4CgAHG8LOOBxHxzSdDZBITa2trY+8n2/qhm3QPvVpREMDJDQAHPveydaUUcbmei/RCclKYQalENPja5ehXJcuXLlHc/zrgs4xJyHnJdoQfsPjP/XwLT+q0DRMYARkZhFz8aYUqIhgEQkZkWdxGtwITDQFHoL7PvrqQSbp2ESjnfBjF4HGAQcYry/9/jx448rlUpZUYm2BofqM0KCL3o2Sa9hgoOQhGtwmeCgBg+SBTAIkgKxEVYfHIyx12C7BkDc3dvbeyQ7sqO5epNikAmZzzgwuAEIdGIur+t8mlRD9RceklYEHAw8x61Wq/VwZ2fnN8TNY3MCujyTFIBByAjX+RwGiEkd0vxXq4PM4DJdKbS5GUebyAuHTBQFCBRpWaTsqVYGdhPsmCI7zMJa4pT8v/BYpEDRPQ9Ptq5ssck6bB5ATyHhhOcvkprcE60l7o7ggE/7/nENXdXAMc25R6T/D0H9fyB1vqKDAMNTYDpHGhN3XAeaUGdQZdtBZJ5rwVf/LCTIHEAYoxQ8I30TWxg5G4VqoJhcOx8CQ4BMEOUOiCwYx1GfJzXMyTBiXigGgyUaAgW3YOQDDkLMyydzLZ1wkuBaSQtG9uGIW1WGDAEg11A8jfnMauEJjOqwz3KSnsv4rGI846Gs3g/UABMfMnFkwcjxuSdRDHIWoDjrYJymD87MCnX/CTAAdUzgb99Vc6MAAAAASUVORK5CYII=';
