/*!
 * Name: application.index.js
 **/
(function($){
	function addFavCallback(event, id, data) {
		var dataWrapped = '<div>'+data.html+'</div>';
		$($(dataWrapped).find('#toc_ret').html()).insertAfter('#toc_title_outer');
		$($(dataWrapped).find('#restaurant_list_ret').html()).prependTo('ul.restaurant_list');
		//bind delete action
		$('#toc .new_added a.remove_restaurant').deleteFromIndex(id);
		if ($('ul#restaurant_list').html()) {
			$('ul#restaurant_list li.new_added .dish').unbind().isDishForCart($('#cart_unique'));
		}

		var deleteCtl = $('ul.restaurant_list').find('a.fav-remove').each(function(){
			deleteId = $(this).attr('id').replace('rm_id_','');
			$('ul.restaurant_list').find('a#rm_id_'+deleteId).unbind().deleteFromIndex(deleteId);
		});

		var addCtl = $('ul.restaurant_list').find('a.fav-add').each(function(){
			addId = $(this).attr('id').replace('add_id_','');
			$('ul.restaurant_list').find('a#add_id_'+addId).unbind().addToIndex(addId);
		});

		$('#cart_unique').data('class').refreshCountOnDishes();
	}
	function removeFavCallback(event, id) {
		//self.firstParent('li').hide('fast');	
		$('ul#toc').find('li.'+'restaurant'+id).remove();
		$('.restaurant_list').find('.restaurant'+id).remove();
		//adjust position of customize
		if($('#toc .restaurant').size()==0){
			$('#toc').addClass("empty");
		}
	}
	$.fn.isAskAnswerContent = function() {
		$(this).focus(function() {
			$('#email_input').slideDown(70);
		});
	};
	$.fn.isUpdateRequestForm = function() {
		function toggleForm() {
			var form = $(this);
			var	updateRequestLink = form.firstParent('.actions').find('a.request_update').first();
			function showForm() {
				form.trigger('hideForm');
				if(updateRequestLink.hasClass('open')) {
					return;
				}
				updateRequestLink.addClass('open')
				form.show();
				updateRequestLink.one('mouseleave', mouseLeaveBodyClick);
				updateRequestLink.one('click', hideForm);
				return false;
			}
			function hideForm() {
				updateRequestLink.removeClass('open')
				updateRequestLink.one('click', showForm);
				form.hide();
			}
			function mouseLeaveBodyClick() {
				$('html').one('click', hideForm);
				form.bind('mouseenter', function() {
					$('html').unbind()
				});
				form.bind('mouseleave', function() {
					$('html').unbind()
					$('html').one('click', hideForm);
				});
			}
			function init() {
				if(form.size()==0) {
					return;
				}
				updateRequestLink.one('click', showForm);
				form.one('hideForm', hideForm);
			}
			init();
		}
		$(this).each(toggleForm);

	};
	$(function() {
		$('#toc .restaurant_name').each(function() {
			var self = $(this);
			var id = self.find('.jump_to_restaurant').attr('href').replace('#restaurant', '');
			self.find('.remove_restaurant').deleteFromIndex(id);
		});
		$('#toc .restaurant_name').hover(
			function(){
				//clearTimeout($(this).data('timeout'));
				$(this).addClass('hover');
			},
			function() {
				var self = $(this);
				//var t = setTimeout(function() {
					self.removeClass('hover');
				//}, 100);
				//self.data('timeout',t);
			}
		);
		$('body').bind('add_fav', addFavCallback);
		$('body').bind('remove_fav', removeFavCallback);
		if ($.fn.localScroll) {
			$('#hero_actions').localScroll({duration:300});
		}
//		$('#ask_answer_content').isAskAnswerContent();
		$('.request_update_form').isUpdateRequestForm();
	});
})(jQuery);
