(function($){
	$(function() {
		$.resizeMap = function() {
			var windowHeight = $(window).height();
			var bottomSpanHeight = 20;
			var mapHeight = windowHeight - $('#header-outer').outerHeight(true) - $('#notifications').outerHeight(true) - bottomSpanHeight - $('#map_toolbar').outerHeight(true);
			if ($('body').hasClass('ie6') || $('body').hasClass('ie7')) {
				mapHeight += 18;
			}
			$('#map_canvas_outer').height(mapHeight);
			$('#map_canvas_left').height(mapHeight);
			$('#map_canvas').height(mapHeight - $('#map_controls').outerHeight(true) + 1);
			var restaurantHeight = mapHeight - ($('#restaurant').innerHeight(true) - $('#restaurant').height());
			$('#restaurant').height(restaurantHeight);
			$('#restaurant_search_result').css('min-height',restaurantHeight - $('#restaurant h3').outerHeight(true));
			try {
				$('#map_canvas').data('class').boundsChanged();
			} catch(e) {}
			try {
				$('#area_selector').data('class').onMapResize();
			} catch(e){}
		}
		if ($('body').attr('id')=='map_iframe') {
			$(document).resize($.resizeMap);
		} else {
			$(window).resize($.resizeMap);
		}
		$.resizeMap();
	});
})(jQuery);
