/*!
 * Name: hero_restaurant.js
 **/
(function($) {
	$.fn.isHeroRestaurant = function() {
		function infoButtonClick() {
			var infoButton = $(this);
			if (heroRestaurant.hasClass('expanded')) {
				if ($('body.ie6,body.ie7').size() > 0) {
					$('#hero_intro').css({'height':36});
				} else {
					$('#hero_intro').animate({'height':36});
				}
				heroRestaurant.removeClass('expanded');
			} else {
				if ($('body.ie6,body.ie7').size() > 0) {
					$('#hero_intro').css({'height':200});
				} else {
					$('#hero_intro').animate({'height':200});
				}
				heroRestaurant.addClass('expanded');
			}
			$.get('/settings/log', {'content':'clicked hero info button ' + heroRestaurant.data('id')});
		}
		function heroNameMouseOver() {
			if (heroName.hasClass('fav_added')) {
				heroName.attr('href', heroName.data('view'));
				heroName.html('已经加到首页，看菜单');
			} else {
				heroName.attr('href', heroName.data('add'));
				heroName.html('把餐厅加到首页');
			}
		}
		function heroNameMouseOut() {
			heroName.html('餐厅: ' + heroName.data('name'));
		}

		function addFavCallback(event, restaurantId) {
			if (heroRestaurant.data('id') == restaurantId) {
				var heroActions = $('#hero_actions');
				heroActions.addClass('fav_added');
				heroActions.removeClass('loading');	
			}
		}

		function removeFavCallback(event, restaurantId) {
			if (heroRestaurant.data('id') == restaurantId) {
				var heroActions = $('#hero_actions');
				heroActions.removeClass('fav_added');
				heroActions.removeClass('loading');	
			}
		}

		function ajaxStart() {
			$('#hero_actions').addClass('loading');	
			$.get('/settings/log', {'content':'added fav from hero ' + heroRestaurant.data('id')});
		}

		// Init

		var heroRestaurant = $(this);
		$('#hero_info_btn').click(infoButtonClick);
		if (!$('body').hasClass('ie6')) { // No JS binding for IE6
			$('#hero_add_fav').click(ajaxStart).addToIndex(heroRestaurant.data('id'));
			$('body').bind('add_fav', addFavCallback);
		}
		$('#hero_view_menu').click(function(){
			$.get('/settings/log', {'content':'view hero menu ' + heroRestaurant.data('id')});
		});
		$('body').bind('remove_fav', removeFavCallback);
	};
	$(function(){
		$('#hero_restaurant').isHeroRestaurant();
	});
})(jQuery);
