/*!
 * Name: restaurants.show.js
 **/
(function($){
	$.fn.isAskAnswerContent = function() {
		var self = $(this);
		self.focus(function() {
			$('#email_input').slideDown(70);
		});
	};
	$.fn.isUpdateRequestForm = function() {
		function toggleForm() {
			var form = $(this);
			var	updateRequestLink = form.firstParent('.actions').find('a.request_update').first();
			function showForm() {
				form.trigger('hideForm');
				if(updateRequestLink.hasClass('open')) {
					return;
				}
				updateRequestLink.addClass('open')
				form.show();
				updateRequestLink.one('mouseleave', mouseLeaveBodyClick);
				updateRequestLink.one('click', hideForm);
				return false;
			}
			function hideForm() {
				updateRequestLink.removeClass('open')
				updateRequestLink.one('click', showForm);
				form.hide();
			}
			function mouseLeaveBodyClick() {
				$('html').one('click', hideForm);
				form.bind('mouseenter', function() {
					$('html').unbind()
				});
				form.bind('mouseleave', function() {
					$('html').unbind()
					$('html').one('click', hideForm);
				});
			}
			function init() {
				if(form.size()==0) {
					return;
				}
				updateRequestLink.one('click', showForm);
				form.one('hideForm', hideForm);
			}
			init();
		}
		$(this).each(toggleForm);

	};
	$(function(){
		if($('ul.restaurant_list').find('a').size()!=0){
			var deleteCtl = $('ul.restaurant_list').find('a.fav-remove').each(function(){
				deleteId = $(this).attr('id').replace('rm_id_','');
				$('ul.restaurant_list').find('a#rm_id_'+deleteId).unbind().deleteFromIndex(deleteId);
			});

			var addCtl = $('ul.restaurant_list').find('a.fav-add').each(function(){
				addId = $(this).attr('id').replace('add_id_','');
				$('ul.restaurant_list').find('a#add_id_'+addId).unbind().addToIndex(addId);
			});
		}
		$('#ask_answer_content').isAskAnswerContent();
		$('.request_update_form').isUpdateRequestForm();
//		$.preloadImage('/images/dash_' + (new Date()).getTime() + '.gif');
	}); 
})(jQuery);
