/*!
 * Name: restaurants.show.map.js
 **/
(function($){
	$.googleMapsReady(function(){
		$('#map_box').show();
		$.fn.isRestaurantMap = function() {
			if (this.size()==0) {
				$('#map_box').remove();
				return;
			}
			var _root = this;
			var defaultLat = $('#center_latitude').val() || 0;
			var defaultLng = $('#center_longitude').val() || 0;
			var defaultRadius = $('#restaurant_radius').val() || 500;
			if (!defaultLat || !defaultLng) {
				$('#map_box').hide();
				return;
			}
			var _map = this.googleMap(defaultLat, defaultLng);
			var _rangeCircle;
			var _me;
			var _marker;
			var _init = function() {
				if (!navigator.geolocation) {
					$('#map_find_me').hide();
				}
				_class.markRestaurant(defaultLat, defaultLng);
				_class.setCurrentMarkerRange(parseInt(defaultRadius));
				_root.data('class',_class);
				$('#map_zoom_in').click(function(){
					_class.zoomIn();	
				});
				$('#map_zoom_out').click(function(){
					_class.zoomOut();	
				});
				//这个地方可以添加您需要的代码。_map对象就是该地图对象
				
				
				
				
			};
			var _class = {
				getMap: function() {
					return _map;
				},
				findMe: function() {
					if (navigator.geolocation) {
						browserSupportFlag = true;
						navigator.geolocation.getCurrentPosition(
							function(position){
								$('#map_find_me').removeClass('loading');//success callback
								var latLng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
								_map.setCenter(latLng);
								if (!_me) {
									_me = new google.maps.Marker({
										position: latLng,
										map: _map,
										icon: 'images/map-pinMd-blue' + ($('body.windows').size() > 0 ? '-win' : '') + '.png',
										shadow:'images/map-pinMd-shadow.png'
									});
									_class.change();//after findMe() pins around "me" don't display
								} else {
									_me.setPosition(latLng);
									_class.change();//after findMe() pins around "me" don't display
								}
							},
							function(){
								$('#map_find_me').removeClass('loading');//error callback
							},
							{timeout:7000}
						);
					}
				},
				markRestaurant: function(lat, lng) {
					var latLng = new google.maps.LatLng(lat,lng);
					_marker = new google.maps.Marker({
						position: latLng,
						map:_map,
						icon:'images/map-pinMd-red' + ($('body.windows').size() > 0 ? '-win' : '') + '.png',
						shadow:'images/map-pinMd-shadow.png'
					});
				},
				setCurrentMarkerRange: function(radius) {
					if (radius == 0) {
						return;
					}
					if (!_rangeCircle) {
						_rangeCircle = new google.maps.Circle({
							map: _map,
							radius:radius,
							fillColor:'#b2bed4',
							fillOpacity:.5,
							strokeColor:'#2987ff',
							strokeWeight:1.5,
							strokeOpacity:.3
						});
					} else {
						_rangeCircle.setRadius(radius);
						_rangeCircle.setMap(_map);
					}
					_rangeCircle.bindTo('center', _marker, 'position');
				}
			}
			_init();
			return _class;
		};
		function initMap() {
			var mapCanvas = $('#map_canvas').isRestaurantMap();
		}
		function init() {
			initMap();
			//bind find me btn
			$('#map_find_me').click(function(){
				var self = $(this);
				if(!self.hasClass('loading')){
					findMe();	
					self.addClass('loading');
				}
			});
		}
		if ($.browser.msie && parseInt($.browser.version) < 9) {
			$(window).load(init);
		} else {
			$(init);
		}
	});	
})(jQuery);
function findMe() {
	var _map = $('#map_canvas').data('class').findMe();
}
