<?php
require_once 'inc/functions.php';

if(empty($_SESSION['session_customMobileVerified'])) {
	set_info_notification('请先验证您的手机。');
	header("Location: orders_verifymobile.php");
	exit;
}

$myActiveOrders = get_my_active_orders();
if(empty($_SESSION['session_hasActiveOrder'])) {
	header('Location: index.php');
	exit;
}
include 'header_account.php';
?>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.order_bubble.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/common.steps_nav.css"/>	
<link rel="stylesheet" type="text/css" media="screen" href="css/order.progress.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/jquery.switch.v2.css"/>
<script src="js/orders.create.js" type="text/javascript" charset="utf-8"></script>
<script src="js/timer.js" type="text/javascript" charset="utf-8"></script>
<script src="js/orders.my_active_orders.js" type="text/javascript" charset="utf-8"></script>
<script src="js/orders.refresh.js" type="text/javascript" charset="utf-8"></script>
<script src="js/jquery.switch.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
document.title = "<?php echo $_SESSION['session_Setting_SITE_NAME']; ?> / 当前订单";
$(function(){
	<?php foreach($myActiveOrders as $order) {?>
	$.isTimer("#timer_<?php echo $order['ID']; ?>");
	<?php } ?>
});
</script>
<ol style="display:none;" id="order_progress_prototype">
	<li>
		<div class="time"><span></span></div>
		<div class="activity"></div>
	</li>
</ol>

<div class="columns my_active_orders">
<div class="inner_columns">
<div class="left">
	<div id="content">
		<div id="settings_nav" class="tab_nav">
			<ul>
				<li>
					<a href="custom_account.php">帐号密码</a>
				</li>
				<li>
					<a href="custom_mobile.php">手机号码</a>
				</li>
				<li>
					<a href="custom_addresses.php">常用地址</a>
				</li>
				<li>
					<a href="custom_support.php">我的答疑</a>
				</li>
				<li>
					<a href="custom_orders_list.php">订单历史</a>
				</li>
				<li class="current">
					<a href="orders_myactive.php">当前订单</a>
				</li>
			</ul>
		</div>
		<a id="refresh_link" style="display:none;" href="orders_myactive_refresh.php" data='{"delay":10}'>Refresh</a>
		<div class="my_orders">
		<?php foreach($myActiveOrders as $order) { ?>
			<div class="order_bubble_arrow"></div>
			<div class = "order_bubble" id="order_<?php echo $order['ID']; ?>">
				<div class="meta vcard">
					<h2 class="name"><span><?php echo $order['Restaurant']; ?></span></h2>
					<span class="comment order_timer" id="timer_<?php echo $order['ID']; ?>"><?php echo $order['CreateTime']; ?></span>
					<span class="tel"><?php echo $order['Telephone']; ?></span>
				</div>
				<table class="cart_cols">
					<tbody><tr>
						<td class="dish_col">
							<h3 class="your_dish_title">您的餐饮：</h3>
							<ul class="dish_list">
								<?php foreach($order['dishes'] as $dish) { ?>
								<li class="dish">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name"><?php echo $dish['Name']; ?></span>
											<span class="dish_count  badge_for_<?php echo $dish['Count']<10 ? 1 : ($dish['Count']<100 ? 2 : 3) ?>">
												<?php echo $dish['Count']; ?>
											</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $dish['Price']; ?></span>
										</div>
									</div>
								</li>
								<?php } ?>
								<li class="dish total">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name">合计：</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $order['total']; ?></span>
										</div>
									</div>
								</li>
							</ul>
						</td>
						<td class="address_col">
							<table>
								<tbody><tr>
									<th>
										<label>您的手机：</label>
									</th>
									<td>
										<?php echo $order['Mobile']; ?>
									</td>
								</tr>
								<tr>
									<th class="addresses_old_title">
										<label>详细地址：</label>
									</th>
									<td>
										<?php echo $order['Address']; ?>
									</td>
								</tr>
								<tr>
									<th class="say_sth">
										<label>餐饮要求：</label>
									</th>
									<td>
										<?php echo $order['Notes']; ?>
									</td>
								</tr>
							</tbody></table>
						</td><!--address_col-->
					</tr></tbody>
				</table><!--cart_cols-->
				<div class="progress_section">
					<ol class="order_progress">
					</ol>
				</div>
				<div class="auto_refresh_note">* 订单进度会自动更新</div>
				<!--			
				<div class="mobile_verify <?php echo ($_SESSION['session_Order'.$order['ID'].'Status']=='等待手机验证')? "mobile_not_verified" : "" ?>" id="mobile_verify_<?php echo $order['ID']; ?>">
					<span>订餐确认验证码：</span>
					<input type="text" value="" name="activationCode" class="text" orderid="<?php echo $order['ID']; ?>">
					<input class="btn start_mobile_verify" type="button" value="确认订单" />
					<input class="btn resend_mobie_verify_code" type="button" value="重发验证码" />
				</div>
				-->
				<div class="order_actions new_order">
					<a class="flat_btn action_verify_mobile" href="/orders/verifymobile?mobileAccountId=7090"><b></b>完成手机验证</a>
					<a class="flat_btn action_payment" href="/orders/choosepaymenttype?userOrderId=39196"><b></b>选择如何支付</a>
					<a class="flat_btn action_urge" href="orders_urge.php?orderId=<?php echo $order['ID']; ?>"><b></b>请帮我催一下</a>
					<a class="flat_btn icon_btn action_arrived" href="orders_arrive.php?orderId=<?php echo $order['ID']; ?>"><b></b>已收到餐</a>
					<a class="flat_btn icon_btn action_cancel" href="orders_cancel.php?orderId=<?php echo $order['ID']; ?>"><b></b>取消订单</a>
					<a class="flat_btn icon_btn action_delete" href="orders_cancel.php?orderId=<?php echo $order['ID']; ?>"><b></b>删除</a>
				</div>
			</div> <!--order_bubble-->
		<?php } ?>
		
			<div id="accept_sms_call">
				<table>
					<thead>
						<tr>
							<th>我接受短信</th>
							<th>我接受电话</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								<div class="z_switch mobile_account_sms_switch on">
									<input class="switch_indicator" type="checkbox" checked="checked"/>
									<a class="switch_on" href="/settings/acceptsms?mobileAccountId=7090">ON</a><a class="switch_off" href="/settings/denysms?mobileAccountId=7090">OFF</a>
								</div>
							</td>
							<td>
								<div class="z_switch mobile_account_call_switch on">
									<input class="switch_indicator" type="checkbox" checked="checked"/>
									<a class="switch_on" href="/settings/acceptcall?mobileAccountId=7090">ON</a><a class="switch_off" href="/settings/denycall?mobileAccountId=7090">OFF</a>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<div class="hint">
					<p>*&nbsp; 如果您不接受短信和电话，当您的订单无法完成时，我们只能通过自动更新的订单进度通知您。</p>
					<p>** 餐厅送餐人员仍有可能通过电话联系您，以便为您送餐。</p>
				</div>
			</div>
		</div><!--cart-->
	</div><!--content-->
</div><!--left-->
<div class="right">
	<div id="side">
		<div class="faq">
			<div class="one_item first">
				<div class="q">
					<span>Q：我的餐饮多长时间能送到？</span>
				</div>
				<div class="a">
					<span>A：平均送餐时间大概在<span>40</span>分钟左右，非常快和非常慢的餐厅我们都会特别注明。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>Q：<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责送餐吗？</span>
				</div>
				<div class="a">
					<span>A：餐品均由餐厅配送。<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责为您收集附近尽可能多和准确的外卖菜单。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：我一直没收到餐饮怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们每20分钟会帮你联系餐厅催餐，您也可以点击“请帮我催一下”，我们会帮您催餐并告知您催餐结果。
					</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：如果我遇到问题怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们建议您通过我的答疑提出问题，最了解情况的人员会为您解答。您也可以拨打 4006-166-555 转 0 寻求客服帮助（客服电话的工作时间是周一至周五10:00-19:00）<div style="margin-top:6px;"><a href="/support" class="btn" target="_blank">前往我的答疑</a></div>
					</span>
				</div>
			</div>
		</div>
		<p style="margin-top:1.2em">(注：暂时不提供多餐厅同订单服务，请您谅解。)</p>
	</div>
</div>
</div>
</div>
<?php include 'footer.php' ?>