<!--#Include File="Include.asp"--><%
'==========================================
'文 件 名：Admin/Question.asp
'文件用途：试题管理
'版权所有：方卡在线 http://www.fangka.net/
'==========================================

Call CheckAdminType("0,2",Admin_Type)

Dim Question_Title,Question_Answer,Question_Content,Question_Category,Question_Type,TempAnswer

Types=Clng(Request.QueryString("Type"))

Select Case Types
	Case 1
		Call QuestionList() '试题列表
	Case 2
		Call QuestionAddForm() '添加试题表单
	Case 3
		Call QuestionAddDo() '执行添加试题
	Case 4
		Call QuestionEditForm() '修改试题表单
	Case 5
		Call QuestionEditDo() '执行修改试题
	Case 6
		Call QuestionDelDo() '执行删除试题
	Case 7
		Call QuestionListDelDo() '执行批量删除试题
	Case 8
		Call ImportForm() '导入试题表单
	Case 9
		Call ImportTestDo() '导入试题测试
	Case 10
		Call ImportDo() '导入试题执行
	Case 11
		Call QuestionCopy() '复制试题
	Case 12
		Call QuestionMove() '移动试题
	Case 13
		Call ShowQuestion() '预览试题
	Case Else
		Call FKFun.ShowErr("未发现功能项！",1)
End Select

'==========================================
'函 数 名：QuestionList()
'作    用：试题列表
'==========================================
Sub QuestionList()
	Session("NowPage")=FkFun.GetNowUrl()
	Question_Type=Request.QueryString("QuestionType")
	If Question_Type<>"" Then
		Question_Type=Clng(Question_Type)
	Else
		Question_Type=1000
	End If
	Question_Category=Request.QueryString("QuestionCategory")
	If Question_Category<>"" Then
		Question_Category=Clng(Question_Category)
	Else
		Question_Category=0
	End If
	Question_Title=FkFun.HTMLEncode(Trim(Request.QueryString("QuestionTitle")))
	PageNow=Request.QueryString("Page")
	If PageNow<>"" Then
		PageNow=Clng(PageNow)
	Else
		PageNow=1
	End If
%>
		<div id="rightNav">
			<ul>
				<li><a href="Question.asp?Type=2" target="dialog" width="700">添加试题</a></li>
				<li><a href="Question.asp?Type=8" target="dialog" width="700">导入试题</a></li>
			</ul>
		</div>
		<div id="searchLine" class="font_bold">
			试题管理&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			名称：
			<input type="text" name="QuestionTitle" id="QuestionTitle" class="input" size="20" value="<%=Question_Title%>">
			类型：
			<select name="QuestionType" class="input" id="QuestionType">
			  <option value="1000"<%=FkFun.BeSelect(Question_Type,1000)%>>所有类型</option>
			  <option value="0"<%=FkFun.BeSelect(Question_Type,0)%>>单选题</option>
			  <option value="1"<%=FkFun.BeSelect(Question_Type,1)%>>多选题</option>
			  <option value="2"<%=FkFun.BeSelect(Question_Type,2)%>>简答题</option>
			</select>
			试题库：
			<select name="QuestionCategory" class="input" id="QuestionCategory">
			  <option value="0"<%=FkFun.BeSelect(Question_Category,0)%>>试题库</option>
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Asc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
				<option value="<%=Rs("QuestionCategory_Id")%>"<%=FkFun.BeSelect(Question_Category,Rs("QuestionCategory_Id"))%>><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
			i=i+1
		Wend
	End If
	Rs.Close
%>
			</select>
			<input type="hidden" name="Type" value="1" />
			&nbsp;<input type="button" class="button" onclick="ajax_get('mainRight','Question.asp?Type=1&QuestionTitle='+escape($('#QuestionTitle').val())+'&QuestionType='+$('#QuestionType').val()+'&QuestionCategory='+$('#QuestionCategory').val());" value="查 询" />&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" value="导 出" onClick="window.open('Output.asp?Type=2&Question_Title=<%=Server.URLEncode(Question_Title)%>&Question_Type=<%=Question_Type%>&Question_Category=<%=Question_Category%>')" class="button">
		</div>
		<form name="DelQuestion" id="DelQuestion" method="post" target="ajax" action="Question.asp?Type=7" showStr="试题批量删除成功！" refreshUrl="<%=Session("NowPage")%>" confirmStr="确定要删除选中试题吗？此操作无法恢复！">
		<table width="100%" bordercolor="#CCCCCC" border="1" cellspacing="0" cellpadding="0">
			<tr>
				<th align="center">序号</th>
				<th align="center">删</th>
				<th align="center">题干</th>
				<th align="center">答案</th>
				<th align="center">类型</th>
				<th align="center">试题库</th>
				<th align="center">操作</th>
			</tr>
<%
	Sqlstr="Select Question_Id,Question_Title,Question_Answer,Question_Type,QuestionCategory_Name From [Questions] Where 1=1"
	If Question_Title<>"" Then
		Sqlstr=Sqlstr&" And Question_Title Like '%%"&Question_Title&"%%'"
	End If
	If Question_Type<1000 Then
		Sqlstr=Sqlstr&" And Question_Type=" & Question_Type
	End If
	If Question_Category>0 Then
		Sqlstr=Sqlstr&" And Question_Category=" & Question_Category
	End If
	Sqlstr=Sqlstr&" Order By Question_Id Desc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		i=1+(PageNow-1)*PageSizes
		Rs.PageSize=PageSizes
		If PageNow>Rs.PageCount Or PageNow<=0 Then
			PageNow=1
		End If
		PageCounts=Rs.PageCount
		Rs.AbsolutePage=PageNow
		PageRecordCount=Rs.RecordCount
		j=1
		While (Not Rs.Eof) And j<PageSizes+1
%>
			<tr>
				<td height="20" align="center"><%=i%></td>
				<td align="center"><input type="checkbox" name="QuestionId" class="input" value="<%=Rs("Question_Id")%>" id="QuestionId<%=Rs("Question_Id")%>" /></td>
				<td align="left">&nbsp;&nbsp;<a href="Question.asp?Type=13&Id=<%=Rs("Question_Id")%>" target="dialog" width="700"><%=FKFun.GetStr(Rs("Question_Title"),40)%></a></td>
				<td align="center"><%=Rs("Question_Answer")%></td>
				<td align="center"><%=FkFun.GetQuestionTypeName(Rs("Question_Type"))%></td>
				<td align="center"><%=Rs("QuestionCategory_Name")%></td>
				<td align="center"><a href="Question.asp?Type=4&Id=<%=Rs("Question_Id")%>" target="dialog" width="700">修改</a> <a href="Question.asp?Type=6&Id=<%=Rs("Question_Id")%>" target="delete" confirmStr="您确认要删除“<%=Rs("Question_Title")%>”？此操作不可逆！" refreshUrl="Question.asp?Type=1" showStr="试题删除成功！">删除</a></td>
			</tr>
<%
			Rs.MoveNext
			i=i+1
			j=j+1
		Wend
	Else
%>
			<tr>
				<td height="25" colspan="7" align="center">暂无记录</td>
			</tr>
<%
	End If
	Rs.Close
%>
			<tr>
				<td height="30" colspan="7">
					&nbsp;&nbsp;
					<input name="chkall" type="checkbox" id="chkall" class="input" value="" onClick="CheckAll(this.form)"> 全选
					<input type="submit" value="删 除" class="button" name="Enter" id="Enter">
					&nbsp;&nbsp;
					<select name="CopyTos" id="CopyTos" class="input" target="question" confirmStr="确实要复制这部分试题？" href="Question.asp?Type=11" refreshUrl="<%=Session("NowPage")%>" showStr="试题复制成功！">
						<option value="">复制到</option>
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Desc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
						<option value="<%=Rs("QuestionCategory_Id")%>"><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
		Wend
	End If
	Rs.Close
%>
					</select>
					<select name="MoveTos" id="MoveTos" class="input" target="question" confirmStr="确实要移动这部分试题？" href="Question.asp?Type=11" refreshUrl="<%=Session("NowPage")%>" showStr="试题移动成功！">
						<option value="">移动到</option>
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Desc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
						<option value="<%=Rs("QuestionCategory_Id")%>"><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
		Wend
	End If
	Rs.Close
%>
					</select>	
					&nbsp;&nbsp;
					<%Call FKFun.ShowPageCode("Question.asp?Type=1&QuestionTitle="&Server.URLEncode(Question_Title)&"&QuestionCategory="&Question_Category&"&QuestionType="&Question_Type&"&Page=",PageNow,PageRecordCount,PageSizes,PageCounts)%></td>
			</tr>
		</table>
		</form>
		<div id="rightBottom">
		
		</div>
<%
End Sub

'==========================================
'函 数 名：QuestionAddForm()
'作    用：添加试题表单
'==========================================
Sub QuestionAddForm()
%>
<form id="QuestionAdd" name="QuestionAdd" method="post" target="ajax" action="Question.asp?Type=3" showStr="新试题添加成功！" refreshUrl="Question.asp?Type=1" boxClose="1">
<div id="title">添加新试题</div>
<div id="box">
	<table width="95%" border="1" bordercolor="#CCCCCC" align="center" cellpadding="0" cellspacing="0">
		<tr>
			<td width="12%" height="30" align="right">题干：</td>
			<td width="88%">&nbsp;<textarea name="Question_Title" style="width:500px" rows="5" class="textarea" id="Question_Title"></textarea><span class="help" title="<p>试题名称，当是选择题时，需要在题干中带入答案，答案请用中文括号括起，多选题的多个答案用中文顿号隔开，请输入1-1000个字符（1个汉字为2个字符）。</p>"></span></td>
		</tr>
		<tr>
			<td height="30" align="right">题型：</td>
			<td>&nbsp;<select name="Question_Type" class="input" id="Question_Type">
					<option value="0">选择题（单选/多选根据答案个数自动判断）</option>
					<option value="2">简答题</option>
				</select><span class="help" title="<p>选择试题类型，多选题根据答案数量自动区分。</p>"></span>
	  		</td>
		</tr>
		<tr>
			<td height="30" align="right">试题库：</td>
			<td>&nbsp;<select name="Question_Category" class="input" id="Question_Category">
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Asc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
					<option value="<%=Rs("QuestionCategory_Id")%>"><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
			i=i+1
		Wend
	End If
	Rs.Close
%>
				</select><span class="help" title="<p>选择试题题库，在“试题库管理”功能中维护。</p>"></span>
			</td>
		</tr>
		<tr>
			<td height="30" align="right">选项/题解：</td>
			<td>&nbsp;<textarea name="Question_Content" style="width:500px" rows="5" class="textarea" id="Question_Content"></textarea>
				<br />&nbsp;&nbsp;<span style="color:#666666;">(单选或多选此处放入选项，1行1个选项；简答题本处可以放入标准答案以供判分参考)</span><span class="help" title="<p>当录入选择题时，此处放入选项，选项请不要超过26个，每一行为一个选项，当是简答题时，此处为标准答案，用于手工评分时参考，请输入1-10000个字符（1个汉字为2个字符）。</p>"></span>
			</td>
		</tr>
	</table>
</div>
<div id="bottom">
	<input type="submit" class="button" name="Enter" id="Enter" value="添 加" />
	<input type="button" onclick="dialogClose();" class="button" name="button" id="button" value="关 闭" />
</div>
</form>
<%
End Sub

'==============================
'函 数 名：QuestionAddDo
'作    用：执行添加试题
'==============================
Sub QuestionAddDo()
	Question_Title=FKFun.HTMLEncode(Trim(Request.Form("Question_Title")))
	Question_Content=FKFun.HTMLEncode(Trim(Request.Form("Question_Content")))
	Question_Category=Trim(Request.Form("Question_Category"))
	Question_Type=Trim(Request.Form("Question_Type"))
	Call FKFun.JsonString(Question_Title,1,1000,0,"请输入题干！","题干不能大于1000个字符！")
	Call FKFun.JsonNum(Question_Category,"请选择所属试题库！")
	Call FKFun.JsonNum(Question_Type,"请选择试题题型！")
	If Question_Type=0 Then
		If Len(Question_Title)-Len(Replace(Question_Title,"（",""))>1 Or Len(Question_Title)-Len(Replace(Question_Title,"）",""))>1 Then
			Call FKFun.JsonError("试题标题中有两个用中文括号扩起的区域，请将非答案区域的中文括号改为英文括号！")
		End If
		If Instr(Question_Title,"（")=0 Or Instr(Question_Title,"）")=0 Then
			Call FKFun.JsonError("未找到选择题答案区间！")
		End If
		Call FKFun.JsonString(Question_Content,1,10000,0,"请输入试题选项！","试题选项不能大于1000个字符！")
		TempAnswer=Split(Split(Question_Title,"（")(1),"）")(0)
		Question_Answer=TempAnswer
		Question_Answer=Trim(UCase(Question_Answer))
		Question_Answer=Replace(Question_Answer,"&nbsp;","")
		Question_Answer=Replace(Question_Answer," ","")
		Question_Answer=Replace(Question_Answer,"	","")
		If Question_Answer="" Then
			Call FKFun.JsonError("未找到选择题答案！")
		End if
		If Instr(Question_Answer,"、")>0 Then
			Question_Type=1
		End If
		Question_Title=Replace(Question_Title,"（"&TempAnswer&"）","（&nbsp;&nbsp;）")
	End If
	If Question_Type=0 Then
		If Len(Question_Answer)>1 Then
			Call FKFun.JsonError("单选题答案发现异常字符，请检查！")
		End If
	ElseIf Question_Type=1 Then
		TempArr=Split(Question_Answer,"、")
		For Each Temp In TempArr
			If Len(Temp)>1 Then
				Call FKFun.JsonError("多选题答案发现异常字符，请检查！")
			End If
		Next
	End If
	Sqlstr="Select Question_Id,Question_Title,Question_Answer,Question_Content,Question_Category,Question_Type From [Question] Where Question_Title='"&Question_Title&"' And Question_Category="&Question_Category&""
	Rs.Open Sqlstr,Conn,1,3
	If Rs.Eof Then
		Application.Lock()
		Rs.AddNew()
		Rs("Question_Title")=Question_Title
		If Question_Type<2 Then
			Rs("Question_Answer")=Question_Answer
		End If
		Rs("Question_Content")=Question_Content
		Rs("Question_Category")=Question_Category
		Rs("Question_Type")=Question_Type
		Rs.Update()
		Application.UnLock()
		Call FKFun.JsonSuccess()
	Else
		Rs.Close
		Call FKFun.JsonError("该试题已经存在！")
	End If
	Rs.Close
End Sub

'==========================================
'函 数 名：QuestionEditForm()
'作    用：修改试题表单
'==========================================
Sub QuestionEditForm()
	Id=Clng(Request.QueryString("Id"))
	Sqlstr="Select Question_Title,Question_Answer,Question_Content,Question_Category,Question_Type From [Question] Where Question_Id=" & Id
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		Question_Title=FkFun.HTMLDncode(Replace(Rs("Question_Title"),"（&nbsp;&nbsp;）","（"&Rs("Question_Answer")&"）"))
		Question_Content=FkFun.HTMLDncode(Rs("Question_Content"))
		Question_Category=Rs("Question_Category")
		Question_Type=Rs("Question_Type")
	Else
		Rs.Close
		Call FKFun.ShowErr("试题不存在，请按键盘的ESC键退出！",2)
	End If
	Rs.Close
%>
<form id="QuestionAdd" name="QuestionAdd" method="post" target="ajax" action="Question.asp?Type=5" showStr="试题修改成功！" refreshUrl="<%=Session("NowPage")%>" boxClose="1">
<div id="title">修改试题</div>
<div id="box">
	<table width="95%" border="1" bordercolor="#CCCCCC" align="center" cellpadding="0" cellspacing="0">
		<tr>
			<td width="12%" height="30" align="right">题干：</td>
			<td width="88%">&nbsp;<textarea name="Question_Title" style="width:500px" rows="5" class="textarea" id="Question_Title"><%=Question_Title%></textarea><span class="help" title="<p>试题名称，当是选择题时，需要在题干中带入答案，答案请用中文括号括起，多选题的多个答案用中文顿号隔开，请输入1-1000个字符（1个汉字为2个字符）。</p>"></span></td>
		</tr>
		<tr>
			<td height="30" align="right">题型：</td>
			<td>&nbsp;<select name="Question_Type" class="input" id="Question_Type">
					<option value="0"<%=FKFun.BeSelect(Question_Type,0)%>>单选题</option>
					<option value="1"<%=FKFun.BeSelect(Question_Type,1)%>>多选题</option>
					<option value="2"<%=FKFun.BeSelect(Question_Type,2)%>>简答题</option>
				</select><span class="help" title="<p>选择试题类型。</p>"></span>
	  		</td>
		</tr>
		<tr>
			<td height="30" align="right">试题库：</td>
			<td>&nbsp;<select name="Question_Category" class="input" id="Question_Category">
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Asc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
					<option value="<%=Rs("QuestionCategory_Id")%>"<%=FKFun.BeSelect(Question_Category,Rs("QuestionCategory_Id"))%>><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
			i=i+1
		Wend
	End If
	Rs.Close
%>
				</select><span class="help" title="<p>选择试题题库，在“试题库管理”功能中维护。</p>"></span>
			</td>
		</tr>
		<tr>
			<td height="30" align="right">选项/题解：</td>
			<td>&nbsp;<textarea name="Question_Content" style="width:500px" rows="5" class="textarea" id="Question_Content"><%=Question_Content%></textarea>
				<br />&nbsp;&nbsp;<span style="color:#666666;">(单选或多选此处放入选项，1行1个选项；简答题本处可以放入标准答案以供判分参考)</span><span class="help" title="<p>当录入选择题时，此处放入选项，选项请不要超过26个，每一行为一个选项，当是简答题时，此处为标准答案，用于手工评分时参考，请输入1-10000个字符（1个汉字为2个字符）。</p>"></span>
			</td>
		</tr>
	</table>
</div>
<div id="bottom">
	<input type="hidden" name="Id" value="<%=Id%>" />
	<input type="submit" class="button" name="Enter" id="Enter" value="修 改" />
	<input type="button" onclick="dialogClose();" class="button" name="button" id="button" value="关 闭" />
</div>
</form>
<%
End Sub

'==============================
'函 数 名：QuestionEditDo
'作    用：执行修改试题
'==============================
Sub QuestionEditDo()
	Question_Title=FKFun.HTMLEncode(Trim(Request.Form("Question_Title")))
	Question_Content=FKFun.HTMLEncode(Trim(Request.Form("Question_Content")))
	Question_Category=Trim(Request.Form("Question_Category"))
	Question_Type=Trim(Request.Form("Question_Type"))
	Id=Trim(Request.Form("Id"))
	Call FKFun.JsonString(Question_Title,1,1000,0,"请输入题干！","题干不能大于1000个字符！")
	Call FKFun.JsonNum(Question_Category,"请选择所属试题库！")
	Call FKFun.JsonNum(Question_Type,"请选择试题题型！")
	Call FKFun.JsonNum(Id,"系统参数错误，请刷新页面！")
	If Question_Type<2 Then
		If Len(Question_Title)-Len(Replace(Question_Title,"（",""))>1 Or Len(Question_Title)-Len(Replace(Question_Title,"）",""))>1 Then
			Call FKFun.JsonError("试题标题中有两个用中文括号扩起的区域，请将非答案区域的中文括号改为英文括号！")
		End If
		If Instr(Question_Title,"（")=0 Or Instr(Question_Title,"）")=0 Then
			Call FKFun.JsonError("未找到选择题答案区间！")
		End If
		Call FKFun.JsonString(Question_Content,1,10000,0,"请输入试题选项！","试题选项不能大于1000个字符！")
		TempAnswer=Split(Split(Question_Title,"（")(1),"）")(0)
		Question_Answer=TempAnswer
		Question_Answer=Trim(UCase(Question_Answer))
		Question_Answer=Replace(Question_Answer,"&nbsp;","")
		Question_Answer=Replace(Question_Answer," ","")
		Question_Answer=Replace(Question_Answer,"	","")
		If Question_Answer="" Then
			Call FKFun.JsonError("未找到选择题答案！")
		End if
		If Instr(Question_Answer,"、")>0 Then
			Question_Type=1
		End If
		Question_Title=Replace(Question_Title,"（"&TempAnswer&"）","（&nbsp;&nbsp;）")
	End If
	If Question_Type=0 Then
		If Len(Question_Answer)>1 Then
			Call FKFun.JsonError("单选题答案发现异常字符，请检查！")
		End If
	ElseIf Question_Type=1 Then
		TempArr=Split(Question_Answer,"、")
		For Each Temp In TempArr
			If Len(Temp)>1 Then
				Call FKFun.JsonError("多选题答案发现异常字符，请检查！")
			End If
		Next
	End If
	Sqlstr="Select Question_Id,Question_Title,Question_Answer,Question_Content,Question_Category,Question_Type From [Question] Where Question_Id=" & Id
	Rs.Open Sqlstr,Conn,1,3
	If Not Rs.Eof Then
		Application.Lock()
		Rs("Question_Title")=Question_Title
		If Question_Type<2 Then
			Rs("Question_Answer")=Question_Answer
		End If
		Rs("Question_Content")=Question_Content
		Rs("Question_Category")=Question_Category
		Rs("Question_Type")=Question_Type
		Rs.Update()
		Application.UnLock()
		Call FKFun.JsonSuccess()
	Else
		Rs.Close
		Call FKFun.JsonError("要修改的试题不存在！")
	End If
	Rs.Close
End Sub

'==============================
'函 数 名：QuestionDelDo
'作    用：执行删除试题
'==============================
Sub QuestionDelDo()
	Id=Trim(Request.QueryString("Id"))
	Call FKFun.ShowNum(Id,"系统参数错误，请刷新页面！")
	Sqlstr="Select Question_Id From [Question] Where Question_Id=" & Id
	Rs.Open Sqlstr,Conn,1,3
	If Not Rs.Eof Then
		Application.Lock()
		Rs.Delete()
		Application.UnLock()
		Response.Write("ok")
	Else
		Response.Write("试题不存在！")
	End If
	Rs.Close
End Sub

'==============================
'函 数 名：QuestionListDelDo
'作    用：执行批量删除试题
'==============================
Sub QuestionListDelDo()
	Id=Replace(Trim(Request.Form("QuestionId"))," ","")
	If Id="" Then
		Call FKFun.JsonError("请选择要删除的试题！")
	End If
	Sqlstr="Delete From [Question] Where Question_Id In ("&Id&")"
	Application.Lock()
	Conn.Execute(Sqlstr)
	Application.UnLock()
	Call FKFun.JsonSuccess()
End Sub

'==============================
'函 数 名：ImportForm
'作    用：导入试题表单
'==============================
Sub ImportForm()
%>
<form id="Import" name="Import" method="post" target="ajax">
<div id="title">导入试题</div>
<div id="box">
	<table id="ImportText" width="95%" border="1" bordercolor="#CCCCCC" align="center" cellpadding="0" cellspacing="0">
		<tr>
			<td width="12%" height="30" align="right">题型：</td>
			<td width="88%">&nbsp;<select name="Question_Type" class="input" id="Question_Type">
					<option value="1">选择题（单选/多选根据答案个数自动判断）</option>
					<option value="2">简答题</option>
				</select><span class="help" title="<p>选择试题类型，多选题根据答案数量自动区分。</p>"></span>
	  		</td>
		</tr>
		<tr>
			<td height="30" align="right">试题库：</td>
			<td>&nbsp;<select name="Question_Category" class="input" id="Question_Category">
<%
	Sqlstr="Select QuestionCategory_Id,QuestionCategory_Name From [QuestionCategory] Order By QuestionCategory_Id Asc"
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		While Not Rs.Eof
%>
					<option value="<%=Rs("QuestionCategory_Id")%>"><%=Rs("QuestionCategory_Name")%></option>
<%
			Rs.MoveNext
			i=i+1
		Wend
	End If
	Rs.Close
%>
				</select><span class="help" title="<p>选择试题题库，在“试题库管理”功能中维护。</p>"></span>
			</td>
		</tr>
		<tr>
			<td height="30" align="right">导入内容：</td>
			<td>&nbsp;<textarea name="Question_Content" style="width:500px" rows="15" class="textarea" id="Question_Content"></textarea><span class="help" title="<p>试题导入，多个题目用空行隔开，具体格式请下载例子。</p>"></span></td>
		</tr>
		<tr>
			<td height="30" align="right">说明：</td>
			<td>&nbsp;<span style="color:#F00;">请按格式放入，<a href="question.doc">参考导入格式下载</a>，复制进去后请删掉最后一个空行</span></td>
		</tr>
	</table>
	<table id="ImportTestTable" class="dis" width="95%" border="1" bordercolor="#CCCCCC" align="center" cellpadding="0" cellspacing="0">
		<tr>
			<td width="12%" height="30" align="right">&nbsp;</td>
			<td width="88%">&nbsp;&nbsp;<a href="javascript:void(0);" onclick="$('#ImportText').show();$('#ImportTestTable').hide();"><span style="color:#F00; font-weight:bold;">返回编辑框</span></a></td>
		</tr>
			<td height="30" align="right">测试结果：</td>
			<td>
				<div id="ImportTest"></div>
			</td>
		</tr>
	</table>
</div>
<div id="bottom">
	<input type="submit" class="button" value="测 试" onclick="TryImportTest(this.form);" />
	<input type="submit" class="button" name="Enter" id="Enter" value="导 入" onclick="TryImport(this.form);" />
	<input type="button" onclick="dialogClose();" class="button" name="button" id="button" value="关 闭" />
</div>
</form>
<%
End Sub

'==============================
'函 数 名：ImportTestDo
'作    用：导入试题测试
'==============================
Sub ImportTestDo()
	Dim ErrNo,inType
	Dim TempArr2,Temp2
	Question_Content=FKFun.HTMLEncode(Trim(Request.Form("Question_Content")))
	Question_Category=Trim(Request.Form("Question_Category"))
	Id=Clng(Trim(Request.Form("Question_Type")))
	Call FKFun.ShowString(Question_Content,1,0,1,"请输入导入内容！","导入内容不能大于10000000个字符！")
	Call FKFun.ShowNum(Question_Category,"请选择试题库！")
	If Instr(Question_Content,"<br />")=0 And Id=1 Then
		Call FKFun.ShowErr("导入格式有误！",2)
	End If
    Select Case Id
        Case 1
            inType="选择题"
        Case 2
            inType="简答题"
    End Select
	Response.Write("<div id='inType'>导入题目类型："&inType&"</div>")
	TempArr=Split(Question_Content,"<p></p>")
	i=1
	For Each Temp In TempArr
		If Temp<>"" Then
			If Instr(Temp,"<br />|题干结束|<br />")>0 Then
				Question_Title=Split(Temp,"<br />|题干结束|<br />")(0)
			Else
				Question_Title=Split(Temp,"<br />")(0)
			End If
			ErrNo=0
			If Id=1 Then
				If Instr(Temp,"<br />|题干结束|<br />")>0 Then
					Question_Content=Split(Temp,"<br />|题干结束|<br />")(1)
				Else
					Question_Content=Replace(Temp,Question_Title&"<br />","")
				End If
				Question_Type=0
				If Instr(Question_Title,"（")=0 Or Instr(Question_Title,"）")=0 Then
					ErrNo=1
				Else
					TempAnswer=Split(Split(Question_Title,"（")(1),"）")(0)
					Question_Answer=Split(Split(Question_Title,"（")(1),"）")(0)
					Question_Answer=Trim(UCase(Question_Answer))
					Question_Answer=Replace(Question_Answer,"&nbsp;","")
					Question_Answer=Replace(Question_Answer," ","")
					Question_Answer=Replace(Question_Answer,"	","")
					If Instr(Question_Answer,"&nbsp;")>0 Or Instr(Question_Answer," ")>0 Then
						ErrNo=2
					End If
					If Question_Answer="" Then
						ErrNo=1
					End if
					If ErrNo=0 Then
						If Len(Question_Title)-Len(Replace(Question_Title,"（",""))>1 Or Len(Question_Title)-Len(Replace(Question_Title,"）",""))>1 Then
							ErrNo=3
						Else
							If Instr(Question_Answer,"、")>0 Then
								Question_Type=1
							End If
							Question_Answer=UCase(Question_Answer)
							Question_Title=Replace(Question_Title,"（"&TempAnswer&"）","（&nbsp;&nbsp;）")
						End If
					End If
					If ErrNo=0 Then
						If Question_Type=0 Then
							If Len(Question_Answer)>1 Then
								ErrNo=4
							End If
						ElseIf Question_Type=1 Then
							TempArr2=Split(Question_Answer,"、")
							For Each Temp2 In TempArr2
								If Len(Temp2)>1 Then
									ErrNo=4
								End If
							Next
						End If
					End If
				End If
			ElseIf Id=2 Then
				If Instr(Temp,"<br />|题干结束|<br />")>0 Then
					Question_Content=Split(Temp,"<br />|题干结束|<br />")(1)
				Else
					If Instr(Temp,"<br />")>0 Then
						Question_Content=Replace(Temp,Question_Title&"<br />","")
					Else
						Question_Content=Replace(Temp,Question_Title,"")
					End If
				End If
				Question_Type=2
			End If
            Response.Write("<div class='QuestionLine'><p>"&i&".导入题目第“"&i&"”题。</p>")
            Response.Write("<p>题干："&Question_Title&"</p>")
            If InStr("01", Question_Type)>0 Then
                Response.Write("<p>答案："&Question_Answer&"</p>")
                Response.Write("<p>选项：</p>")
				Response.Write("<div style='padding-left:32px;text-indent:0;'>"&Question_Content&"</div>")
            Else
                Response.Write("<p>题解："&Question_Content&"</p>")
            End If
            If ErrNo>0 Then
                Response.Write("<p class='errLine'>本题无法导入，具体错误原因：")
                Select Case ErrNo
                    Case 1
                        Response.Write("未找到试题答案，请按格式填写！")
                    Case 2
                        Response.Write("答案区域不能出现空格！")
                    Case 3
                        Response.Write("试题标题中有两个用中文括号扩起的区域，请将非答案区域的中文括号改为英文括号！")
                    Case 4
                        Response.Write("答案字符个数异常，请检查答案！")
                End Select
                Response.Write("</p>")
            End If
            Response.Write("</div>")
			i=i+1
		End If
	Next
End Sub

'==============================
'函 数 名：ImportDo
'作    用：导入试题执行
'==============================
Sub ImportDo()
	Dim TempArr2,Temp2
	Question_Content=FKFun.HTMLEncode(Trim(Request.Form("Question_Content")))
	Question_Category=Trim(Request.Form("Question_Category"))
	Id=Clng(Trim(Request.Form("Question_Type")))
	Call FKFun.JsonString(Question_Content,1,0,1,"请输入导入内容！","导入内容不能大于10000000个字符！")
	Call FKFun.JsonNum(Question_Category,"请选择试题库！")
	Call FKFun.JsonNum(Id,"请选择试题题型！")
	If Instr(Question_Content,"<br />")=0 And Id=1 Then
		Call FKFun.JsonError("导入格式有误！")
	End If
	TempArr=Split(Question_Content,"<p></p>")
	For Each Temp In TempArr
		If Temp<>"" Then
			If Instr(Temp,"<br />|题干结束|<br />")>0 Then
				Question_Title=Split(Temp,"<br />|题干结束|<br />")(0)
			Else
				Question_Title=Split(Temp,"<br />")(0)
			End If
			If Id=1 Then
				If Instr(Temp,"<br />|题干结束|<br />")>0 Then
					Question_Content=Split(Temp,"<br />|题干结束|<br />")(1)
				Else
					Question_Content=Replace(Temp,Question_Title&"<br />","")
				End If
				Question_Type=0
				If Instr(Question_Title,"（")=0 Or Instr(Question_Title,"）")=0 Then
					Call FKFun.JsonError("“"&Question_Title&"”未找到选择题答案，请按格式填写！")
				End If
				TempAnswer=Split(Split(Question_Title,"（")(1),"）")(0)
				Question_Answer=Split(Split(Question_Title,"（")(1),"）")(0)
				Question_Answer=Trim(UCase(Question_Answer))
				Question_Answer=Replace(Question_Answer,"&nbsp;","")
				Question_Answer=Replace(Question_Answer," ","")
				Question_Answer=Replace(Question_Answer,"	","")
				If Question_Answer="" Then
					Call FKFun.JsonError("“"&Question_Title&"”未找到选择题答案，请按格式填写！")
				End if
				If Len(Question_Title)-Len(Replace(Question_Title,"（",""))>1 Or Len(Question_Title)-Len(Replace(Question_Title,"）",""))>1 Then
					Call FKFun.JsonError("“"&Question_Title&"”试题标题中有两个用中文括号扩起的区域，请将非答案区域的中文括号改为英文括号！")
				End If
				If Instr(Question_Answer,"、")>0 Then
					Question_Type=1
				End If
				Question_Answer=UCase(Question_Answer)
				Question_Title=Replace(Question_Title,"（"&TempAnswer&"）","（&nbsp;&nbsp;）")
			ElseIf Id=2 Then
				If Instr(Temp,"<br />|题干结束|<br />")>0 Then
					Question_Content=Split(Temp,"<br />|题干结束|<br />")(1)
				Else
					If Instr(Temp,"<br />")>0 Then
						Question_Content=Replace(Temp,Question_Title&"<br />","")
					Else
						Question_Content=Replace(Temp,Question_Title,"")
					End If
				End If
				Question_Type=2
			End If
			If Question_Type=0 Then
				If Len(Question_Answer)>1 Then
					Call FKFun.JsonError("“"&Question_Title&"”单选题答案校验失败，请检查答案是否正确！")
				End If
			ElseIf Question_Type=1 Then
				TempArr2=Split(Question_Answer,"、")
				For Each Temp2 In TempArr2
					If Len(Temp2)>1 Then
						Call FKFun.JsonError("“"&Question_Title&"”多选题答案校验失败，请检查答案是否正确！")
					End If
				Next
			End If
			Sqlstr="Select Question_Id,Question_Title,Question_Answer,Question_Content,Question_Category,Question_Type From [Question] Where Question_Title='"&Question_Title&"' And Question_Type="&Question_Type&" And Question_Category="&Question_Category&""
			Rs.Open Sqlstr,Conn,1,3
			If Rs.Eof Then
				Application.Lock()
				Rs.AddNew()
				Rs("Question_Title")=Question_Title
				If Id=1 Then
					Rs("Question_Answer")=Question_Answer
				End If
				Rs("Question_Content")=Question_Content
				Rs("Question_Category")=Question_Category
				Rs("Question_Type")=Question_Type
				Rs.Update()
				Application.UnLock()
			End If
			Rs.Close
		End If
	Next
	Call FKFun.JsonSuccess()
End Sub

'==============================
'函 数 名：QuestionCopy
'作    用：复制试题
'==============================
Sub QuestionCopy()
	Id=Clng(Request.QueryString("Id"))
	Temp=FKFun.HTMLEncode(Replace(Trim(Request.QueryString("QuestionId"))," ",""))
	If Temp="" Then
		Call FKFun.ShowErr("至少需要选择一道试题！",2)
	End If
	Dim Rs2
	Set Rs2=Server.Createobject("Adodb.RecordSet")
	Sqlstr="Select * From [Question] Where Question_Id In ("&Temp&")"
	Rs.Open Sqlstr,Conn,1,1
	While Not Rs.Eof
		Sqlstr="Select * From [Question] Where Question_Title='"&Rs("Question_Title")&"' And Question_Category=" & Id
		Rs2.Open Sqlstr,Conn,1,3
		If Rs2.Eof Then
			Application.Lock()
			Rs2.AddNew()
			Rs2("Question_Title")=Rs("Question_Title")
			Rs2("Question_Answer")=Rs("Question_Answer")
			Rs2("Question_Content")=Rs("Question_Content")
			Rs2("Question_Category")=Id
			Rs2("Question_Type")=Rs("Question_Type")
			Rs2.Update()
			Application.UnLock()
		End If
		Rs2.Close
		Rs.MoveNext
	Wend
	Rs.Close
	Response.Write("ok")
End Sub

'==============================
'函 数 名：QuestionMove
'作    用：移动试题
'==============================
Sub QuestionMove()
	Id=Clng(Request.QueryString("Id"))
	Temp=FKFun.HTMLEncode(Replace(Trim(Request.QueryString("QuestionId"))," ",""))
	If Temp="" Then
		Call FKFun.ShowErr("至少需要选择一道试题！",2)
	End If
	Dim Rs2
	Set Rs2=Server.Createobject("Adodb.RecordSet")
	Sqlstr="Select * From [Question] Where Question_Id In ("&Temp&")"
	Rs.Open Sqlstr,Conn,1,3
	While Not Rs.Eof
		Sqlstr="Select * From [Question] Where Question_Title='"&Rs("Question_Title")&"' And Question_Category=" & Id
		Rs2.Open Sqlstr,Conn,1,1
		If Rs2.Eof Then
			Application.Lock()
			Rs("Question_Category")=Id
			Rs.Update()
			Application.UnLock()
		End If
		Rs2.Close
		Rs.MoveNext
	Wend
	Response.Write("ok")
End Sub

'==============================
'函 数 名：ShowQuestion
'作    用：预览试题
'==============================
Sub ShowQuestion()
	Id=Clng(Request.QueryString("Id"))
	Sqlstr="Select Question_Title,Question_Content,Question_Type,Question_Answer From [Question] Where Question_Id=" & Id
	Rs.Open Sqlstr,Conn,1,1
	If Not Rs.Eof Then
		Question_Title=Rs("Question_Title")
		Question_Content=Rs("Question_Content")
		Question_Type=Rs("Question_Type")
		Question_Answer=Rs("Question_Answer")
		If Instr("01",Question_Type)>0 Then
			Question_Title=Replace(Question_Title,"（&nbsp;&nbsp;）","（"&Question_Answer&"）")
		End If
	End If
	Rs.Close
%>
<div id="title">查看题目</div>
<div id="box">
	<div style=" margin:0 auto;width:600px; height:300px; overflow:auto; margin-top:20px; margin-bottom:20px;">
		<div style="line-height:23px;"><%=Question_Title%></div>
<%
	If Instr("01",Question_Type)>0 Then
%>
        <div style="line-height:23px;">选项：<br /><%=Question_Content%></div>
<%
	End If
	If Instr("2",Question_Type)>0 Then
%>
			<div style="line-height:23px;">题解：<%=Question_Content%></div>
<%
	End If
%>
	</div>
</div>
<div id="bottom">
	<input type="button" onclick="dialogClose();" class="button" name="button" id="button" value="关 闭" />
</div>
<%
End Sub

Call FKFun.PageEnd()
%>
