<%
'==========================================
'文 件 名：Class/Cls_Fun.asp
'文件用途：系统基础类
'版权所有：方卡在线 http://www.fangka.net/
'==========================================

Class Cls_Fun
	Private Fso,F,objAdoStream
	Private FsoTemp,FsoTempArr

	'==============================
	'函 数 名：HTMLEncode
	'作    用：字符转换函数
	'==============================
	Public Function HTMLEncode(fString)
		If Not IsNull(fString) Then
			fString = replace(fString, ">", "&gt;")
			fString = replace(fString, "<", "&lt;")
			fString = Replace(fString, CHR(32), " ")		
			fString = Replace(fString, CHR(34), "&quot;")
			fString = Replace(fString, CHR(39), "&#39;")
			fString = Replace(fString, CHR(9), "&nbsp;")
			fString = Replace(fString, CHR(13), "")
			fString = Replace(fString, CHR(10) & CHR(10), "<p></p>")
			fString = Replace(fString, CHR(10), "<br />")
			HTMLEncode = fString
		End If
	End Function
	
	'==============================
	'函 数 名：HTMLDncode
	'作    用：字符转回函数
	'==============================
	Public Function HTMLDncode(fString)
		If Not IsNull(fString) Then
			fString = Replace(fString, "&gt;",">" )
			fString = Replace(fString, "&lt;", "<")
			fString = Replace(fString, " ", CHR(32))
			fString = Replace(fString, "&nbsp;", CHR(9))
			fString = Replace(fString, "&quot;", CHR(34))
			fString = Replace(fString, "&#39;", CHR(39))
			fString = Replace(fString, "", CHR(13))
			fString = Replace(fString, "<p></p>",CHR(10) & CHR(10) )
			fString = Replace(fString, "<br />",CHR(10) )
			HTMLDncode = fString
		End If
	End Function
	
	'==============================
	'函 数 名：AlertInfo
	'作    用：错误显示函数
	'==============================
	Public Function AlertInfo(InfoStr,GoUrl)
		If GoUrl="1" Then
			Response.Write "<Script>alert('"& InfoStr &"');location.href='javascript:history.go(-1)';</Script>"
		Else
			Response.Write "<Script>alert('"& InfoStr &"');location.href='"& GoUrl &"';</Script>"
		End If
		Call PageEnd()
	End Function
	
	'==============================
	'函 数 名：AlertNum
	'作    用：判断是否是数字（验证字符，不为数字时的提示）
	'==============================
	Public Function AlertNum(CheckStr,ErrStr)
		If Not IsNumeric(CheckStr) or CheckStr="" Then
			Call AlertInfo(ErrStr,"1")
		End If
	End Function

	'==============================
	'函 数 名：AlertString
	'作    用：判断字符串长度
	'参    数：需进行判断的文本CheckStr
	'		  限定最短ShortLen
	'		  限定最长LongLen
	'		  验证类型CheckType（0两头限制，1限制最短，2限制最长）
	'		  过短提示LongStr
	'		  过长提示LongStr，
	'==============================
	Public Function AlertString(CheckStr,ShortLen,LongLen,CheckType,ShortErr,LongErr)
		If (CheckType=0 Or CheckType=1) And StringLength(CheckStr)<ShortLen Then
			Call AlertInfo(ShortErr,"1")
		End If
		If (CheckType=0 Or CheckType=2) And StringLength(CheckStr)>LongLen Then
			Call AlertInfo(LongErr,"1")
		End If
	End Function
	
	'==============================
	'函 数 名：ShowNum
	'作    用：判断是否是数字（验证字符，不为数字时的提示）
	'==============================
	Public Function ShowNum(CheckStr,ErrStr)
		If Not IsNumeric(CheckStr) or CheckStr="" Then
			Response.Write(ErrStr)
			Call PageEnd()
		End If
	End Function

	'==============================
	'函 数 名：ShowString
	'作    用：判断字符串长度
	'参    数：需进行判断的文本CheckStr
	'		  限定最短ShortLen
	'		  限定最长LongLen
	'		  验证类型CheckType（0两头限制，1限制最短，2限制最长）
	'		  过短提示LongStr
	'		  过长提示LongStr，
	'==============================
	Public Function ShowString(CheckStr,ShortLen,LongLen,CheckType,ShortErr,LongErr)
		If (CheckType=0 Or CheckType=1) And StringLength(CheckStr)<ShortLen Then
			Response.Write(ShortErr)
			Call PageEnd()
		End If
		If (CheckType=0 Or CheckType=2) And StringLength(CheckStr)>LongLen Then
			Response.Write(LongErr)
			Call PageEnd()
		End If
	End Function
	
	'==============================
	'函 数 名：JsonNum
	'作    用：判断是否是数字（验证字符，不为数字时的提示）
	'==============================
	Public Function JsonNum(CheckStr,ErrStr)
		If Not IsNumeric(CheckStr) or CheckStr="" Then
			Call JsonError(ErrStr)
		End If
	End Function

	'==============================
	'函 数 名：JsonString
	'作    用：判断字符串长度
	'参    数：需进行判断的文本CheckStr
	'		  限定最短ShortLen
	'		  限定最长LongLen
	'		  验证类型CheckType（0两头限制，1限制最短，2限制最长）
	'		  过短提示LongStr
	'		  过长提示LongStr，
	'==============================
	Public Function JsonString(CheckStr,ShortLen,LongLen,CheckType,ShortErr,LongErr)
		If (CheckType=0 Or CheckType=1) And StringLength(CheckStr)<ShortLen Then
			Call JsonError(ShortErr)
		End If
		If (CheckType=0 Or CheckType=2) And StringLength(CheckStr)>LongLen Then
			Call JsonError(LongErr)
		End If
	End Function
	
	'==============================
	'函 数 名：JsonSuccess
	'作    用：json成功提示
	'==============================
	Public Function JsonSuccess()
		Response.Write("{""statusCode"":""200""}")
	End Function
	
	'==============================
	'函 数 名：JsonError
	'作    用：json错误提示
	'==============================
	Public Function JsonError(ErrStr)
		Response.Write("{""statusCode"":""201"",""errorStr"":"""&ErrStr&"""}")
		Call PageEnd()
	End Function
		
	'==============================
	'函 数 名：PageEnd
	'作    用：页面结束
	'==============================
	Public Function PageEnd()
		Set Rs=Nothing
		If IsObject(Conn) Then Conn.Close
		Set Conn = Nothing
		Session.CodePage=936
		Response.End()
	End Function

	'==============================
	'函 数 名：StringLength
	'作    用：判断字符串长度
	'==============================
	Public Function StringLength(Txt)
		Dim x,y,ii
		Txt=Trim(Txt)
		x=Len(Txt)
		y=0
		For ii = 1 To x
			If Asc(Mid(Txt,ii,1))<=2 or Asc(Mid(Txt,ii,1))>255 Then
				y=y + 2
			Else
				y=y + 1
			End If
		Next
		StringLength=y
	End Function
	
	'==============================
	'函 数 名：BeSelect
	'作    用：判断select选项选中
	'==============================
	Public Function BeSelect(Select1,Select2)
		If Select1=Select2 Then
			BeSelect=" selected='selected'"
		End If
	End Function
	
	'==============================
	'函 数 名：BeCheck
	'作    用：判断Check选项选中
	'==============================
	Public Function BeCheck(Check1,Check2)
		If Check1=Check2 Then
			BeCheck=" checked='checked'"
		End If
	End Function
		
	'==============================
	'函 数 名：GetStr
	'作    用：截取字符串
	'==============================
	Public Function GetStr(Str,LenNum)
		If Len(Str)>LenNum Then
			GetStr=Left(Str,LenNum)&"..."
		Else
			GetStr=Str
		End If
	End Function

	'==============================
	'函 数 名：ShowPageCode
	'作    用：显示页码
	'参    数：链接p_Url
	'		  当前页p_Now
	'		  记录数p_RecordCount
	'		  每页数量p_Size
	'		  总页数p_PageCount
	'==============================
	Public Function ShowPageCode(p_Url,p_Now,p_RecordCount,p_Size,p_PageCount)
		Dim PageDiv
		If p_RecordCount=0 Then
			p_RecordCount=0
			p_PageCount=0
		End If
		If Instr(p_Url,"|ss--ss|")>0 Then
			PageDiv=Split(p_Url,"|ss--ss|")(0)
			p_Url=Split(p_Url,"|ss--ss|")(1)
		Else
			PageDiv="mainRight"
		End If
		If p_Now>1 Then
			Response.Write("<a href=""javascript:void(0);"" onclick=""ajax_get('"&PageDiv&"','"&p_Url&"1');"">第一页</a>")
			Response.Write("&nbsp;")
			Response.Write("<a href=""javascript:void(0);"" onclick=""ajax_get('"&PageDiv&"','"&p_Url&(p_Now-1)&"');"">上一页</a>")
		Else
			Response.Write("第一页")
			Response.Write("&nbsp;")
			Response.Write("上一页")
		End If
		Response.Write("&nbsp;")
		If p_PageCount>p_Now Then
			Response.Write("<a href=""javascript:void(0);"" onclick=""ajax_get('"&PageDiv&"','"&p_Url&(p_Now+1)&"');"">下一页</a>")
			Response.Write("&nbsp;")
			Response.Write("<a href=""javascript:void(0);"" onclick=""ajax_get('"&PageDiv&"','"&p_Url&p_PageCount&"');"">尾页</a>")
		Else
			Response.Write("下一页")
			Response.Write("&nbsp;")
			Response.Write("尾页")
		End If
		Response.Write("&nbsp;"&p_Size&"条/页&nbsp;共"&p_PageCount&"页/"&p_RecordCount&"条&nbsp;当前第"&p_Now&"页&nbsp;")
		If p_PageCount>1 Then
			Response.Write("<select name=""Change_Page"" id=""Change_Page"" onChange=""ajax_get('"&PageDiv&"','"&p_Url&"'+this.options[this.selectedIndex].value);"">")
			For i=1 To p_PageCount
				If i=p_Now Then
					Response.Write("<option value="""&i&""" selected=""selected"">第"&i&"页</option>")
				Else
					Response.Write("<option value="""&i&""">第"&i&"页</option>")
				End If
			Next
			Response.Write("</select>")
		End If
	End Function

	'==============================
	'函 数 名：FormatExamTime
	'作    用：格式化考试时长
	'==============================
	Public Function FormatExamTime(MyExamTime)
		FormatExamTime=CStr(CLng(MyExamTime/60))&"分钟"&CStr(CLng(MyExamTime Mod 60))&"秒"
	End Function

	'==============================
	'函 数 名：GetQuestionTypeName
	'作    用：获取试题类型
	'==============================
	Public Function GetQuestionTypeName(QuestionType)
		Select Case QuestionType
			Case 0
				GetQuestionTypeName="单选题"
			Case 1
				GetQuestionTypeName="多选题"
			Case 2
				GetQuestionTypeName="简答题"
		End Select
	End Function

	'==============================
	'函 数 名：GetAdminTypeName
	'作    用：获取管理员类型
	'==============================
	Public Function GetAdminTypeName(AdminType)
		Select Case AdminType
			Case 0
				GetAdminTypeName="超级管理员"
			Case 1
				GetAdminTypeName="阅卷员"
			Case 2
				GetAdminTypeName="试题录入员"
		End Select
	End Function

	'==============================
	'函 数 名：GetExamTypeName
	'作    用：获取考试项目类型
	'==============================
	Public Function GetExamTypeName(ExamType)
		Select Case ExamType
			Case 0
				GetExamTypeName="考试"
			Case 1
				GetExamTypeName="练习"
			Case 2
				GetExamTypeName="练习"
		End Select
	End Function

	'==============================
	'函 数 名：GetNowUrl
	'作    用：返回当前网址
	'==============================
	Public Function GetNowUrl()
		GetNowUrl=Request.ServerVariables("Script_Name")&"?"&Request.ServerVariables("QUERY_STRING")
	End Function
		
	'==============================
	'函 数 名：ChangeTime
	'作    用：处理时间
	'==============================
	Public Function FormatTime(str,sTime)
		str=Replace(str,"yyyy",Year(sTime))
		str=Replace(str,"yy",Right(Year(sTime),2))
		str=Replace(str,"mm",Month(sTime))
		str=Replace(str,"dd",Day(sTime))
		str=Replace(str,"hh",Hour(sTime))
		str=Replace(str,"nn",Minute(sTime))
		str=Replace(str,"ss",Second(sTime))
		FormatTime=str
	End Function
	
	'==============================
	'函 数 名：ShowErr
	'作    用：错误提示函数
	'参    数：错误说明ErrStr
	'         错误类型ErrType(0前台，1后台)
	'==============================
	Public Function ShowErr(ErrStr,ErrType)
		If ErrType=0 Then
			Temp="<!DOCTYPE html PUBLIC ""-//W3C//DTD XHTML 1.0 Transitional//EN"" ""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"">"
			Temp=Temp&"<html xmlns=""http://www.w3.org/1999/xhtml"">"
			Temp=Temp&"<head>"
			Temp=Temp&"<meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"" />"
			Temp=Temp&"<title>系统提示</title>"
			Temp=Temp&"<style type=""text/css"">"
			Temp=Temp&"body,td,th {font-size: 12px;}"
			Temp=Temp&"body {margin-left:0px;margin-top:50px;margin-right: 0px;margin-bottom: 0px;}"
			Temp=Temp&"#errBox {width:500px;margin:0 auto;border:1px solid #CCC;}"
			Temp=Temp&"#errTitle {border-bottom:1px solid #CCC;line-height:25px;text-align:center;}"
			Temp=Temp&"#errStr {padding:10px;line-height:22px;text-indent:24px;}"
			Temp=Temp&"</style>"
			Temp=Temp&"</head>"
			Temp=Temp&"<body>"
			Temp=Temp&"<div id=""errBox"">"
			Temp=Temp&"	<div id=""errTitle"">系统提示</div>"
			Temp=Temp&"    <div id=""errStr"">"&ErrStr&"</div>"
			Temp=Temp&"</div>"
			Temp=Temp&"</body>"
			Temp=Temp&"</html>"
		ElseIf ErrType=1 Then
			Temp="<div id=""errBox"">"
			Temp=Temp&"	<div id=""errTitle"">系统提示</div>"
			Temp=Temp&"    <div id=""errStr"">"&ErrStr&"</div>"
			Temp=Temp&"</div>"
			Temp=Temp&"</body>"
		End If
		If ErrType=2 Then
			Temp=ErrStr
		End If
		Response.Write(Temp)
		Call PageEnd()
	End Function
	
	'==============================
	'函 数 名：CheckIp
	'作    用：正则表达式，获取字符串
	'==============================
	Public Function CheckIp(AllowIp,MyIp)
		If MyIp="::1" Then
			MyIp="127.0.0.1"
		End If
		If InStr(AllowIp,MyIp)>0 Then
			CheckIp=True
			Exit Function
		End If
		MyIp=Split(MyIp,".")(0)&"."&Split(MyIp,".")(1)&"."&Split(MyIp,".")(2)&".*"
		If InStr(AllowIp,MyIp)>0 Then
			CheckIp=True
			Exit Function
		End If
		MyIp=Split(MyIp,".")(0)&"."&Split(MyIp,".")(1)&".*.*"
		If InStr(AllowIp,MyIp)>0 Then
			CheckIp=True
			Exit Function
		End If
		MyIp=Split(MyIp,".")(0)&".*.*.*"
		If InStr(AllowIp,MyIp)>0 Then
			CheckIp=True
			Exit Function
		End If
		CheckIp=False
	End Function
	
	'==============================
	'函 数 名：GetDir
	'作    用：获取安装路径
	'==============================
	Public Function GetDir()
		Dim DirTemp
		GetDir=Trim(Request.ServerVariables("SCRIPT_NAME"))
		DirTemp=Split(GetDir,"/")(UBound(Split(GetDir,"/"))-1)&"/"
		GetDir=left(GetDir,Instr(LCase(GetDir),"/"&LCase(DirTemp)))
		If Instr(UCase(GetDir),"/W3SVC")<>0 Then
		   GetDir=Left(GetDir,Instr(GetDir,"/W3SVC"))
		End If
	End Function

	'==============================
	'函 数 名：GetDomain
	'作    用：获取系统网址
	'==============================
	Public Function GetDomain()
		If Request.ServerVariables("SERVER_PORT") = "80" Then
			GetDomain=Request.ServerVariables("SERVER_NAME")
		Else
			GetDomain=Request.ServerVariables("SERVER_NAME") & ":" & Request.ServerVariables("SERVER_PORT")
		End If
		 If Instr(UCase(GetDomain),"/W3SVC")<>0 Then
			   GetDomain=Left(GetDomain,Instr(GetDomain,"/W3SVC"))
		 End If
		 GetDomain="http://"&GetDomain&"/"
	End Function

	'==============================
	'函 数 名：GetAdminDir
	'作    用：获取管理目录
	'==============================
	Public Function GetAdminDir()
		If Request.ServerVariables("SERVER_PORT")<>"80" Then
			GetAdminDir="http://"&Request.ServerVariables("SERVER_NAME")&":"&Request.ServerVariables("SERVER_PORT")&Request.ServerVariables("URL")
		Else
			GetAdminDir="http://"&Request.ServerVariables("SERVER_NAME")&Request.ServerVariables("URL")
		End If
		GetAdminDir=Left(GetAdminDir,InstrRev(GetAdminDir,"/")-1)
		GetAdminDir=LCase(Mid(GetAdminDir,InstrRev(GetAdminDir,"/")+1))
	End Function
	
	'==============================
	'函 数 名：FsoLineWrite
	'作    用：按行写入文件
	'==============================
	Public Function FsoLineWrite(FilePath,LineNum,LineContent)
		If LineNum<1 Then Exit Function
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If Not Fso.FileExists(Server.MapPath(FilePath)) Then Exit Function
		FsoTemp=FsoFileRead(FilePath)
		FsoTempArr=Split(FsoTemp,Chr(13)&Chr(10))
		FsoTempArr(LineNum-1)=LineContent
		FsoTemp=Join(FsoTempArr,Chr(13)&Chr(10))
		Call CreateFile(FilePath,FsoTemp)
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：FsoFileRead
	'作    用：读取文件
	'==============================
	Public Function FsoFileRead(FilePath)
		Set objAdoStream=Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type=2
		objAdoStream.mode=3  
		objAdoStream.charset="utf-8"
		objAdoStream.open 
		objAdoStream.LoadFromFile Server.MapPath(FilePath) 
		FsoFileRead=objAdoStream.ReadText 
		objAdoStream.Close
		Set objAdoStream=Nothing
	End Function
	
	'==============================
	'函 数 名：CopyFiles
	'作    用：复制文件
	'==============================
	Public Function CopyFiles(SourcePath,CopyToPath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		Fso.CopyFile Server.MapPath(SourcePath),Server.MapPath(CopyToPath)
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：ReNameFolder
	'作    用：重命名文件夹
	'==============================
	Public Function ReNameFolder(FolderName,NewFolderName)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		Fso.MoveFolder Server.MapPath(FolderName),Server.MapPath(NewFolderName)
		Set Fso=Nothing
	End Function 
	
	'==============================
	'函 数 名：CreateFolder
	'作    用：创建文件夹
	'==============================
	Public Function CreateFolder(FolderPath)
		If FolderPath<>"" Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Set F=Fso.CreateFolder(Server.MapPath(FolderPath))
			CreateFolder=F.Path
			Set F=Nothing
			Set Fso=Nothing
		End If
	End Function
	
	'==============================
	'函 数 名：CreateFile
	'作    用：创建文件
	'==============================
	Public Function CreateFile(FilePath,FileContent)
		Set objAdoStream=Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type=2
		objAdoStream.Charset="utf-8" 
		objAdoStream.Open
		objAdoStream.WriteText=FileContent
		objAdoStream.SaveToFile Server.MapPath(FilePath),2
		objAdoStream.Close()
		Set objAdoStream=Nothing
	End Function
	
	'==============================
	'函 数 名：CreateFileGB2312
	'作    用：创建GB2312文件
	'==============================
	Public Function CreateFileGB2312(FilePath,FileContent)
		Set objAdoStream=Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type=2
		objAdoStream.Charset="gb2312"
		objAdoStream.Open
		objAdoStream.WriteText=FileContent
		objAdoStream.SaveToFile Server.MapPath(FilePath),2
		objAdoStream.Close
		Set objAdoStream=Nothing
	End Function
	
	'==============================
	'函 数 名：IsFolder
	'作    用：检测文件夹是否存在
	'==============================
	Public Function IsFolder(FolderPath)
		If FolderPath<>"" Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			If Fso.FolderExists(Server.MapPath(FolderPath)) Then  
				IsFolder=True
			Else
				IsFolder=False
			End If
			Set Fso=Nothing
		End If
	End Function
	
	'==============================
	'函 数 名：IsFile
	'作    用：检测文件是否存在
	'==============================
	Public Function IsFile(FilePath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If (Fso.FileExists(Server.MapPath(FilePath))) Then
			IsFile=True
		Else
			IsFile=False
		End If
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：DelFolder
	'作    用：删除文件夹
	'==============================
	Public Function DelFolder(FolderPath)
		If IsFolder(FolderPath)=True Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFolder(Server.MapPath(FolderPath))
			Set Fso=Nothing
		End If 
	End Function 
	
	'==============================
	'函 数 名：DelFile
	'作    用：删除文件
	'==============================
	Public Function DelFile(FilePath)
		If IsFile(FilePath)=True Then 
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFile(Server.MapPath(FilePath))
			Set Fso=Nothing
		End If
	End Function 
End Class
%>
