//==========================================
//文 件 名：yui.ajax.js
//文件用途：YUI异步函数
//版权所有：方卡在线 http://www.fangka.net/
//==========================================

var isPost=0;

$(document).ready(function(){
	bindReset();
});

//.bind
function bindReset(){
    $("a[target='get']").unbind("click").click(function() {
        ajax_get($(this).attr('div'),$(this).attr('href'));
		return false;
    });
    $("a[target='dialog']").unbind("click").click(function() {
        dialogOpen($(this).attr('href'),$(this).attr('width'));
		return false;
    });
    $("a[target='delete']").unbind("click").click(function() {
        ajax_delete($(this));
		return false;
    });
    $("form[target='ajax']").unbind("submit").submit(function() {
		ajax_post($(this));
		return false;
    });
    $("select[target='question']").unbind("change").change(function() {
		ajax_question($(this));
		return false;
    });
}

//.get
function ajax_get(div,url){
	$('#'+div).html("<img src='Images/loading.gif' />");
//	if(isPost==0){
//		isPost=1;
		$.ajax({
			type: 'GET',
			url: url,
			dataType: 'text',
			cache: false,
			timeout: 30000,
			success: function(data, textStatus){
				$('#'+div).html(data);
				pageReset();
				bindReset();
//				isPost=0;
			},
			error: function(xhr){
				if(xhr.status==0){
					alert('数据提交超时，请重试！');
				}else{
					alert('数据提交错误！\n\nstatus:'+xhr.status+'\n\n'+xhr.responseText);
				}
				xhr=null;
//				isPost=0;
			}
		});
//	}else{
//		setTimeout("ajax_get('"+div+"','"+url+"')",500);
//	}
//	$.get(url,
//		function(data){
//			$('#'+div).html(data);
//			pageReset();
//			bindReset();
//		}
//	);
	return false;
}

//.post
function ajax_post(obj){
	if(isPost==0){
		isPost=1;
		var postUrl=$(obj).attr('action');
		var alertStr=$(obj).attr('alertStr') || '';
		var confirmStr=$(obj).attr('confirmStr') || '';
		var showStr=$(obj).attr('showStr') || '';
		var hrefUrl=$(obj).attr('hrefUrl') || '';
		var refreshUrl=$(obj).attr('refreshUrl') || '';
		var refreshDiv=$(obj).attr('refreshDiv') || 'mainRight';
		var boxClose=$(obj).attr('boxClose') || '0';
		var postDataType=$(obj).attr('dataType') || 'json';
		var postTimeOut=$(obj).attr('timeOut') || 30000;
		var postDataTypes=postDataType;
		if(postDataType=='exam'){
			postDataTypes='text';
		}
		if(refreshDiv=='no'){
			refreshDiv='';
		}
		if(confirmStr!=''){
			if(!confirm(confirmStr)){
				return false;
			}
		}
		if($('#Enter').length>0){
			var submitButton=$('#Enter').val();
			$('#Enter').val('正在提交');
		}
		$.ajax({
			type: 'POST',
			url: $(obj).attr('action'),
			data: $(obj).serializeArray(),
			dataType: postDataTypes,
			cache: false,
			timeout: postTimeOut,
			success: function(data, textStatus){
				if(postDataType=='json'){
					if(data.statusCode=='200'){
						if(alertStr!=''){
							alert(alertStr);
						}
						if(showStr!=''){
							$('#msgContent').html(showStr);
							$('#msgBox').show();
							setTimeout('hiddenMsg()',4000);
						}
						if(hrefUrl!=''){
							location.href=hrefUrl;
						}
						if(refreshUrl!=''){
							ajax_get(refreshDiv,refreshUrl);
						}
						if(boxClose=='1'){
							dialogClose();
						}
					}else{
						alert(data.errorStr);
					}
				}else if(postDataType=='text'){
					if(alertStr=='data'){
						alert(data);
					}else if(alertStr!=''){
						alert(alertStr);
					}
					if(hrefUrl!=''){
						location.href=hrefUrl;
					}
					if(showStr!=''){
						$('#msgContent').val(showStr);
						$('#msgBox').show();
						setTimeout('hiddenMsg()',4000);
					}
					if(refreshDiv!=''){
						$('#'+refreshDiv).html(data);
						pageReset();
						bindReset();
					}
				}else if(postDataType=='exam'){
					if(data.split('||')[0]=='err'){
						alert(data.split('||')[1]);
						location.href='Main.asp';
					}
					if(data.split('||')[0]=='ok'){
						examTimeRun=0;
						if(refreshDiv!=''){
							$('#'+refreshDiv).html(data.split('||')[1]);
						}else{
							alert(data.split('||')[1]);
							if(hrefUrl!=''){
								location.href=hrefUrl;
							}
						}
					}else{
						alert(data);
					}
				}
			},
			error: function(xhr){
				if(xhr.status==0){
					alert('数据提交超时，请重试！');
				}else{
					alert('数据提交错误！\n\nstatus:'+xhr.status+'\n\n'+xhr.responseText);
				}
				xhr=null;
			}
		});
		isPost=0;
		if($('#Enter').length>0){
			$('#Enter').val(submitButton);
		}
	}else{
		alert("请勿重复提交！");	
	}
}

//.delete
function ajax_delete(obj){
	var url=$(obj).attr('href');
	var confirmStr=$(obj).attr('confirmStr') || '您确定要删除？此操作不可逆！';
	var alertStr=$(obj).attr('alertStr') || '';
	var showStr=$(obj).attr('showStr') || '';
	var refreshUrl=$(obj).attr('refreshUrl') || '';
	var refreshDiv=$(obj).attr('refreshDiv') || 'mainRight';
	if(confirm(confirmStr)){
		$.get(url,
			function(data){
				if(data=='ok'){
					if(alertStr!=''){
						alert(alertStr);
					}
					if(showStr!=''){
						$('#msgContent').html(showStr);
						$('#msgBox').show();
						setTimeout('hiddenMsg()',4000);
					}
					if(refreshUrl!=''){
						ajax_get(refreshDiv,refreshUrl);
					}
				}else{
					alert(data);
				}
			}
		);
		return false;
	}else{
		return false;
	}
}

//.ajax_question
function ajax_question(obj){
	var url=$(obj).attr('href');
	var confirmStr=$(obj).attr('confirmStr') || '您确定要删除？此操作不可逆！';
	var showStr=$(obj).attr('showStr') || '';
	var refreshUrl=$(obj).attr('refreshUrl') || '';
	var refreshDiv=$(obj).attr('refreshDiv') || 'mainRight';
	url=url+'&Id='+$(obj).val()+'&QuestionId='+GetCheckQbox()
	if(confirm(confirmStr)){
		$.get(url,
			function(data){
				if(data=='ok'){
					if(showStr!=''){
						$('#msgContent').html(showStr);
						$('#msgBox').show();
						setTimeout('hiddenMsg()',4000);
					}
					if(refreshUrl!=''){
						ajax_get(refreshDiv,refreshUrl);
					}
				}else{
					alert(data);
				}
			}
		);
		return false;
	}else{
		return false;
	}
}

//.closeMsgBox
function hiddenMsg(){
	$("#msgBox").hide();
}

//.dialogOpen
function dialogOpen(url,d_width){
	$('#dialog').html("<a href='javascript:void(0);' title='点此关闭' onclick='dialogClose();'><img src='Images/dialog_loading.gif' /></a>");
	$('#dialog').width("200px");
	$('#dialog').css("padding-top","100px");;
	$("#dialogAlpha").height($(document).height());
	$("#dialogAlpha").width($(document).width());
	$('#dialogBox').show();
	$('#dialogAlpha').show();
	$('select').hide();
	var bottom_width=d_width-20;
	$.ajax({
		type: 'GET',
		url: url,
		dataType: 'text',
		cache: false,
		timeout: 30000,
		success: function(data, textStatus){
			$('#dialog').html(data);
			$('#dialog').width(d_width+"px");
			$('#dialog').css("padding-top","20px");;
			$('#dialog #bottom').css("width",bottom_width+"px");
			$('.help').append('&nbsp;&nbsp;<img src="Images/help.jpg" />');
			$('.help').simpletooltip();
			pageReset();
			bindReset();
		},
		error: function(xhr){
			if(xhr.status==0){
				alert('数据提交超时，请重试！');
			}else{
				alert('数据提交错误！\n\nstatus:'+xhr.status+'\n\n'+xhr.responseText);
			}
			xhr=null;
		}
	});
}

//.dialogClose
function dialogClose(){
	$('#dialogBox').hide();
	$('#dialogAlpha').hide();
	$('select').show();
}

//.TryImportTest
function TryImportTest(obj){
	$(obj).attr('action','Question.asp?Type=9');
	$(obj).attr('alertStr','');
	$(obj).attr('confirmStr','');
	$(obj).attr('showStr','');
	$(obj).attr('refreshUrl','');
	$(obj).attr('refreshDiv','ImportTest');
	$(obj).attr('boxClose','0');
	$(obj).attr('dataType','text');
	$('#ImportText').hide();
	$('#ImportTest').html("<img src='Images/loading.gif' />");
	$('#ImportTestTable').show();
	return false;
}

//.TryImport
function TryImport(obj){
	$(obj).attr('action','Question.asp?Type=10');
	$(obj).attr('alertStr','');
	$(obj).attr('confirmStr','');
	$(obj).attr('showStr','试题导入成功！');
	$(obj).attr('refreshUrl','Question.asp?Type=1');
	$(obj).attr('refreshDiv','');
	$(obj).attr('boxClose','1');
	$(obj).attr('dataType','json');
}

//.GetCheckQbox
function GetCheckQbox(){
	var text="";   
	$("input[name=QuestionId]").each(function() {   
		if ($(this).attr("checked")) {
			if(text==''){
				text = $(this).val();   
			}else{
				text += ","+$(this).val();   
			}
		}   
	}); 
	return text;
}


//.checkAll
function CheckAll(form) {
	for (var i = 0; i < form.elements.length; i++) {
		var e = form.elements[i];
		if (e.name != 'chkall') 
			e.checked = form.chkall.checked;
	}
}
