﻿<%@ Page Language="C#" EnableTheming="false" Title="EnjooSite Admin - Configure" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master"
    Codebehind="Configure.aspx.cs" Inherits="EnjooSite.Web.Admin.Pages.Configure" %>

<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>

<asp:Content ID="HeadContent" ContentPlaceHolderID="ContentPlaceHolder_Head" runat="server">
    <script type="text/javascript">
        var currentFCKEditorInstanceId = '<%= richTextEditor.ClientID %>';
        $(function() {
            $(":text").addClass("inline_text");
        });
    </script>
</asp:Content>


<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a class="admin-home" href='<%= UrlHelper.AdminUrl %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text")%>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text")%></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_ProfileEdit_Text")%></label>
        </li>
        <li style="float:right;">
            <label>上次更新时间：<%= UIText.NiceDateString( Config.CurrentBlog.LastUpdated) %></label>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="configurationOptions" ContentPlaceHolderID="pageContent" runat="server">
    <st:MessagePanel ID="Messages" runat="server" />   
    <div class="hSpace_10"></div>
    
    <div id="profile-header" style="padding-left: 25px;">
        <h2>
            <asp:Literal ID="UserNameLiteral" runat="server"></asp:Literal>
        </h2>
        <div style="margin-top:10px;margin-bottom:25px;">
            <asp:Label ID="UserDescLabel" runat="server"></asp:Label>
        </div>
        <ul id="myTabs" class="profile-nav clearfix" style="display:none;">
            <li>
                <a href="#fragment-1"><span>基本设置</span></a>
            </li>
            <li>
                <a  href="#fragment-2"><span>OpenID设置</span></a>
            </li>
            <li>
                <a href="#fragment-3"><span>头像</span></a>
            </li>
            <li>
                <a href="#fragment-4"><span>自定义样式</span></a>
            </li>
            <li>
                <a href="#fragment-5"><span>公告</span></a>
            </li>
            <li style="display:none;">
                <a href="#fragment-6"><span>Sitewide Tracking code</span></a>
            </li>
        </ul>
        
    </div>
    
    <div class="enjoosite_portal_fullwidth" id="configure-form">
    
        <h5>基本设置</h5>
        
        <div id="fragment-1">
            <label accesskey="t" for="Edit_txbTitle">空间标题</label>
            <asp:TextBox ID="txbTitle" runat="server" CssClass="inline_text"  />
            <label accesskey="s" for="Edit_txbSubtitle">空间副标题</label>
            <asp:TextBox ID="txbSubtitle" runat="server" CssClass="textbox" />
            <label accesskey="u" for="Edit_txbUser">用户名</label>
            <asp:TextBox ID="txbUser" runat="server" CssClass="textbox" Enabled="false"/>
            <label accesskey="n" for="Edit_txbAuthor">昵称</label>
            <asp:TextBox ID="txbAuthor" runat="server" CssClass="textbox" />
            <label accesskey="e" for="Edit_txbAuthorEmail">电子邮箱</label>
            <asp:TextBox ID="txbAuthorEmail" runat="server" CssClass="textbox" />
            <label><asp:CheckBox ID="ckbAllowServiceAccess" runat="server" TextAlign="Left" CssClass="checkbox" AccessKey="w" Text="允许通过WebService管理" /></label>
 
            <label accesskey="z" for="Edit_ddlTimezone">
                时区设置
            </label>           
            <asp:UpdatePanel ID="ajaxTimezone" runat="server">
                <ContentTemplate>
                    <p>
                        <asp:DropDownList ID="ddlTimezone" runat="server" OnSelectedIndexChanged="ddlTimezone_SelectedIndexChanged"
                            AutoPostBack="true" CssClass="wide-dropdown">
                        </asp:DropDownList>
                    </p>
                    <p>
                        <em>Time at selected timezone is: <strong>
                            <asp:Label ID="lblCurrentTime" runat="server" /></strong></em><br />
                        <em>Time at server is: <strong>
                            <asp:Label ID="lblServerTime" runat="server" /></strong></em><br />
                        <em>Server timezone is
                            <asp:Label ID="lblServerTimeZone" runat="server" /></em><br />
                        <em><acronym title="Coordinated Universal Time">UTC</acronym> time is
                            <asp:Label ID="lblUtcTime" runat="server" /></em>
                    </p>
                </ContentTemplate>
            </asp:UpdatePanel>
            
            <label accesskey="l" for="Edit_ddlLangLocale">
                语言/本地化设置
            </label>
            <asp:DropDownList ID="ddlLangLocale" runat="server">
                <asp:ListItem Text="Afrikaans" Value="af" />
                <asp:ListItem Text="Afrikaans - South Africa" Value="af-ZA" />
                <asp:ListItem Text="Albanian" Value="sq" />
                <asp:ListItem Text="Albanian - Albania" Value="sq-AL" />
                <asp:ListItem Text="Arabic" Value="ar" />
                <asp:ListItem Text="Arabic - Algeria" Value="ar-DZ" />
                <asp:ListItem Text="Arabic - Bahrain" Value="ar-BH" />
                <asp:ListItem Text="Arabic - Egypt" Value="ar-EG" />
                <asp:ListItem Text="Arabic - Iraq" Value="ar-IQ" />
                <asp:ListItem Text="Arabic - Jordan" Value="ar-JO" />
                <asp:ListItem Text="Arabic - Kuwait" Value="ar-KW" />
                <asp:ListItem Text="Arabic - Lebanon" Value="ar-LB" />
                <asp:ListItem Text="Arabic - Libya" Value="ar-LY" />
                <asp:ListItem Text="Arabic - Morocco" Value="ar-MA" />
                <asp:ListItem Text="Arabic - Oman" Value="ar-OM" />
                <asp:ListItem Text="Arabic - Qatar" Value="ar-QA" />
                <asp:ListItem Text="Arabic - Saudi Arabia" Value="ar-SA" />
                <asp:ListItem Text="Arabic - Syria" Value="ar-SY" />
                <asp:ListItem Text="Arabic - Tunisia" Value="ar-TN" />
                <asp:ListItem Text="Arabic - United Arab Emirates" Value="ar-AE" />
                <asp:ListItem Text="Arabic - Yemen" Value="ar-YE" />
                <asp:ListItem Text="Armenian" Value="hy" />
                <asp:ListItem Text="Armenian - Armenia" Value="hy-AM" />
                <asp:ListItem Text="Azeri" Value="az" />
                <asp:ListItem Text="Azeri (Cyrillic) - Azerbaijan" Value="Cy-az-AZ" />
                <asp:ListItem Text="Azeri (Latin) - Azerbaijan" Value="Lt-az-AZ" />
                <asp:ListItem Text="Basque" Value="eu" />
                <asp:ListItem Text="Basque - Basque" Value="eu-ES" />
                <asp:ListItem Text="Belarusian" Value="be" />
                <asp:ListItem Text="Belarusian - Belarus" Value="be-BY" />
                <asp:ListItem Text="Bulgarian" Value="bg" />
                <asp:ListItem Text="Bulgarian - Bulgaria" Value="bg-BG" />
                <asp:ListItem Text="Catalan" Value="ca" />
                <asp:ListItem Text="Catalan - Catalan" Value="ca-ES" />
                <asp:ListItem Text="Chinese - Hong Kong SAR" Value="zh-HK" />
                <asp:ListItem Text="Chinese - Macau SAR" Value="zh-MO" />
                <asp:ListItem Text="Chinese - China" Value="zh-CN" />
                <asp:ListItem Text="Chinese (Simplified)" Value="zh-CHS" />
                <asp:ListItem Text="Chinese - Singapore" Value="zh-SG" />
                <asp:ListItem Text="Chinese - Taiwan" Value="zh-TW" />
                <asp:ListItem Text="Chinese (Traditional)" Value="zh-CHT" />
                <asp:ListItem Text="Croatian" Value="hr" />
                <asp:ListItem Text="Croatian - Croatia" Value="hr-HR" />
                <asp:ListItem Text="Czech" Value="cs" />
                <asp:ListItem Text="Czech - Czech Republic" Value="cs-CZ" />
                <asp:ListItem Text="Danish" Value="da" />
                <asp:ListItem Text="Danish - Denmark" Value="da-DK" />
                <asp:ListItem Text="Dhivehi" Value="div" />
                <asp:ListItem Text="Dhivehi - Maldives" Value="div-MV" />
                <asp:ListItem Text="Dutch" Value="nl" />
                <asp:ListItem Text="Dutch - Belgium" Value="nl-BE" />
                <asp:ListItem Text="Dutch - The Netherlands" Value="nl-NL" />
                <asp:ListItem Text="English" Value="en" />
                <asp:ListItem Text="English - Australia" Value="en-AU" />
                <asp:ListItem Text="English - Belize" Value="en-BZ" />
                <asp:ListItem Text="English - Canada" Value="en-CA" />
                <asp:ListItem Text="English - Caribbean" Value="en-CB" />
                <asp:ListItem Text="English - Ireland" Value="en-IE" />
                <asp:ListItem Text="English - Jamaica" Value="en-JM" />
                <asp:ListItem Text="English - New Zealand" Value="en-NZ" />
                <asp:ListItem Text="English - Philippines" Value="en-PH" />
                <asp:ListItem Text="English - South Africa" Value="en-ZA" />
                <asp:ListItem Text="English - Trinidad and Tobago" Value="en-TT" />
                <asp:ListItem Text="English - United Kingdom" Value="en-GB" />
                <asp:ListItem Text="English - United States" Value="en-US" />
                <asp:ListItem Text="English - Zimbabwe" Value="en-ZW" />
                <asp:ListItem Text="Estonian" Value="et" />
                <asp:ListItem Text="Estonian - Estonia" Value="et-EE" />
                <asp:ListItem Text="Faroese" Value="fo" />
                <asp:ListItem Text="Faroese - Faroe Islands" Value="fo-FO" />
                <asp:ListItem Text="Farsi" Value="fa" />
                <asp:ListItem Text="Farsi - Iran" Value="fa-IR" />
                <asp:ListItem Text="Finnish" Value="fi" />
                <asp:ListItem Text="Finnish - Finland" Value="fi-FI" />
                <asp:ListItem Text="French" Value="fr" />
                <asp:ListItem Text="French - Belgium" Value="fr-BE" />
                <asp:ListItem Text="French - Canada" Value="fr-CA" />
                <asp:ListItem Text="French - France" Value="fr-FR" />
                <asp:ListItem Text="French - Luxembourg" Value="fr-LU" />
                <asp:ListItem Text="French - Monaco" Value="fr-MC" />
                <asp:ListItem Text="French - Switzerland" Value="fr-CH" />
                <asp:ListItem Text="Galician" Value="gl" />
                <asp:ListItem Text="Galician - Galician" Value="gl-ES" />
                <asp:ListItem Text="Georgian" Value="ka" />
                <asp:ListItem Text="Georgian - Georgia" Value="ka-GE" />
                <asp:ListItem Text="German" Value="de" />
                <asp:ListItem Text="German - Austria" Value="de-AT" />
                <asp:ListItem Text="German - Germany" Value="de-DE" />
                <asp:ListItem Text="German - Liechtenstein" Value="de-LI" />
                <asp:ListItem Text="German - Luxembourg" Value="de-LU" />
                <asp:ListItem Text="German - Switzerland" Value="de-CH" />
                <asp:ListItem Text="Greek" Value="el" />
                <asp:ListItem Text="Greek - Greece" Value="el-GR" />
                <asp:ListItem Text="Gujarati" Value="gu" />
                <asp:ListItem Text="Gujarati - India" Value="gu-IN" />
                <asp:ListItem Text="Hebrew" Value="he" />
                <asp:ListItem Text="Hebrew - Israel" Value="he-IL" />
                <asp:ListItem Text="Hindi" Value="hi" />
                <asp:ListItem Text="Hindi - India" Value="hi-IN" />
                <asp:ListItem Text="Hungarian" Value="hu" />
                <asp:ListItem Text="Hungarian - Hungary" Value="hu-HU" />
                <asp:ListItem Text="Icelandic" Value="is" />
                <asp:ListItem Text="Icelandic - Iceland" Value="is-IS" />
                <asp:ListItem Text="Indonesian" Value="id" />
                <asp:ListItem Text="Indonesian - Indonesia" Value="id-ID" />
                <asp:ListItem Text="Italian" Value="it" />
                <asp:ListItem Text="Italian - Italy" Value="it-IT" />
                <asp:ListItem Text="Italian - Switzerland" Value="it-CH" />
                <asp:ListItem Text="Japanese" Value="ja" />
                <asp:ListItem Text="Japanese - Japan" Value="ja-JP" />
                <asp:ListItem Text="Kannada" Value="kn" />
                <asp:ListItem Text="Kannada - India" Value="kn-IN" />
                <asp:ListItem Text="Kazakh" Value="kk" />
                <asp:ListItem Text="Kazakh - Kazakhstan" Value="kk-KZ" />
                <asp:ListItem Text="Konkani" Value="kok" />
                <asp:ListItem Text="Konkani - India" Value="kok-IN" />
                <asp:ListItem Text="Korean" Value="ko" />
                <asp:ListItem Text="Korean - Korea" Value="ko-KR" />
                <asp:ListItem Text="Kyrgyz" Value="ky" />
                <asp:ListItem Text="Kyrgyz - Kazakhstan" Value="ky-KZ" />
                <asp:ListItem Text="Latvian" Value="lv" />
                <asp:ListItem Text="Latvian - Latvia" Value="lv-LV" />
                <asp:ListItem Text="Lithuanian" Value="lt" />
                <asp:ListItem Text="Lithuanian - Lithuania" Value="lt-LT" />
                <asp:ListItem Text="Macedonian" Value="mk" />
                <asp:ListItem Text="Macedonian - FYROM" Value="mk-MK" />
                <asp:ListItem Text="Malay" Value="ms" />
                <asp:ListItem Text="Malay - Brunei" Value="ms-BN" />
                <asp:ListItem Text="Malay - Malaysia" Value="ms-MY" />
                <asp:ListItem Text="Marathi" Value="mr" />
                <asp:ListItem Text="Marathi - India" Value="mr-IN" />
                <asp:ListItem Text="Mongolian" Value="mn" />
                <asp:ListItem Text="Mongolian - Mongolia" Value="mn-MN" />
                <asp:ListItem Text="Norwegian" Value="no" />
                <asp:ListItem Text="Norwegian (Bokm錶) - Norway" Value="nb-NO" />
                <asp:ListItem Text="Norwegian (Nynorsk) - Norway" Value="nn-NO" />
                <asp:ListItem Text="Polish" Value="pl" />
                <asp:ListItem Text="Polish - Poland" Value="pl-PL" />
                <asp:ListItem Text="Portuguese" Value="pt" />
                <asp:ListItem Text="Portuguese - Brazil" Value="pt-BR" />
                <asp:ListItem Text="Portuguese - Portugal" Value="pt-PT" />
                <asp:ListItem Text="Punjabi" Value="pa" />
                <asp:ListItem Text="Punjabi - India" Value="pa-IN" />
                <asp:ListItem Text="Romanian" Value="ro" />
                <asp:ListItem Text="Romanian - Romania" Value="ro-RO" />
                <asp:ListItem Text="Russian" Value="ru" />
                <asp:ListItem Text="Russian - Russia" Value="ru-RU" />
                <asp:ListItem Text="Sanskrit" Value="sa" />
                <asp:ListItem Text="Sanskrit - India" Value="sa-IN" />
                <asp:ListItem Text="Serbian (Cyrillic) - Serbia" Value="Cy-sr-SP" />
                <asp:ListItem Text="Serbian (Latin) - Serbia" Value="Lt-sr-SP" />
                <asp:ListItem Text="Slovak" Value="sk" />
                <asp:ListItem Text="Slovak - Slovakia" Value="sk-SK" />
                <asp:ListItem Text="Slovenian" Value="sl" />
                <asp:ListItem Text="Slovenian - Slovenia" Value="sl-SI" />
                <asp:ListItem Text="Spanish" Value="es" />
                <asp:ListItem Text="Spanish - Argentina" Value="es-AR" />
                <asp:ListItem Text="Spanish - Bolivia" Value="es-BO" />
                <asp:ListItem Text="Spanish - Chile" Value="es-CL" />
                <asp:ListItem Text="Spanish - Colombia" Value="es-CO" />
                <asp:ListItem Text="Spanish - Costa Rica" Value="es-CR" />
                <asp:ListItem Text="Spanish - Dominican Republic" Value="es-DO" />
                <asp:ListItem Text="Spanish - Ecuador" Value="es-EC" />
                <asp:ListItem Text="Spanish - El Salvador" Value="es-SV" />
                <asp:ListItem Text="Spanish - Guatemala" Value="es-GT" />
                <asp:ListItem Text="Spanish - Honduras" Value="es-HN" />
                <asp:ListItem Text="Spanish - Mexico" Value="es-MX" />
                <asp:ListItem Text="Spanish - Nicaragua" Value="es-NI" />
                <asp:ListItem Text="Spanish - Panama" Value="es-PA" />
                <asp:ListItem Text="Spanish - Paraguay" Value="es-PY" />
                <asp:ListItem Text="Spanish - Peru" Value="es-PE" />
                <asp:ListItem Text="Spanish - Puerto Rico" Value="es-PR" />
                <asp:ListItem Text="Spanish - Spain" Value="es-ES" />
                <asp:ListItem Text="Spanish - Uruguay" Value="es-UY" />
                <asp:ListItem Text="Spanish - Venezuela" Value="es-VE" />
                <asp:ListItem Text="Swahili" Value="sw" />
                <asp:ListItem Text="Swahili - Kenya" Value="sw-KE" />
                <asp:ListItem Text="Swedish" Value="sv" />
                <asp:ListItem Text="Swedish - Finland" Value="sv-FI" />
                <asp:ListItem Text="Swedish - Sweden" Value="sv-SE" />
                <asp:ListItem Text="Syriac" Value="syr" />
                <asp:ListItem Text="Syriac - Syria" Value="syr-SY" />
                <asp:ListItem Text="Tamil" Value="ta" />
                <asp:ListItem Text="Tamil - India" Value="ta-IN" />
                <asp:ListItem Text="Tatar" Value="tt" />
                <asp:ListItem Text="Tatar - Russia" Value="tt-RU" />
                <asp:ListItem Text="Telugu" Value="te" />
                <asp:ListItem Text="Telugu - India" Value="te-IN" />
                <asp:ListItem Text="Thai" Value="th" />
                <asp:ListItem Text="Thai - Thailand" Value="th-TH" />
                <asp:ListItem Text="Turkish" Value="tr" />
                <asp:ListItem Text="Turkish - Turkey" Value="tr-TR" />
                <asp:ListItem Text="Ukrainian" Value="uk" />
                <asp:ListItem Text="Ukrainian - Ukraine" Value="uk-UA" />
                <asp:ListItem Text="Urdu" Value="ur" />
                <asp:ListItem Text="Urdu - Pakistan" Value="ur-PK" />
                <asp:ListItem Text="Uzbek" Value="uz" />
                <asp:ListItem Text="Uzbek (Cyrillic) - Uzbekistan" Value="Cy-uz-UZ" />
                <asp:ListItem Text="Uzbek (Latin) - Uzbekistan" Value="Lt-uz-UZ" />
                <asp:ListItem Text="Vietnamese" Value="vi" />
                <asp:ListItem Text="Vietnamese - Vietnam" Value="vi-VN" />
            </asp:DropDownList>
        </div> 
        
        <div id="fragment-2" style="display:none;">
            <label accesskey="s" for="Edit_tbOpenIDServer">
                OpenID <u>S</u>erver
                <st:HelpToolTip ID="hlpOpenID" runat="server" HelpText="The OpenID Server and Delegate offload OpenID queries to a third party while still using your blog URL as the OpenID username. For the Server, enter the URL for your provider's server (ex: http://www.myopenid.com/server). For the Delegate, enter your username from your provider (ex: http://username.myopenid.com)."
                    ImageUrl="~/images/icons/help-small.png" ImageWidth="16" ImageHeight="16" />
            </label>
            <asp:TextBox ID="tbOpenIDServer" runat="server" class="textbox"></asp:TextBox>
            <label accesskey="d" for="Edit_tbOpenIDDelegate">
                OpenID <u>D</u>elegate</label>
            <asp:TextBox ID="tbOpenIDDelegate" runat="server" class="textbox"></asp:TextBox>
            <label accesskey="d" for="Edit_ddlItemCount">
                <u>D</u>efault Number of Feed/Homepage Items</label>
            <asp:DropDownList ID="ddlItemCount" CssClass="number" runat="server" />
            <label accesskey="p" for="Edit_ddlCategoryListPostCount">
                Number of <u>P</u>osts in Category Lists</label>
            <asp:DropDownList ID="ddlCategoryListPostCount" CssClass="number" runat="server" />
        </div>
        
        <div id="fragment-3" style="display:none;">
            <asp:Image ID="UserLogoImage" runat="server" />
            <br />
            <asp:HyperLink ID="UpdateUserProfileICONLink" runat="server"></asp:HyperLink>
        </div>
        
        <div id="fragment-4" style="display:none;">
            <label>自定义样式
            <st:HelpToolTip ID="HelpToolTip1" runat="server" HelpText="You can enter custom CSS within this block.  Be careful as the tool will not validate the CSS.  This CSS will be included (as a proper link) within every page of your blog."
                    ImageUrl="~/images/icons/help-small.png" ImageWidth="16" ImageHeight="16" />
            </label>
            <asp:TextBox ID="txbSecondaryCss" runat="server" CssClass="textarea" TextMode="MultiLine" />
        </div>
        
        <h5>空间公告</h5>
        <div id="fragment-5">
            <st:RichTextEditor id="richTextEditor" Width="500" Height="200" ToolbarSet="Simply" runat="server" onerror="richTextEditor_Error" />
            <div class="clear"></div>
        </div>
        
        <div id="fragment-6" style="display:none;">
            <asp:TextBox ID="txbGenericTrackingCode" runat="server" CssClass="textarea" TextMode="MultiLine" />
        </div>
        
        <div style="margin:20px 0px;">
            <asp:Button ID="btnPost" runat="server" CssClass="buttonSubmit" Text="保存" />
        </div>
        
    </div>
</asp:Content>
