﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="EntriesList.ascx.cs" Inherits="EnjooSite.Web.Admin.UserControls.EntriesList" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>


<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
    <Services>
        <asp:ServiceReference Path="~/WebServices/Admin/AjaxHelper.asmx" />
    </Services>
    <Scripts>
        <asp:ScriptReference Path="~/Scripts/Admin/ajaxHelper.js" />
    </Scripts>
</asp:ScriptManagerProxy>

<asp:Repeater id="rprSelectionList" runat="server">
	<HeaderTemplate>
		<table id="Listing" class="listing highlightTable" cellspacing="0" cellpadding="0" border="0">
		    <thead>
			    <tr>
			        <th width="25">&nbsp;</th>
				    <th valign="middle">
				        <%= UIText.GetSafeText("VSite", "Label_PostTitle_Text", string.Empty)%>
				    </th>
				    <th width="75" valign="middle">
				        <%= UIText.GetSafeText("VSite","Label_PostActive_Text",string.Empty ) %>
				    </th>
				    <th width="125" valign="middle">
				        <%= UIText.GetSafeText("VSite","Label_DataAdded_Text" , string.Empty ) %>
				    </th>
				    <th width="75" valign="middle">
				        <%= UIText.GetSafeText("VSite","Label_Comments_View_Text",string.Empty) %>
				    </th>
				    <% if(false){ %>
				    <th width="50"><%= UIText.GetSafeText("VSite", "Label_Referrals_Text", string.Empty)%></th>
				    <% } %>
				    <th width="50">&nbsp;</th>
			    </tr>
			</thead
			<tbody>
	</HeaderTemplate>
	<ItemTemplate>
		<tr>
		    <td>
		        <input type="checkbox" commandArgument='<%# ((Entry)Container.DataItem).Id %>' />
		    </td>
			<td>
			    <asp:HyperLink runat="server" NavigateUrl='<%# DataBinder.Eval(Container.DataItem, "FullyQualifiedUrl") %>' ToolTip="View Entry" >
			        <%# DataBinder.Eval(Container.DataItem, "Title") %></asp:HyperLink>
			</td>
			<td>
				<%# IsActiveText(Container.DataItem)%>
			</td>												
			<td>
				<%# UIText.NiceDateString(((Entry)Container.DataItem).DateCreated) %>
			</td>				
			<td>
			    <%# string.Format("{0} / {1}", ((Entry)Container.DataItem).FeedBackCount, ((EntryStatsView)Container.DataItem).WebCount)%>
			</td>	
			<% if (false)
            { %>			
			<td>
				<a href="../Referrers.aspx?EntryID=<%# Eval("Id") %>" title="View Referrals">
				    <%= UIText.GetSafeText("VSite", "Link_View_Text", string.Empty)%>
				</a>
			</td>
			<% } %>
			<td>
				<a href="Edit.aspx?PostId=<%# Eval("Id") %>" title="Edit Post">
				    <%= UIText.GetSafeText("VSite" , "Link_Edit_Text" , string.Empty )  %>
				</a>
			</td>
		</tr>
	</ItemTemplate>
	<AlternatingItemTemplate>
	    <tr class="alt">
	        <td>
		        <input type="checkbox" commandArgument='<%# ((Entry)Container.DataItem).Id %>' />
	        </td>
		    <td>
			    <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# DataBinder.Eval(Container.DataItem, "FullyQualifiedUrl") %>' ToolTip="View Entry" >
		            <%# DataBinder.Eval(Container.DataItem, "Title") %></asp:HyperLink>
		    </td>
		    <td>
			    <%# IsActiveText(Container.DataItem)%>
		    </td>
		    <td>
			    <%# UIText.NiceDateString(((Entry)Container.DataItem).DateCreated) %>
		    </td>				
		    <td>
		        <%# string.Format("{0} / {1}", ((Entry)Container.DataItem).FeedBackCount, ((EntryStatsView)Container.DataItem).WebCount)%>
		    </td>				
			<% if (false)
            { %>			
			<td>
				<a href="../Referrers.aspx?EntryID=<%# Eval("Id") %>" title="View Referrals">
				    <%= UIText.GetSafeText("VSite", "Link_View_Text", string.Empty)%>
				</a>
			</td>
			<% } %>
		    <td>
			    <a href="Edit.aspx?PostId=<%# Eval("Id") %>" title="Edit Post">
			        <%= UIText.GetSafeText("VSite" , "Link_Edit_Text" , string.Empty )  %>
			    </a>
		    </td>
	    </tr>
	</AlternatingItemTemplate>
	<FooterTemplate>
	    </tbody>
		</table>
	</FooterTemplate>
</asp:Repeater>
<div class="innerBox" style="padding:10px 10px 10px 25px;">
    <p id="NoMessagesLabel" runat="server" visible="false">您还未发表文章，<a href='<%= UrlHelper.GetAddPostUrl() %>' title='<%= UIText.GetSafeText("Label_AddPost_Text") %>'><%= UIText.GetSafeText("Label_AddPost_Text") %></a> </p>
    <st:PagingControl id="resultsPager" runat="server"  PrefixText="<div>页码：</div>" LinkFormatActive='<a href="{0}" class="Current">{1}</a>' UrlFormat="Default.aspx?pg={0}" CssClass="Pager" />
    <div class="clearfix"></div>
</div>