<%@ Control Language="C#" EnableTheming="false"  AutoEventWireup="True" Codebehind="EntryEditor.ascx.cs" Inherits="EnjooSite.Web.Admin.UserControls.EntryEditor"%>
<%@ Register TagPrefix="FTB" Namespace="FreeTextBoxControls" Assembly="FreeTextBox" %>
<%@ Register TagPrefix="ANW" Namespace="EnjooSite.Web.Admin.WebUI" Assembly="EnjooSite.Web" %>
<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>
<%@ Register TagPrefix="st" Src="~/Admin/UserControls/EntriesList.ascx" TagName="EntriesList" %>
<%@ Import Namespace = "EnjooSite.Web.Admin" %>
<%@ Import Namespace = "EnjooSite.Web.UI" %>


<asp:ScriptManagerProxy  ID="ScriptManagerProxy1" runat="server">
    <Scripts>
        <asp:ScriptReference Path="~/Scripts/Admin/ajaxHelper_PostEdit.js" />
        <asp:ScriptReference Path="~/Common/Scripts/swfObject/swfobject_2.1.js" />
        <asp:ScriptReference Path="~/Common/Scripts/swfupload/swfupload_2.2b.js" />
    </Scripts>
    <Services>
        <asp:ServiceReference Path="~/WebServices/Admin/AjaxHelper.asmx" />
    </Services>
</asp:ScriptManagerProxy>

<ANW:MessagePanel id="Messages" runat="server" />

    <script type="text/javascript">

        var currentFCKEditorInstanceId = '<%= richTextEditor.ClientID %>';
    
        var _postButtonClientID = '<%= lkbPost.ClientID %>';
        var _postDateID = '<%= txtPostDate.ClientID %>';
        var _currentLanguage = '<%= Config.Language.ToLower() %>';
        var _tagTooltip = '<%= UIText.GetSafeText("VSite","Label_TagTooltip_Text",string.Empty) %>';
        var _systemTagTooltip = '<%= UIText.GetSafeText("VSite","Label_SystemTagTooltip_Text",string.Empty) %>';
        var _currentBlogRootURL = '<%= Config.CurrentBlog.RootUrl %>';
        var _currentSystemRootURL = '<%= VirtualPathUtility.ToAbsolute("~/Tag/") %>';        
        var _postVoteEndDateTextBox = '<%= PostVoteEndDateTextBox.ClientID %>';        
        var _systemTagsTextBoxClientID = "<%= SystemTagsTextBox.ClientID %>";

        function checkFCKEditor(source, arguments) {
            var oEditor = FCKeditorAPI.GetInstance('<%= string.Format("{0}_richTextEditor",richTextEditor.ClientID) %>');
            //жǷΪ 
            if (oEditor.GetXHTML(true) == "") {
                arguments.IsValid = false;
            } else {
                arguments.IsValid = true;
            }
        }
        function getXHTML(){
            var editor = FCKeditorAPI.GetInstance('<%= string.Format("{0}_richTextEditor",richTextEditor.ClientID) %>');
            editor.InsertHtml("V.Enjoy");
            
            $("img", $(editor.EditorDocument)).each(function(index){
                alert( $(this).attr("src"));
            })
        }
        
//        $(function(){
//            var editor = FCKeditorAPI.GetInstance('<%= string.Format("{0}_richTextEditor",richTextEditor.ClientID) %>');
////            OnPaste 
////            OnFocus 
////            OnSelectionChange 
////            OnAfterSetHTML
        //        })

        $(function() {
            //$("#"+_eventDateID).datepicker($.extend({}, $.datepicker.regional["zh-CN"], {dateFormat:"yy-mm-dd"}));  

            $("#PostTabs>li>a").click(function(e) {
                $("#PostTabs>li").removeClass("current");
                $("#PostTabs_Content>div[id^=fragment]").hide();
                $(this).parent().addClass("current");
                $($(this).attr("href")).show();
                if ($(this).attr("href") != "#fragment-1") {
                    $("#fitWindowLink").parent().hide();
                } else {
                    $("#fitWindowLink").parent().show();
                }
                if ($(this).attr("href") == "fragment-3") {
                    autoCheckImages();
                }
                return false;
            });
            $("#" + _postDateID).click(function() {
                WdatePicker({ lang: _currentLanguage, dateFmt: 'yyyy-MM-dd HH:mm' });
            });

            $("input.date").click(function() {
                WdatePicker({ lang: _currentLanguage, dateFmt: 'yyyy-MM-dd' });
            })

            //  Tags
            bindTagLinkEvent();
            $(":text", $("ul.tagCloud").parent()).each(function() {
                updateTagsCloud($(this));
            })

            $(":text", $("ul.tagCloud").parent()).blur(function() {
                updateTagsCloud($(this));
            })

            //  ϢǰTags׷Bodyβ
            $("#" + _postButtonClientID).click(function() {

                var editor = FCKeditorAPI.GetInstance('<%= string.Format("{0}_richTextEditor",richTextEditor.ClientID) %>');
                //  Blogǩ
                var tagsString = $("#" + _tagsTextBoxClientID).val().trim();
                //  ϵͳǩ
                var systemTagsString = $("#" + _systemTagsTextBoxClientID).val().trim();

                //  Blogǩ
                if (tagsString != "") {
                    var tagsList = tagsString.split(",");
                    if (tagsList.length > 0) {
                        var tagContainer = $("#postTagsContainer", $(editor.EditorDocument));
                        if (tagContainer.size() > 0) {
                            tagContainer.empty();
                        } else {
                            $("body", $(editor.EditorDocument)).append("<div id=\"postTagsContainer\"></div>");
                            tagContainer = $("#postTagsContainer", $(editor.EditorDocument));
                        }

                        tagContainer.append("<label>" + _tagTooltip + "</label>");
                        for (var i = 0; i < tagsList.length; i++) {
                            if (tagsList[i] != "") {
                                tagContainer.append("<a href=\"" + _currentBlogRootURL + "Tags/" + encodeURI(tagsList[i]) + "/default.aspx\" rel=\"tag\">" + tagsList[i] + "</a>&nbsp;&nbsp;");
                            }
                        }
                    }
                } else {
                    $("#postTagsContainer", $(editor.EditorDocument)).remove();
                }

                //  ϵͳǩ
                if (systemTagsString != "") {
                    var systemTagsList = systemTagsString.split(",");
                    if (systemTagsList.length > 0) {
                        var systemTagContainer = $("#postSystemTagsContainer", $(editor.EditorDocument));
                        if (systemTagContainer.size() > 0) {
                            systemTagContainer.empty();
                        } else {
                            $("body", $(editor.EditorDocument)).append("<div id=\"postSystemTagsContainer\"></div>");
                            systemTagContainer = $("#postSystemTagsContainer", $(editor.EditorDocument));
                        }

                        systemTagContainer.append("<label>" + _systemTagTooltip + "</label>");
                        for (var i = 0; i < systemTagsList.length; i++) {
                            if (systemTagsList[i] != "") {
                                systemTagContainer.append("<a href=\"" + _currentSystemRootURL + encodeURI(systemTagsList[i]) + "/default.aspx\" rel=\"systemTag\">" + systemTagsList[i] + "</a>&nbsp;&nbsp;");
                            }
                        }
                    }
                } else {
                    $("#postSystemTagsContainer", $(editor.EditorDocument)).remove();
                }
            })

        })
                
        function bindTagLinkEvent(){        
            $("ul.tagCloud a").unbind();
            $("ul.tagCloud a").bind("click",function(){
                $(this).toggleClass("tag-style-selected");
                updateTagsTextBox($(this));
                return false;            
            });
            
            $("span.restoreTag").click(function(){
                var tagTextBox = $(":text",$(this).parent().parent());
                tagTextBox.val( tagTextBox.attr("tags"));
                updateTagsCloud( tagTextBox );
            })
        }
        
        function updateTagsCloud(sender){
            var currentTextBox = sender;
            $("a",currentTextBox.parent().parent()).removeClass("tag-style-selected");
            var newTags = currentTextBox.val().split(",");
            if( newTags.length > 0 ){
                for(var i=0;i<newTags.length;i++){
                    var _contains =  $("a:contains('" + newTags[i] + "')",currentTextBox.parent().parent());
                    var hasTag = false;
                    if( _contains.size() > 0 ){
                        _contains.each(function(index){
                            var currentTagLink = $(this);
                            if( currentTagLink.text() == newTags[i]){
                                hasTag = true;
                                currentTagLink.addClass("tag-style-selected");
                            }
                        })
                    }
                    if( hasTag == false){
                        $("<li><a class='tag-style-selected tag-style-1'  href='#'>"+newTags[i] + "</a></li>").appendTo( $("ul.tagCloud",currentTextBox.parent().parent()));
                        bindTagLinkEvent();
                    }
                }
            }        
        }
        
        var _tagsTextBoxClientID = "<%= TagsTextBox.ClientID %>";
        function updateTagsTextBox(sender){
            var _tagsTextBox = $(":text",sender.parent().parent().parent());
            _tagsTextBox.val("");
            
            var tagsList = new Array();
            $("a.tag-style-selected",sender.parent().parent()).each(function(index){
                tagsList.push( $(this).text());              
            })
            
            _tagsTextBox.val( tagsList.toString());
        }
        
        
        function FCKeditor_OnComplete( editorInstance )
        {
            //  editorInstance.Events.AttachEvent( 'OnSelectionChange', autoCheckImages ) ;

        }

        function autoCheckImages( editorInstance){
            var editor = FCKeditorAPI.GetInstance('<%= string.Format("{0}_richTextEditor",richTextEditor.ClientID) %>');
            if( !editorInstance ){
                editorInstance = editor;
            }
            $("#autoImageBox").empty();
            
            $("img",$(editorInstance.EditorDocument)).each(function(index){
                $("<div style='width:120px;height:120px;overflow:hidden;'><input type='radio' name='postThumbnail' /><img width='120'  src='" + $(this).attr("src") + "' /></div>").appendTo($("#autoImageBox"));
                $("img[src$='spacer.gif']", $("#autoImageBox")).parent().hide();
            })
            
            if( $("img", $("#autoImageBox")).size() > 0 ){
                $(":radio", $("#autoImageBox")).click(function(){
                    $("#autoImageTextBox").val( $(this).next().attr("src"));
                });
            }else{
                $("#autoImageTextBox").val("");
            }
            
        }
    </script>

        <div class="enjoosite_tabs clearfix" style="background-color: Transparent;">
            <div class="enjoosite_tabs_bottomline" style="z-index:-1;"></div>
            <ul id="PostTabs" class="enjoosite_tabs_tab_container vList clearfix" style="margin:0 0 0 10px;">
                <li class="enjoosite_tabs_tab current">
                    <a href="#fragment-1"><span><%= UIText.GetSafeText("SiteMenu","Label_BasicInfo_Text",string.Empty) %></span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a  href="#fragment-2"><span><%= UIText.GetSafeText("SiteMenu" , "Label_AdvancedOptions_Text" , string.Empty )  %></span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-3"><span>
                        <%= UIText.GetSafeText("SiteMenu", "Label_PostHotImage_Text" , string.Empty )  %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-4"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_MyTags_Text",string.Empty)  %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-8"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_SystemTags_Text",string.Empty)  %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-5"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_PostToChannel_Text",string.Empty ) %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-6"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_PostVote_Text",string.Empty ) %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-7"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_PostDebate_Text",string.Empty ) %>
                    </span></a>
                </li>
                <li class="enjoosite_tabs_tab">
                    <a href="#fragment-9"><span>
                        <%= UIText.GetSafeText("SiteMenu","Label_PostQuestion_Text",string.Empty ) %>
                    </span></a>
                </li>
            </ul>   
        </div>
        
        <div id="PostTabs_Content" style="margin:20px;padding-bottom:50px;">
            <div id="fragment-1">
            
	            <% if (PostID != null) { %>
		            <p class="Label"><asp:HyperLink id="hlEntryLink" Runat="server" /></p>
		        <% } %>
		        <div class="hSpace_10"></div>
		
                    
		        <label for="Editor_Edit_txbTitle">
		            <%= UIText.GetSafeText("SiteMenu","Label_PostTitle_Text",string.Empty ) %>
		            <asp:RequiredFieldValidator id="valTitleRequired" runat="server" ControlToValidate="txbTitle" ForeColor="#ff0000" ErrorMessage="ⲻΪա" />
		        </label>
		        <asp:TextBox id="txbTitle" runat="server" CssClass="inline_text" MaxLength="250" />
        		<br />
        		
		        <label for="Editor_Edit_richTextEditor">
		            <%= UIText.GetSafeText("SiteMenu","Label_PostBody_Text",string.Empty ) %>
		            <asp:CustomValidator ClientValidationFunction="checkFCKEditor" ControlToValidate="richTextEditor" ValidateEmptyText="true" ID="CustomValidator1" runat="server" ForeColor="#ff0000" ErrorMessage="ݲΪա"></asp:CustomValidator>
		        </label>
        		<div class="clearfix">
		            <st:RichTextEditor id="richTextEditor" runat="server" onerror="richTextEditor_Error" ToolbarSet="Simply" Height="300"  />
		        </div>
		        <div class="hSpace_10"></div>
		        <div id="attachToolbarContainer" class="grayBox" style="width:690px;">
		            <ul class="vList clearfix menuButtons">
		                <li>
		                    <label>¸</label>
		                </li>
		                <li>		                    
		                    <a href="#" class="attach" id="attachFileLinkButton"><span><div id="swfUploadPlaceHolder""></div></span></a>
		                </li>
		                <li>
		                    <a href="#" class="attach" id="attachFileFromNetDiskLinkButton"><span style="padding:0 10px 0 20px;">Ӳ̲</span></a>
		                </li>
		            </ul>
		            <ul id="attachFilesContainer" class="enjooSite_uploadProgressBox">
		                <asp:Repeater ID="AttachFilesRepeater" runat="server">
		                    <ItemTemplate>
                                <li class="uploadProgress" commandArgument='<%# Eval("FileId") %>'>
                                    <div class="uploadProgress_inner">
                                    </div>
                                    <ul class="uploadProgress_info vList clearfix waitting" style='<%# string.Format("background-image:url({0})",Eval("SmallIconUrl")) %>'>
                                        <li><a href='<%# VirtualPathUtility.ToAbsolute(string.Format("~/Attachment/{0}.ashx",Eval("FileId"))) %>'><span><%# string.Format("{0}", Eval("FileNameWithExtension")) %></span></a><span><%# Eval("FileSizeFormatString") %></span></li>
                                        <li class="action"><span>---</span></li>
                                    </ul>
                                    <ul class="deleteToolbar vList" style="display:block;">
                                        <li><a href="#" commandArgument='<%# Eval("FileId") %>'><span>ɾ</span></a></li>
                                    </ul>
                                    <ul class="insertImageToolbar vList" style='<%# ((NetFile)Container.DataItem).IsWebImage==true?"display:block;":"display:none;" %>'>
                                        <li><a href="#" commandName="insertImage" commandArgument='<%# Eval("FileId") %>'><span>ͼ</span></a></li>
                                    </ul>
                                </li>
		                    </ItemTemplate>
		                </asp:Repeater>
		            </ul>		            
		            
                    <div id="addAttachFileFromNetDisk_Container" style="display:none;">
                        <div class="container_12" style="width:540px;">
                            <div class="grid_2" style="margin-left:0;">
                                <div id="folderMenuContainer">
                                    <ul id="netDiskDirectoriesTree" class="menutree">
                                    </ul>
                                </div>
                            </div>
                            <div class="grid_5" style="margin-left:-1px;border-left:1px solid #dcdcdc;">
                                <a href="#" id="addCheckedAttachFilesLink" style="margin:0 0 0 10px;"><span>ѡ</span></a>
                                <div id="netFilesTemplate" style="height:450px;overflow:auto;"><ul class="clearfix list"></ul></div>
                            </div>
                        </div>
                    </div>
    
		            <div id="resultBox" style="display:none;"></div>
		        </div>
        		<br />        		
		        <label>
		            <%= UIText.GetSafeText("SiteMenu","Label_PostCategory_Text",string.Empty ) %>
		        </label>
		        <div>
		        <asp:DropDownList ID="ddlCategories" runat="server" ></asp:DropDownList>
		        </div>
            
            </div>
            
            <div id="fragment-2" style="display:none;">
                <table cellpadding="4">
			        <tr>
				        <td width="200">
				            <asp:CheckBox id="ckbPublished" runat="server" Text="<%$ Resources:VSite,Label_Published_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
				        <td width="200">
				            <asp:CheckBox id="chkComments" runat="server" Text="<%$ Resources:VSite,Label_ShowComments_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>	
				        <td width="200">
				            <asp:CheckBox id="chkCommentsClosed" runat="server" Text="<%$ Resources:VSite,Label_CommentsClosed_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
				        <td width="200">
				            <asp:CheckBox id="chkDisplayHomePage" runat="server" Text="<%$ Resources:VSite,Label_DisplayOnHomePage_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
			        </tr>
			        <tr>
				        <td>
				            <asp:CheckBox id="chkMainSyndication" runat="server" Text="<%$ Resources:VSite,Label_SyndicateOnMainFeed_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
				        <td>
				            <asp:CheckBox id="chkSyndicateDescriptionOnly" runat="server" Text="<%$ Resources:VSite,Label_SyndicateDescriptionOnly_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
				        <td>
				            <asp:CheckBox id="chkIsAggregated" runat="server" Text="<%$ Resources:VSite,Label_IncludeInAggregatedSite_Text %>" textalign="Right" CssClass="checkbox" />
				        </td>
				        <td>
				            <asp:CheckBox id="chkIsTop" runat="server" Text="<%$ Resources:VSite,Label_IsTop_Text %>" TextAlign="Right" CssClass="checkbox" />
				        </td>
			        </tr>
		        </table>
		        <br />
		        
		        <div id="advanced-options">
        		
		            <label for="Editor_Edit_txtPostDate">
		                <%= UIText.GetSafeText("VSite","Label_PostDate_Text",string.Empty ) %>
		                <asp:CustomValidator ID="vCustomPostDate" runat="server" Text="Invalid PostDate format. Must be a valid date/time expression" ControlToValidate="txtPostDate" />
		            </label> 
		            <asp:TextBox ID="txtPostDate" runat="server" CssClass="date inline_text" MaxLength="25" /> 
		               
        		    <br />
		            <label for="Editor_Edit_txbEntryName">
		                <%= UIText.GetSafeText("VSite","Label_EntryName_Text" , string.Empty ) %>
		                <asp:RegularExpressionValidator ID="vRegexEntryName" ControlToValidate="txbEntryName" ValidationExpression="^([a-zA-Z0-9-\.]*([a-zA-Z0-9-_]+\.)*[a-zA-Z0-9-_]+)$" Text = "<%$ Resources:VSite,Label_InvalidEntryName_Text %>" runat="server"/>
		            </label>
		            <asp:TextBox id="txbEntryName" runat="server" CssClass="inline_text" MaxLength="150" />
        		    
        		    <br />
		            <label for="Editor_Edit_txbExcerpt">
		                <%= UIText.GetSafeText("VSite","Label_PostExcerpt_Text" , string.Empty ) %>
		                <span style="color:#dcdcdc;">
		                    <%= string.Format("({0})", UIText.GetSafeText("VSite","Label_PostExcerpt_Tooltip",string.Empty)) %>
		                </span>
		            </label>
		            <asp:TextBox id="txbExcerpt" runat="server" rows="5" textmode="MultiLine" CssClass="textbox inline_text" MaxLength="500" />
        		    
		        </div>
            
            </div>
            
            <div id="fragment-3" style="display:none;">
            
		        <h5>
		            <%= UIText.GetSafeText("VSite","Label_PostImages_Text",string.Empty ) %>
		        </h5>
		        <div style="width:500px;line-height:150%;margin:10px 0;">
		            <%= UIText.GetSafeText("VSite", "Label_PostImages_Tooltip" , string.Empty ) %>
		        </div>
		        <input type="hidden" id="autoImageTextBox" name="autoImageTextBox" />
	            <div id="autoImageBox" class="clearfix" style="padding:10px;">        	        
	            </div>
            </div>
            
            <div id="fragment-4" style="display:none;">
                <label>
                    <span class="restoreTag" title='<%= UIText.GetSafeText("VSite","Label_RestoreTag_Text",string.Empty) %>' style="display:none;"></span>
                    <%= UIText.GetSafeText("VSite","Label_Tags_Text" , string.Empty ) %>
                    (
                        <%= UIText.GetSafeText("VSite","Label_Tags_Tooltip",string.Empty) %>
                    )
                </label>
                <div>
                    <asp:TextBox ID="TagsTextBox" runat="server" CssClass="inline_text"></asp:TextBox>
                </div>
                <div class="hSpace_10"></div>
            	<asp:Repeater Runat="server" ID="Tags" OnItemDataBound="Tags_ItemDataBound">
		            <HeaderTemplate>
				        <ul id="tag-cloud" class="tagCloud">
		            </HeaderTemplate>
		            <ItemTemplate>
			            <li>
				            <asp:HyperLink  Runat="server" ID="TagUrl" CssClass='<%# Eval("Weight", "tag-style-{0} tag-item") %>' Text='<%# Eval("TagName") %>' ToolTip='<%# Eval("TagName") + " (" + Eval("Count") + ")" %>'/>
			            </li>
		            </ItemTemplate>
		            <FooterTemplate>
			            </ul>
		            </FooterTemplate>
	            </asp:Repeater>
            </div>
            
            <div id="fragment-8" style="display:none;">
                <% if (SecurityHelper.IsHostAdmin)
                   { %>    
                    <div style="margin:0 0 10px 0;">
                <% }
                   else
                   { %>   
                   <div style="display:none;">
                <% } %> 
                    <asp:TextBox ID="SystemTagsTextBox" runat="server" CssClass="inline_text"></asp:TextBox>
                </div>  
                
            	<asp:Repeater Runat="server" ID="SystemTags" OnItemDataBound="SystemTags_ItemDataBound">
		            <HeaderTemplate>
				        <ul id="systemTag-cloud" class="tagCloud">
		            </HeaderTemplate>
		            <ItemTemplate>
			            <li>
				            <asp:HyperLink  Runat="server" ID="TagUrl" CssClass='<%# Eval("Weight", "tag-style-{0} tag-item") %>' Text='<%# Eval("TagName") %>' ToolTip='<%# Eval("TagName") + " (" + Eval("Count") + ")" %>'/>
			            </li>
		            </ItemTemplate>
		            <FooterTemplate>
			            </ul>
		            </FooterTemplate>
	            </asp:Repeater>
            </div>
            
            <div id="fragment-5" style="display:none;">
            
		        <br />
		        <asp:DropDownList ID="ddlChannels" runat="server"></asp:DropDownList>
		        
		        <label for="<%= IsDisplayAuthorCheckBox.ClientID %>" style="display:none;">
		            <%= UIText.GetSafeText("VSite","Label_IsDisplayAuthorCheckBox_Text", string.Empty ) %>
		        </label>
		        <asp:CheckBox ID="IsDisplayAuthorCheckBox" runat="server" Visible="false" />
            </div>
            
            <div id="fragment-6" style="display:none;">
                <label>
                    <%= UIText.GetSafeText("SiteMenu","Label_PostVote_Text",string.Empty) %>
                    <%= string.Format("({0})", UIText.GetSafeText("VSite","Label_PostVote_Tooltip",string.Empty )) %>
                </label>
                <div style="width:350px;margin:10px 0;">
                    <%= UIText.GetSafeText("VSite","Label_PostVote_Note",string.Empty ) %>
                </div>
                <asp:TextBox TextMode="MultiLine" ID="PostVoteTextBox" runat="server" width="350" Rows="10"  CssClass="inline_text"></asp:TextBox>
                <br />
                <ul>
                    <li>
                        <span>
                            <%= UIText.GetSafeText("VSite","Label_MaxChoose_Text",string.Empty ) %>
                            <asp:TextBox ID="PostVoteChooseNumberTextBox" runat="server" Width="50" Text="1"  CssClass="inline_text"></asp:TextBox>
                            <asp:RangeValidator ID="RangeValidator1" ControlToValidate="PostVoteChooseNumberTextBox" runat="server" ErrorMessage="*" Text="*" MinimumValue="1" MaximumValue="10"  Display="Dynamic" Type="Integer"></asp:RangeValidator>
                        </span>
                    </li>
                    <li>
                        <%= UIText.GetSafeText("VSite","Label_VoteEndDate_Text",string.Empty ) %>
                        <asp:TextBox ID="PostVoteEndDateTextBox" runat="server" Width="150" CssClass="date inline_text"></asp:TextBox>
                    </li>
                    <li>
                        <%= UIText.GetSafeText("VSite","Label_CanViewPostVote_Text",string.Empty ) %>
                        <br />
                        <asp:CheckBox ID="CanViewPostVoteCheckBox" runat="server" Checked="true" />
                    </li>
                </ul>
            </div>
            
            <div id="fragment-7" style="display:none;">
                <label>
                    <%= UIText.GetSafeText("SiteMenu", "Label_PostDebate_Text", string.Empty)%>
                    <%= string.Format("({0})", UIText.GetSafeText("VSite", "Label_PostDebate_Tooltip", string.Empty))%>
                </label>
                <div style="width:350px;margin:10px 0;">
                    <%= UIText.GetSafeText("VSite","Label_PostDebated_Note",string.Empty ) %>
                </div>                
                <table border="0" cellpadding="0" cellspacing="20">
                    <tr>
                        <th>
                            <%= UIText.GetSafeText("VSite","Label_DebateRight_Text",string.Empty ) %>
                        </th>
                        <th>
                            <%= UIText.GetSafeText("VSite","Label_DebateLeft_Text",string.Empty ) %>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="PostDebateRightTextBox" runat="server" TextMode="MultiLine" Rows="5" Width="200"  CssClass="inline_text"></asp:TextBox>
                        </td>
                        <td>
                            <asp:TextBox ID="PostDebateLeftTextBox" runat="server" TextMode="MultiLine" Rows="5" Width="200"  CssClass="inline_text"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <%= UIText.GetSafeText("VSite","Label_DebateEndDate_Text",string.Empty ) %>
                            <br />
                            <asp:TextBox ID="PostDebateEndDateTextBox" runat="server" Width="150" CssClass="date inline_text"></asp:TextBox>
                        </td>
                    </tr>
                </table>
            </div>
                    
            <div id="fragment-9" style="display:none;">
            
                <label>
                    <%= UIText.GetSafeText("SiteMenu", "Label_PostQuestion_Text", string.Empty)%>
                </label>
                <div style="width:450px;margin:10px 0;">
                    <%= UIText.GetSafeText("VSite","Label_PostQuestion_Note",string.Empty ) %>
                </div>  
                <asp:TextBox ID="PostQuestionTextBox" TextMode="MultiLine" runat="server" Width="350" Rows="10" CssClass="inline_text"></asp:TextBox>                
                
                <br />
                <br />
                <label>
                    <%= UIText.GetSafeText("VSite", "Label_PostValue_Text", string.Empty)%>
                    <%= string.Format("({0})", UIText.GetSafeText("VSite", "Label_PostValue_Tooltip", string.Empty))%>
                </label>
                <div style="width:450px;margin:10px 0;">
                    <%= string.Format( UIText.GetSafeText("VSite","Label_BlogSavings_Text" , string.Empty ) , Config.CurrentBlog.Fortune ) %>
                    <asp:RangeValidator ID="PostValueRangeValidator" ControlToValidate="PostValueTextBox" runat="server" ErrorMessage="<br />ǰֲ㣡"  MinimumValue="0" MaximumValue='<%= Config.CurrentBlog.Fortune %>'  Display="Dynamic" Type="Integer"></asp:RangeValidator>
                </div>
                <asp:TextBox ID="PostValueTextBox" runat="server" Width="50" Text="10" CssClass="inline_text"></asp:TextBox>
                <br />
                <%= UIText.GetSafeText("VSite","Label_PostQuestionIsClosing_Text",string.Empty ) %>
                <br />
                <asp:CheckBox ID="PostQuestionIsClosing" runat="server" Checked="false" />
                
            </div>
            
            <div class="hSpace_10"></div>
            <div class="hSpace_10"></div>
			<asp:Button id="lkbPost" runat="server" CssClass="buttonSubmit" Text="<%$ Resources:VSite,Button_Yes_Text %>"  />
			<asp:Button id="lkUpdateCategories" runat="server" CssClass="buttonSubmit" CausesValidation="false" Text="<%$ Resources:VSite,Button_UpdateCategories_Text %>" Visible="false" />
			<asp:Button id="lkbCancel" runat="server" CssClass="buttonSubmit" CausesValidation="false" Text="<%$ Resources:VSite,Button_Cancel_Text %>" />
			<input type="text" id="postAttachFilesTextBox"  name="postAttachFilesTextBox" style="display:none;" />
		
		</div>

	<ANW:AdvancedPanel Visible="false" id="Enclosure" runat="server" LinkStyle="Image" LinkBeforeHeader="True" DisplayHeader="True" HeaderCssClass="CollapsibleHeader" LinkText="[toggle]" Collapsible="False" Collapsed="True" HeaderText="Enclosure" BodyCssClass="Edit">
        <div id="messagePanelContainer" style="display: none;">
            <div id="messagePanelWrapper">
                <div id="messagePanel" style="display: none;">
                </div>
            </div>
        </div>
        <div id="enclosure-editor">
	    <fieldset title="Enclosure">
		    <legend>Basic Enclosure</legend>
	        <label for="Editor_Enclosure_txbEnclosureTitle" accesskey="e"><u>E</u>nclosure Title</label>
            <asp:TextBox id="txbEnclosureTitle" runat="server" MaxLength="250" />
            <label for="Editor_Enclosure_txbEnclosureUrl" accesskey="u">Enclosure <u>U</u>rl&nbsp;<asp:RequiredFieldValidator id="valEncUrlRequired" runat="server" ControlToValidate="txbEnclosureUrl" ForeColor="#990066" ErrorMessage="Url is required" Display="Dynamic" /> <asp:RegularExpressionValidator ControlToValidate="txbEnclosureUrl" id="valEncUrlFormat" runat="server" ForeColor="#990066" ErrorMessage="Not a valid Url." ValidationExpression="^(https?://)?([\w-]+\.)+[\w-]+([\w-./?%&=:]*)?$"></asp:RegularExpressionValidator> </label>
            <asp:TextBox id="txbEnclosureUrl" runat="server" MaxLength="250" />
            <label for="Editor_Enclosure_txbEnclosureSize" accesskey="s">Enclosure <u>S</u>ize (in bytes) &nbsp;<asp:RequiredFieldValidator id="valEncSizeRequired" runat="server" ControlToValidate="txbEnclosureSize" ForeColor="#990066" ErrorMessage="Size is required" Display="Dynamic" /><asp:RangeValidator ControlToValidate="txbEnclosureSize" MinimumValue="0" MaximumValue="999999999" id="valEncSizeFormat" runat="server" ForeColor="#990066"  Type="Integer" ErrorMessage="Not a valid size." ></asp:RangeValidator></label>
            <asp:TextBox id="txbEnclosureSize" runat="server" MaxLength="250" />
            <label for="Editor_Enclosure_ddlMimeType" accesskey="m">Enclosure <u>M</u>imetype&nbsp;<asp:CompareValidator Operator="NotEqual" ValueToCompare="none" id="valEncMimeTypeRequired" runat="server" ControlToValidate="ddlMimeType" ForeColor="#990066" ErrorMessage="MimeType is required." /></label>
            <asp:DropDownList ID="ddlMimeType" runat="server">
            </asp:DropDownList> <asp:TextBox id="txbEnclosureOtherMimetype" CssClass="othertype" runat="server" MaxLength="25" />&nbsp;<asp:RequiredFieldValidator id="valEncOtherMimetypeRequired" runat="server" ControlToValidate="txbEnclosureOtherMimetype" ForeColor="#990066" ErrorMessage="You have to specify a custom mimetype." />
            <label for="Editor_Enclosure_ddlDisplayOnPost" accesskey="p">Display with <u>P</u>ost on website</label>
            <asp:DropDownList ID="ddlDisplayOnPost" runat="server">
                <asp:ListItem Value="true">Yes</asp:ListItem>
                <asp:ListItem Value="false">No</asp:ListItem>
            </asp:DropDownList>
            <label for="Editor_Enclosure_ddlAddToFeed" accesskey="f">Add to <u>F</u>eed</label>
            <asp:DropDownList ID="ddlAddToFeed" runat="server">
                <asp:ListItem Value="true">Yes</asp:ListItem>
                <asp:ListItem Value="false">No</asp:ListItem>
            </asp:DropDownList>
        </fieldset>
        </div>
	</ANW:AdvancedPanel>
	

<script type="text/javascript">

        /* ---- { a few global variables } ---- */
        var msgPanel = $('#messagePanel');
        var msgPanelWrap = msgPanel.parent();

        function ValidatorEnclosureEnable(enabled)
        {
            ValidatorEnable($("#<%= valEncUrlRequired.ClientID %>")[0], enabled);
            ValidatorEnable($("#<%= valEncSizeRequired.ClientID %>")[0], enabled);
            ValidatorEnable($("#<%= valEncMimeTypeRequired.ClientID %>")[0], enabled);
            ValidatorEnable($("#<%= valEncOtherMimetypeRequired.ClientID %>")[0], enabled);
        }

        function toggleOtherMimeType(elem)
        {
            if(elem != undefined) 
            {
                if(elem.value == "other")
                {
                    $("#<%= txbEnclosureOtherMimetype.ClientID %>").show();
                    ValidatorEnable($("#<%= valEncOtherMimetypeRequired.ClientID %>")[0], true);
                }
                else
                {
                    $("#<%= txbEnclosureOtherMimetype.ClientID %>").hide();
                    ValidatorEnable($("#<%= valEncOtherMimetypeRequired.ClientID %>")[0], false);
                }
            }
        }
        
        function enclosureEnabled()
        {

            if( $("#<%= txbEnclosureTitle.ClientID %>").val() != "")
            {
                return true;
            }
            if( $("#<%= txbEnclosureUrl.ClientID %>").val() != "")
            {
                return true;
            }
            if( $("#<%= txbEnclosureSize.ClientID %>").val() != "")
            {
                return true;
            }
            if( $("#<%= ddlMimeType.ClientID %>").val() != "none")
            {
                return true;
            }
            return false;
        }
        
        function toggleEnclosureBox()
        {
            if($("#<%= txbEnclosureTitle.ClientID %>").length==1)
            {
                if(enclosureEnabled())
                {
                    ValidatorEnclosureEnable(true);
                }
                else
                {
                    ValidatorEnclosureEnable(false);
                }
                toggleOtherMimeType($("#<%= ddlMimeType.ClientID %>")[0]);
            }
        }
        
        function setupChangeHandlers()
        {
            $("#<%= txbEnclosureTitle.ClientID %>").change(toggleEnclosureBox);
            $("#<%= txbEnclosureUrl.ClientID %>").change(toggleEnclosureBox);
            $("#<%= txbEnclosureSize.ClientID %>").change(toggleEnclosureBox);
            $("#<%= ddlMimeType.ClientID %>").change(toggleEnclosureBox);
        }

        // first let's hook up some events
        $(document).ready(function()
        {
            toggleEnclosureBox();

            $("#<%= ddlMimeType.ClientID %>").change(function() 
            {
                toggleOtherMimeType(this);
            });
            
            setupChangeHandlers();
            
            $("#<%= txbEnclosureUrl.ClientID %>").change(function()
            {
                var url = $("#<%= txbEnclosureUrl.ClientID %>").val();
                var requiredValidationPassed = $("#<%= valEncUrlRequired.ClientID %>")[0].style.display=="none";
                var formatValidationPassed = $("#<%= valEncUrlFormat.ClientID %>")[0].style.visibility=="hidden";

                if(url=="")
                {
                    $("#<%= txbEnclosureOtherMimetype.ClientID %>").val("");
                    $("#<%= ddlMimeType.ClientID %>").val("none");
                    toggleEnclosureBox();
                }

                if(requiredValidationPassed && formatValidationPassed)
                    {
                        hideMessagePanel();
                        ajaxServices.detectMimeType(url, function(response)
                        {
                            if(response.error)
                            {
                                handleError(response.error);
                            }
                            else
                            {
                                var mimetype = response.result;
                                if($("#<%= ddlMimeType.ClientID %> option").contents().is(":contains('"+mimetype+"')"))
                                {
                                    $("#<%= ddlMimeType.ClientID %>").val(mimetype);
                                    $("#<%= txbEnclosureOtherMimetype.ClientID %>").val("");
                                }
                                else
                                {
                                    $("#<%= ddlMimeType.ClientID %>").val("other");
                                    $("#<%= txbEnclosureOtherMimetype.ClientID %>").val(mimetype);
                                }
                                ValidatorValidate($("#<%= valEncMimeTypeRequired.ClientID %>")[0]);
                                toggleOtherMimeType($("#<%= ddlMimeType.ClientID %>")[0]);
                            }
                        });
                    }
            });
            
        });
       

        /* ---- { error handling methods } ---- */

        function handleError(error)
        {
            hideMessagePanel();
            msgPanelWrap.addClass("error");
            showMessagePanel(error.message);
        
            // available properties on error
            //error.errors -> [{error}, ...]
            //error.name
            //error.message
            //error.stackTrace
        }

        function showMessagePanel(message)
        {
            msgPanel.empty().append("<p>" + message + "</p>").fadeIn("slow");
        }
        
        function hideMessagePanel()
        {
            msgPanel.fadeOut();
            msgPanelWrap.removeClass("error").removeClass("warn").removeClass("info").removeClass("success");
        }
        

</script>