Type.registerNamespace('Templating');

Templating.Template = function Templating_Template(templateContainer) {

    this._templateContainer = templateContainer;
    if (!Templating.Template._regex) {
        Templating.Template._regex = new RegExp('([^\\{]*)\\{([^\\}]+)\\}', 'g');
    }
    var tokens = new Array();// [];
    var text = this._templateContainer.innerHTML.replace('\n', '').replace('%7B', '{').replace('%7D', '}');
    this._format = text.replace(Templating.Template._regex, Function.createDelegate(this, function(match) {
        var group1 = arguments[1];
        var group2 = arguments[2];
        if (group2.substr(0, 1) === '{') {
            return group1 + '{' + group2 + '}';
        }
        var parts = group2.split(':');
        Array.add(tokens, parts[0]);
        parts[0] = (tokens.length - 1).toString();
        return group1 + '{' + parts.join(':') + '}';
    }));
    var codeBuilder = new Sys.StringBuilder();
    codeBuilder.append('var container = document.createElement(\'div\');');
    codeBuilder.append('container.innerHTML = String.format(format');
    for (var i = 0; i < tokens.length; i++) {
        codeBuilder.append(', data.');
        codeBuilder.append(tokens[i]);
    }
    codeBuilder.appendLine(');');
    codeBuilder.appendLine('var element = null;');
    codeBuilder.appendLine('var itemContainer = $get(\'itemContainer\', container);');
    codeBuilder.appendLine('var children = itemContainer.childNodes;');
    codeBuilder.appendLine('for(var i = 0;i< children.length; i++) {');
    codeBuilder.appendLine('  if (children[i].nodeType == 1) { element = children[i]; break; }');
    codeBuilder.appendLine('}');
    codeBuilder.appendLine('if (element && callback) { callback(element, data, context); }');
    codeBuilder.appendLine('return element;');
    var templateCode = codeBuilder.toString();
    this._compiledTemplate = new Function('format', 'data', 'callback', 'context', templateCode);
}
Templating.Template.prototype = {
    _templateContainer: null,
    _format: null,
    _compiledTemplate: null,
    
    get_templateContainer: function Templating_Template$get_templateContainer() {
        /// <summary>
        /// The associated DOM element containing the template's markup.
        /// </summary>
        /// <value type="Object" domElement="true"></value>
        return this._templateContainer;
    },
    
    createInstance: function Templating_Template$createInstance(data, callback, context) {
        /// <summary>
        /// Creates an instance of a DOM element using the markup that defines the template.
        /// </summary>
        /// <param name="data" type="Object">
        /// Any data associated with the new DOM element.
        /// </param>
        /// <param name="callback" type="Templating.TemplateInstanceCallback">
        /// An optional callback invoked to allow the caller to customize the newly created element.
        /// </param>
        /// <param name="context" type="Object">
        /// An option context object passed in into the callback.
        /// </param>
        /// <returns type="Object" domElement="true"></returns>
        return this._compiledTemplate(this._format, data, callback, context);
    }
}


////////////////////////////////////////////////////////////////////////////////
// Templating.Repeater

Templating.Repeater = function Templating_Repeater(e) {
    /// <summary>
    /// A simple templated repeater control.
    /// </summary>
    /// <param name="e" type="Object" domElement="true">
    /// The associated DOM element, which contains an element with id set to itemContainer.
    /// </param>
    /// <field name="_itemContainer$2" type="Object" domElement="true">
    /// </field>
    /// <field name="_data$2" type="Array">
    /// </field>
    /// <field name="_template$2" type="Templating.Template">
    /// </field>
    Templating.Repeater.initializeBase(this, [ e ]);
    this._itemContainer$2 = Sys.UI.DomElement.getElementById('itemContainer', e);
}
Templating.Repeater.prototype = {
    _itemContainer$2: null,
    _data$2: null,
    _template$2: null,
    
    get_data: function Templating_Repeater$get_data() {
        /// <summary>
        /// The data being displayed in the Repeater control.
        /// </summary>
        /// <value type="Array"></value>
        return this._data$2;
    },
    set_data: function Templating_Repeater$set_data(value) {
        /// <summary>
        /// The data being displayed in the Repeater control.
        /// </summary>
        /// <value type="Array"></value>
        if (!this._data$2) {
            this._data$2 = value;
            return;
        }
        this._update$2(value);
        return value;
    },
    
    get_template: function Templating_Repeater$get_template() {
        /// <summary>
        /// The Template used to create items corresponding to rows of data.
        /// </summary>
        /// <value type="Object" domElement="true"></value>
        if (this._template$2) {
            return this._template$2.get_templateContainer();
        }
        return null;
    },
    set_template: function Templating_Repeater$set_template(value) {
        /// <summary>
        /// The Template used to create items corresponding to rows of data.
        /// </summary>
        /// <value type="Object" domElement="true"></value>
        this._template$2 = new Templating.Template(value);
        return value;
    },
    
    addDataItem: function Templating_Repeater$addDataItem(dataItem) {
        /// <summary>
        /// Adds a new row of data to the Repeater control.
        /// </summary>
        /// <param name="dataItem" type="Object">
        /// The new row of data.
        /// </param>
        if (this._template$2) {
            var itemElement = this._template$2.createInstance(dataItem, null, null);
            if (itemElement) {
                Array.add(this._data$2, dataItem);
                this._itemContainer$2.appendChild(itemElement);
            }
        }
    },
    
    _update$2: function Templating_Repeater$_update$2(data) {
        /// <param name="data" type="Array">
        /// </param>
        if ((!data) || (!data.length)) {
            this._itemContainer$2.innerHTML = '';
        }
        else {
            if (!this._template$2) {
                this._data$2 = Array.clone(data);
                return;
            }
            this._data$2 = [];
            var tagName = this._itemContainer$2.tagName;
            if ((window.navigator.userAgent.indexOf('MSIE') < 0) || ((tagName !== 'TABLE') && (tagName !== 'TBODY') && (tagName !== 'TR'))) {
                this._itemContainer$2.innerHTML = '';
            }
            else {
                for (var i = this._itemContainer$2.childNodes.length - 1; i >= 0; i--) {
                    this._itemContainer$2.removeChild(this._itemContainer$2.childNodes[i]);
                }
            }
            for (var i = 0; i < data.length; i++) {
                this.addDataItem(data[i]);
            }
        }
    }
}


Templating.Template.registerClass('Templating.Template');
Templating.Repeater.registerClass('Templating.Repeater', Sys.UI.Control);
Templating.Template._regex = null;

// ---- Do not remove this footer ----
// Generated using Script# v0.5.0.0 (http://projects.nikhilk.net)
// -----------------------------------
