﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="ChannelPosts.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.ChannelPosts" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript">
        var _checkLinkButtonClientID = '<%= CheckLinkButton.ClientID %>';
        var currentPath = '<%= VirtualPathUtility.ToAbsolute("~/HostAdmin/Frame_Main/ChannelPosts.aspx") %>';
        var currentChannelId = '<%= Request.QueryString["CategoryID"] %>';
        $(function() {
            parent.topFrame.hideAlert();
            _noneSelectedMessage = '<%= UIText.GetSafeText("VMessages","NoneSelected",string.Empty) %>';
            $("li[commandName=switchLinkConfig] label").bind("click", showLoading);
            $("li[commandName=switchLinkConfig] :radio").bind("click", showLoading);
            $("li[commandName=checkPosts]>a").bind("click", showLoading);
            $("div.pager a[class!=disabled]").bind("click", showLoading);
            $("a[commandName=return]").bind("click", showLoading);

            $("thead>tr>th :checkbox").click(function() {
                $("tbody>tr>td :checkbox").attr("checked", $(this).attr("checked"));
            });

            $("#" + _checkLinkButtonClientID).click(function() {
                var linkIds = new Array();

                var currentState = $("li[commandName=switchLinkConfig] input:checked").val();

                $("input:checked[commandName=changeState]").each(function(index) {
                    linkIds.push($(this).attr("commandArgument"));
                });

                if (linkIds.length > 0) {
                    PageMethods.TogglePostsState(
                        linkIds.toString(),
                        currentState,
                        function(result, userContext, methodName) {
                            result = eval("(" + result + ")");
                            if (result.type == "success") {
                                parent.topFrame.isPostback = true;
                                window.location = String.format("{0}?CategoryID={1}&LinkConfig={2}", currentPath, currentChannelId, userContext);
                            };
                            parent.topFrame.displayAlert(null, result);
                        },
                        function(error, userContext, methodName) {
                            parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                        },
                        currentState
                    );
                }
                else {
                    parent.topFrame.displayAlert(null, { message: _noneSelectedMessage, type: "alert", autoHide: true });
                };
                return false;
            });

            $("a[commandName=toggleTopSetting]").bind("click", toggleTopSetting);
        });
        function showLoading(e) {
            parent.topFrame.isPostback = false;
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
        };
        function toggleTopSetting(e) {
            var linkId = $(this).attr("commandArgument");
            var currentState = $("li[commandName=switchLinkConfig] input:checked").val();
            PageMethods.ToggleTopSetting(
                linkId,
                function(result, userContext, methodName) {
                    result = eval("(" + result + ")");
                    if (result.type == "success") {
                        parent.topFrame.isPostback = true;
                        window.location = String.format("{0}?CategoryID={1}&LinkConfig={2}", currentPath, currentChannelId, userContext);
                    };
                    parent.topFrame.displayAlert(null, result);
                },
                function(error, userContext, methodName) {
                    parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                },
                currentState
            );
            return false;
        };
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">

    <st:MessagePanel id="Messages" runat="server" />
    
    <h5>
        <a href="HostChannelsList.aspx" commandName="return"><%= UIText.GetSafeText("VSite","Label_Return_Text",string.Empty) %></a>
        <%= UIText.GetSafeText("VSite","Label_CurrentAction_Text",string.Empty) %>：
        <%= UIText.GetSafeText("VSite","Link_ContextManage_Text",string.Empty ) %>
    </h5>
    <br />
    <ul style="margin: 0px;">
        <li style="float: left;margin:0px;" commandName="switchLinkConfig">
            <asp:RadioButtonList ID="RadioButtonList1" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="LinkConfig_SelectedIndexChanged">
                <asp:ListItem Value="1" Text="已审核"></asp:ListItem>
                <asp:ListItem Value="0" Text="待审核" Selected="True"></asp:ListItem>
            </asp:RadioButtonList>
        </li>
        <li style="float: right;" commandName="checkPosts">
            <asp:LinkButton CssClass="linkButton" ID="CheckLinkButton" runat="server" Text="审核"></asp:LinkButton>
        </li>
    </ul>
    <div class="context">
    
        <table class="listing" border="0" cellpadding="0" cellspacing="0">
            <caption>
                <asp:Literal ID="CurrentCategoryLiteral" runat="server"></asp:Literal>
            </caption>
            <thead>
                <tr>
                    <th style="width:25px;">
                        <%= UIText.GetSafeText("SiteMenu" , "Label_ID_Text",string.Empty ) %>
                    </th>
                    <th style="width:25px;text-align:center;">
                        <input type="checkbox" />
                    </th>
                    <th>
                        <%= UIText.GetSafeText("SiteMenu" , "Label_Title_Text",string.Empty ) %>
                    </th>
                    <th style="text-align:right;">
                        <%= UIText.GetSafeText("SiteMenu" , "Label_Action_Text",string.Empty ) %>
                    </th>
                </tr>
           </thead>
            <asp:Repeater ID="PostsRepeater" runat="server">
                <HeaderTemplate>
                    <tbody>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <%# Eval("LinkID") %>
                        </td>
                        <td style="text-align:center;">
                            <input type="checkbox" commandName="changeState" commandArgument='<%# Eval("LinkID") %>'  />
                            <input name="txtPostID" type="hidden" value='<%# Eval("LinkID") %>' />
                        </td>
                        <td>
                            <a href='<%# Eval("Url") %>' target="_blank">
                                <%# Eval("Title") %>
                            </a>
                        </td>
                        <td style="text-align:right;">
                            <a class="actionLink setting" href='<%# string.Format("ChannelPostSetting.aspx?LinkID={0}",Eval("LinkID")) %>' style="display:none;">
                                <%# UIText.GetSafeText("SiteMenu", "LinkButton_Setting_Text", string.Empty) %>
                            </a>
                            <a class="actionLink setting" commandName="toggleTopSetting" commandArgument='<%# Eval("LinkID") %>' href='<%# string.Format("ChannelPostSetting.aspx?CommandType=SetTop&LinkID={0}",Eval("LinkID")) %>'>
                                <%# UIText.GetSafeText("SiteMenu", Convert.ToBoolean(Eval("IsChannelTop")) == true ? "LinkButton_CancelTop_Text" : "LinkButton_SetTop_Text", string.Empty)%>
                            </a>
                        </td>
                    </tr>                
                </ItemTemplate>
                <FooterTemplate>
                    </tbody>
                </FooterTemplate>
            </asp:Repeater>
            <tr id="EmptyTr" runat="server" visible="false">
                <td></td>
                <td></td>
                <td colspan="2">
                    <%= UIText.GetSafeText("VSite", "Label_EmptyData_Tooltip", string.Empty)%>
                </td>
                
            </tr>
        </table>
    
        <div class="pager">
	        <st:AspNetPager ID="AspNetPager1" LayoutType="Div" PageSize="25" CustomInfoSectionWidth="" CurrentPageButtonClass="current" CustomInfoClass="info" runat="server" UrlPaging="false" ShowPageIndexBox="Never" TextBeforePageIndexBox="go to page:"  ShowCustomInfoSection="Left"  SubmitButtonText="确定" PageIndexBoxType="TextBox" OnPageChanged="AspNetPager1_PageChanged" ></st:AspNetPager>
	    </div>
        
    </div>
</asp:Content>
