﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="HostChannelsList.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.HostChannelsList" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
<script type="text/javascript">
    $(function(e) {
        parent.topFrame.hideAlert();
        $("a[commandName=deleteChannel]").bind("click", deleteChannel);
        $("a.actionLink[commandName!=deleteChannel]").bind("click", showLoading);
    });
    function showLoading(e) {
        parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
    };
    function deleteChannel(e) {
        if (confirm("确定删除当前频道？")) {
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
            var channelId = $(this).attr("commandArgument");
            PageMethods.DeleteChannel(
                channelId,
                function(result, userContext, methodName) {
                    result = eval("(" + result + ")");
                    if (result.type == "success") {
                        parent.topFrame.isPostback = true;
                        window.location = window.location;
                    };
                    parent.topFrame.displayAlert(null, result);
                },
                function(error, userContext, methodName) {
                    parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                },
                null
            );
        }
        return false;
    };
</script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">

    <st:MessagePanel ID="Messages" runat="server" />
        <h5>
        当前操作：<%= UIText.GetSafeText("SiteMenu","HostAdmin_HostChannel_List",string.Empty ) %>
    </h5>
    <br />
    
    <asp:HyperLink ID="AddCategoryHyperLink" runat="server" Visible="false" Text="Add New Category"></asp:HyperLink>
    
    <asp:PlaceHolder ID="Edit" runat="server">
        <asp:DataGrid ID="dgrItems" AutoGenerateColumns="False" GridLines="None" OnDeleteCommand="dgrCategories_DeleteCommand" Caption="频道列表" CssClass="listing" runat="server">
            <AlternatingItemStyle CssClass="alt"></AlternatingItemStyle>
            <HeaderStyle CssClass="Header"></HeaderStyle>
            <Columns>
                <asp:TemplateColumn HeaderText="频道名称">
                    <ItemTemplate>
                        <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# string.Format("~/Channel/{0}.aspx",Eval("ID")) %>' Text='<%# Eval("Title") %>' Target="_blank" ></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn HeaderText="是否启用">
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <asp:Label ID="Label4" runat="server" Text='<%# Eval("IsActive").ToString().ToLower()=="true"?"是":"否" %>' />
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn HeaderText="排序">
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <asp:Label ID="SortLabel" runat="server" Text='<%# Eval("SortOrder") %>' />
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn HeaderText="投稿数">
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <asp:Label ID="ActiveLinksLabel" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.ActiveLinksCount") %>' />
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn HeaderText="未审稿">
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <asp:Label ID="LockedLinksLabel" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.LockedLinksCount") %>' />
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn>
                    <ItemStyle Width="70" />
                    <ItemTemplate>
                        <a href='ChannelPosts.aspx?CategoryID=<%# Eval("ID") %>' class="actionLink">
                            <%# UIText.GetSafeText("VSite", "Link_ContextManage_Text", string.Empty)%>
                        </a>
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn>
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <a class="actionLink" href='ManageChannel.aspx?<%# GetCategoryIDKey()  %>=<%# Eval("ID") %>&<%# GetCategoryTypeKey() %>=<%# CurrentCategoryType %>'>
                            <%# UIText.GetSafeText("VSite", "Button_Edit_Text", string.Empty)%>
                        </a>
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn>
                    <ItemStyle Width="50" />
                    <ItemTemplate>
                        <a class="actionLink" href='#' commandName="deleteChannel" commandArgument='<%# Eval("ID") %>'>
                            <%# UIText.GetSafeText("VSite", "Button_Delete_Text", string.Empty) %>
                        </a>
                    </ItemTemplate>
                </asp:TemplateColumn>
                
            </Columns>
        </asp:DataGrid>
    </asp:PlaceHolder>
    
</asp:Content>
