﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="SystemTagsList.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.SystemTagsList" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">    
    <link href='<%= VirtualPathUtility.ToAbsolute("~/Skins/_HostAdmin/SystemTags.css") %>' rel="stylesheet" type="text/css" />
    <script type="text/javascript">
        var systemTagPostsViewPath = '<%= VirtualPathUtility.ToAbsolute("~/HostAdmin/Frame_Main/SystemTagPosts.aspx") %>';
        $(function(e) {
            parent.topFrame.hideAlert();
            window['<%= string.Format("{0}_timeOutId",this.ClientID) %>'] = null;
            var popupMenuContainer = buildPopupMenuContainer();
            $(popupMenuContainer).bind("mouseout", hidePopupMenu);
            $('#tabs>ul').tabs();
            $("ul.systemTagsContainer>li>a").bind("mouseover", showPopupMenu);
            $("ul.systemTagsContainer>li>a").bind("mouseout", hidePopupMenu2);
            $("ul.systemTagsContainer>li>a").bind("click", function(e) { return false; });
            $("a", $(popupMenuContainer)).bind("click", manageSystemTag);
            $("a[commandName=manager]", $(popupMenuContainer)).bind("click", showLoading);
            $("a[href='#fragment-2']").bind("click", function(e) { $(popupMenuContainer).hide() });
            $("#addTagButton").bind("click", saveSystemTag);
            $("#newSystemTagTextBox").bind("keypress", function(e) { if (e.keyCode == 13) { saveSystemTag(); }; return false; });
        });
        function showPopupMenu(e) {
            e = e || window.event;
            var target = e.target || e.srcElement;
            var relatedTarget = e.relatedTarget || e.fromElement;
            if (relatedTarget.id == "popupMenuContainer") {
                return;
            };
            var _height = WebForm_GetElementPosition(this).height;
            var _width = WebForm_GetElementPosition(this).width;
            var _left = WebForm_GetElementPosition(this).x;
            var _top = WebForm_GetElementPosition(this).y;
            if (window['<%= string.Format("{0}_timeOutId",this.ClientID) %>']) {
                clearTimeout(window['<%= string.Format("{0}_timeOutId",this.ClientID) %>']);
            }
            setTimeout(function(e) { $(popupMenuContainer).css({ left: (_left + 1) + "px", top: (_top + _height + 1) + "px" }).show(); }, 0);
            $(popupMenuContainer).attr("parentTag", $(target).parent());
            $("a[commandName]", $(popupMenuContainer)).attr("commandArgument", $(this).attr("commandArgument"));
            $("a[commandName=manager]", $(popupMenuContainer)).attr("href", String.format("{0}?tagId={1}",systemTagPostsViewPath, $(this).attr("commandArgument")));
        };

        function hidePopupMenu(e) {
            e = e || window.event;
            var target = e.target || e.srcElement;
            var relatedTarget = e.relatedTarget || e.toElement;
            try {
                if (($(relatedTarget) != $(popupMenuContainer).attr("parentTag")) && ($(relatedTarget).descendantOf(this).size() <= 0)) {
                    window['<%= string.Format("{0}_timeOutId",this.ClientID) %>'] = setTimeout(function(e) { $(popupMenuContainer).hide(); }, 3000);
                };
            } catch (e) {
            window['<%= string.Format("{0}_timeOutId",this.ClientID) %>'] = setTimeout(function(e) { $(popupMenuContainer).hide(); }, 3000);
            }
        };
        function hidePopupMenu2(e) {
            e = e || window.event;
            var target = e.target || e.srcElement;
            var relatedTarget = e.relatedTarget || e.toElement;
            if (relatedTarget.id != $(popupMenuContainer).attr("id")) {
                window['<%= string.Format("{0}_timeOutId",this.ClientID) %>'] = setTimeout(function(e) { $(popupMenuContainer).hide(); }, 3000);
            }
        
        };
        function buildPopupMenuContainer() {
            var _popupMenuContainer = $("#popupMenuContainer");
            if (_popupMenuContainer.size() <= 0) {
                $("<div id=\"popupMenuContainer\"><a href=\"#\" class=\"delete\" commandName=\"delete\">删除</a><a href=\"#\" commandName=\"manager\">查看关联文章</a></div>").appendTo($("body"));
                var _popupMenuContainer = $("#popupMenuContainer");
            }
            return _popupMenuContainer;
        };
        function manageSystemTag(e) {
            var _commandName = $(this).attr("commandName");
            var _commandArgument = $(this).attr("commandArgument");
            if (_commandName == "delete") {
                if (confirm("确定删除当前系统标签？")) {
                    PageMethods.DeleteSystemTag(_commandArgument,
                        function(result, userContext, methodName) {
                            result = eval("(" + result + ")");
                            result.autoHide = true;
                            if (result.type == "success") {
                                parent.topFrame.displayAlert(null, result);
                                $(String.format("a[commandArgument={0}]", userContext), $("ul.systemTagsContainer")).parent().remove();
                            };
                            $(popupMenuContainer).hide();
                        },
                        function(error, userContext, methodName) {
                            parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                        },
                        _commandArgument
                    );
                }
            }
            else {
                window.location = $(this).attr("href");
            };
            return false;
        };

        function saveSystemTag(e) {
            var _systemTagNameTextBox = $("#newSystemTagTextBox");
            var _systemTagName = _systemTagNameTextBox.val().trim();
            if (_systemTagName == "") {
                parent.topFrame.displayAlert(_systemTagNameTextBox, { message: "标签名称不能为空！", type: "error", autoHide: true });
            }
            else {
                PageMethods.SaveSystemTag(
                    _systemTagName,
                    function(result, userContext, methodName) {
                        result = eval("(" + result + ")");
                        result.autoHide = true;
                        parent.topFrame.isPostback = true;
                        if (result.type == "success") {
                            window.location = window.location;
                        };
                        parent.topFrame.displayAlert(userContext, result);
                    },
                    function(error, userContext, methodName) {
                        parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                    },
                    _systemTagNameTextBox
                );
            };
            $(this).blur();
            return false;
        };
        function showLoading(e) {
            parent.topFrame.isPostback = false;
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
        };
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>
    <st:MessagePanel id="Messages" runat="server" />
    <h5>当前操作：系统标签维护</h5>
    <br />
    <div id="tabs">
        <ul style="margin:0px;">
            <li class="ui-tabs-nav-item">
                <a href="#fragment-1"><%= UIText.GetSafeText("SiteMenu", "Munu_SystemTagsList_Text", string.Empty)%></a>
            </li>
            <li class="ui-tabs-nav-item">
                <a href="#fragment-2"><%= UIText.GetSafeText("SiteMenu", "Munu_AddSystemTags_Text", string.Empty)%></a>
            </li>
        </ul>
        <div id="fragment-1" style="padding:5px 10px;">
            <asp:Repeater ID="SystemTagsRepeater" runat="server">
                <HeaderTemplate>
                    <ul class="systemTagsContainer clearfix">
                </HeaderTemplate>
                <ItemTemplate>
                    <li>
                        <a href="#" commandArgument='<%# Eval("TagID") %>'><%# Eval("TagName") %>(<%# Eval("Count") %>)</a>
                    </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
            &nbsp;
        </div>
        <div id="fragment-2">
            <ul style="list-style-type:none;padding:0px;margin:10px 10px;" class="clearfix">
                <li style="margin-left:3px;padding:0px;">
                    <label>系统标签名称：</label>
                    <br />
                    <input type="text" class="addTag niceTxt" id="newSystemTagTextBox" />
                    <br />
                    <br />
                    <input type="button" class="niceButton" id="addTagButton" value="添加新标签" />
                </li>
            </ul>
        </div>
    </div>
</asp:Content>
