<%@ Control Language="C#" EnableTheming="false"  AutoEventWireup="True" Codebehind="BlogsEditor.ascx.cs" Inherits="EnjooSite.Web.HostAdmin.UserControls.BlogsEditor" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>
<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Admin.WebUI" Assembly="EnjooSite.Web" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>
<st:MessagePanel id="messagePanel" runat="server"></st:MessagePanel>

<div>
    <asp:Button ID="btnAddNewBlog" runat="server" />
</div>

<st:AdvancedPanel id="pnlResults" runat="server">
	<asp:CheckBox id="chkShowInactive" AutoPostBack="True" Text="Show Inactive Blogs" Runat="server" oncheckedchanged="chkShowInactive_CheckedChanged"></asp:CheckBox>
	<asp:Repeater id="rprBlogsList" Runat="server" OnItemCommand="rprBlogsList_ItemCommand">
		<HeaderTemplate>
			<table class="listing" cellspacing="0" cellpadding="4" border="0">
			    <caption>
			        <%= UIText.GetSafeText("SiteMenu","HostAdmin_Blog_Manage",string.Empty ) %>
			    </caption>
				<tr>
					<th>Title</th>
					<th>Host</th>
					<th>Subfolder</th>
					<th>Group</th>
					<th>Active</th>
					<th></th>
					<th></th>
				</tr>
		</HeaderTemplate>
		<ItemTemplate>
			<tr>
				<td>
					<a href="<%# DataBinder.Eval(Container.DataItem, "RootUrl") %>Default.aspx"><%# DataBinder.Eval(Container.DataItem, "Title") %></a>
				</td>
				<td>
					<strong>
						<%# DataBinder.Eval(Container.DataItem, "Host") %>
					</strong>
				</td>
				<td>
					<strong>
						<%# DataBinder.Eval(Container.DataItem, "Subfolder") %>
					</strong>
				</td>
				<td>
					<%# DataBinder.Eval(Container.DataItem, "BlogGroupTitle") %>
				</td>
				<td>
					<%# DataBinder.Eval(Container.DataItem, "IsActive") %>
				</td>
				<td>
					<asp:LinkButton CssClass="actionLink" id="lnkEdit" CausesValidation="False" CommandName="Edit" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' Text="Edit" runat="server" />
				</td>
				<td>
					<asp:LinkButton id="lnkDelete" CssClass="actionLink" CausesValidation="False" CommandName="ToggleActive" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' Text='<%# ToggleActiveString((bool)DataBinder.Eval(Container.DataItem, "IsActive")) %>' runat="server" />
				</td>
			</tr>
		</ItemTemplate>
		<AlternatingItemTemplate>
			<tr class="alt">
				<td>
					<a href="<%# DataBinder.Eval(Container.DataItem, "RootUrl") %>Default.aspx"><%# DataBinder.Eval(Container.DataItem, "Title") %></a>
				</td>
				<td>
					<strong>
						<%# DataBinder.Eval(Container.DataItem, "Host") %>
					</strong>
				</td>
				<td>
					<strong>
						<%# DataBinder.Eval(Container.DataItem, "Subfolder") %>
					</strong>
				</td>
				<td>
					<%# DataBinder.Eval(Container.DataItem, "BlogGroupTitle") %>
				</td>
				<td>
					<%# DataBinder.Eval(Container.DataItem, "IsActive") %>
				</td>
				<td>
					<asp:LinkButton id="lnkEditAlt"  CssClass="actionLink"  CausesValidation="False" CommandName="Edit" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' Text="Edit" runat="server" />
				</td>
				<td>
					<asp:LinkButton id="lnkDeleteAlt" CssClass="actionLink"  CausesValidation="False" CommandName="ToggleActive" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' Text='<%# ToggleActiveString((bool)DataBinder.Eval(Container.DataItem, "IsActive")) %>' runat="server" />
				</td>
			</tr>
		</AlternatingItemTemplate>
		<FooterTemplate>
		        
			</table>
		</FooterTemplate>
	</asp:Repeater>
	<p id="lblNoMessages" runat="server" visible="false">No entries found.</p>
	<st:PagingControl id="resultsPager" runat="server" 
			PrefixText="<div>Goto page</div>" 
			LinkFormatActive='<a href="{0}" class="Current">{1}</a>' 
			UrlFormat="Default.aspx?pg={0}" 
			CssClass="Pager" />
</st:AdvancedPanel>
<st:AdvancedPanel id="pnlEdit" runat="server">
	<st:HelpToolTip id="blogEditorHelp" runat="server">
		<img id="Img3" src="~/images/ms_help.gif" align="right" alt="help" runat="server" />
	</st:HelpToolTip>
	<script type="text/javascript">
			function replace( str, from, to ) 
			{
				var idx = str.indexOf( from );

				while ( idx > -1 ) 
				{
					str = str.replace( from, to );
					idx = str.indexOf( from );
				}

				return str;
			}
			
			var badCharacters = '{}[]/\\ @!#$%;^&*()?+|"=\'<>;,';
			
			function removeInvalidCharacters(str)
			{
				var count = badCharacters.length;
				for(var i = 0; i < count; i++)
				{
					var badChar = badCharacters.substring(i, i + 1);
					str = replace(str, badChar, '');
				}
				return str;
			}
							
			function onPreviewChanged(txtHostId, txtApplicationId, virtualDirectoryId, isBlur)
			{
				var host = document.getElementById(txtHostId);
				var application = document.getElementById(txtApplicationId);
				var urlPreview = document.getElementById('urlPreview');
				var virtdirField = document.getElementById(virtualDirectoryId);
				
				var hostText = 'not specified';
				if(host && host.value != '')
				{
					hostText = removeInvalidCharacters(host.value);
					host.value = hostText;
					host.style.color = '#990000';
				}
				
				var appText = '';
				if(application && application.value != '')
				{
					appText = removeInvalidCharacters(application.value);
					appText = replace(appText, ':', '');
					if(appText.substring(0, 1) == '.')
						appText = appText.substring(1, appText.length);
						
					if(isBlur && appText.substring(appText.length - 1, appText.length) == '.')
					{
						appText = appText.substring(0, appText.length - 1);
					}
					
					application.value = appText;
					application.style.color = '#000099';
					appText = '<span style="color:#000099;">' + appText + '</span>';
					appText += '/';
				}
				
				var virtdirText = '';
				if(virtdirField && virtdirField.value != '')
				{
					virtdirText = '/' + virtdirField.value;
				}
			
				var preview = 'http://<span style="color:#990000">' + hostText + '</span>' + virtdirText + '/' + appText + 'default.aspx';
				
				urlPreview.innerHTML = preview;
			}
	</script>
	
	<strong>
		<st:HelpToolTip id="Helptooltip1" runat="server" HelpText="Based on what you'e entered below, this shows what the url to this blog will look like.">
			Url Preview
		</st:HelpToolTip>:
	</strong>
	
	<div class="MessagePanel" id="urlPreview">
	    http://
	</div>
	<table class="listing" border="0">
		<tr valign="top">
			<td><label for="lblTitle">Title:</label></td>
			<td>
				<asp:TextBox id="txtTitle" Runat="server" MaxLength="100"></asp:TextBox>
			</td>
			<td valign="top"><label>Blog Aliases </label></td>

		</tr>
		<tr valign="top">
			<td>
				<label for="txtHost">
 			    <st:HelpToolTip id="hostDomainHelpTip" runat="server"><strong>Host Domain</strong></st:HelpToolTip>:</label>
			</td>
			<td>
				<asp:TextBox id="txtHost" Runat="server" MaxLength="100"></asp:TextBox>
				<input id="virtualDirectory" type="hidden" runat="server" />
			</td>   
			<td rowspan="7" runat="Server" id="tdAliasList" style="background-position:left bottom;">
				<asp:Repeater runat="server" ID="rprBlogAliasList" OnItemCommand="rprBlogAliasList_ItemCommand">
					<HeaderTemplate>
						<table class="listing" cellspacing="0" cellpadding="0" border="0">
							<tr></tr>
							<tr>
								<th width="10px">&nbsp;</th>
								<th>
									Host</th>
								<th>
									Subfolder</th>
								<th>
									Active</th>
								<th>
									</th>
							</tr>
					</HeaderTemplate>
					<ItemTemplate>
						<tr>
							<td>
							    <asp:ImageButton ID="btnEditAlias" runat="server" ImageUrl="~\Images\edit.gif" CommandName="EditAlias" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' />
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Host") %>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Subfolder") %>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "IsActive") %>
							</td>
							<td><asp:LinkButton ID="btnDeleteAlias" runat="server" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' CommandName="DeleteAlias" Text="Delete" /></td>
						</tr>
					</ItemTemplate>
					<AlternatingItemTemplate>
						<tr class="alt">
							<td><asp:ImageButton ID="btnEditAlias" runat="server" ImageUrl="~\Images\edit.gif" CommandName="EditAlias" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' /> </td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Host") %>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Subfolder")%>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "IsActive") %>
							</td>
							<td><asp:LinkButton ID="btnDeleteAlias" runat="server" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "Id") %>' CommandName="DeleteAlias" Text="Delete" /></td>
						</tr>						
					</AlternatingItemTemplate>
					<FooterTemplate>
							<tr>
								<td colspan="5">
								    #<%# DataBinder.Eval(Container.DataItem, "BlogId") %>#
								<asp:LinkButton ID="lbAddAlias" CssClass="button"  Text="Add Alias" runat="server" CommandName="Add" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "BlogId") %>' OnClick="lbAddAlias_OnClick"></asp:LinkButton>
								</td>
							</tr>
						</table>
					</FooterTemplate>
				</asp:Repeater>
			</td>
			<td  rowspan="7"  id="tdAliasApplication" runat="server" visible="false"  style="background-position:left bottom;">
			
			    <table class="listing" cellspacing="0" cellpadding="0" border="0">
			        <caption>
			            &nbsp;
			        </caption>
			        <tr>
			            <td>
			                Host
			            </td>
			            <td id="tdAliasHost" runat="server" visible="false">
				            <asp:HiddenField ID="hdnAliasId" runat="server" />
				            <asp:TextBox id="txtAliasHost" Runat="server" MaxLength="100"></asp:TextBox>
			            </td>
			        </tr>
			        <tr>
			            <td>
			                Subfolder
			            </td>
			            <td>
			                <asp:TextBox id="txtAliasApplication" Runat="server" MaxLength="50"></asp:TextBox>
			            </td>
			        </tr>
			        <tr>
			            <td>
			                Active
			            </td>
			            <td>
			                <asp:CheckBox ID="cbAliasActive" runat="server" />
			            </td>
			        </tr>
			        <tr>
			            <td colspan="2">
				            <asp:Button ID="btnAliasCancel" Text="Cancel" runat="server" CssClass="button" OnClick="btnAliasCancel_Click" Visible="False" />
				            <asp:Button ID="btnAliasSave" runat="server" CssClass="button" OnClick="btnAliasSave_Click" Text="Save" Visible="False" />
			            </td>
			        </tr>
			    </table>
				
			</td>
		</tr>
		<tr valign="top">
			<td>
				<st:HelpToolTip id="applicationHelpTip" runat="server">
					<strong>Subfolder</strong></st:HelpToolTip>:
			</td>
			<td>
				<asp:TextBox id="txtApplication" Runat="server" MaxLength="50"></asp:TextBox>
			</td>
		</tr>
		<tr valign="top">
			<td>
			    <label for="ddlGroups">Blog Group:</label>
			</td>
			<td>
				<asp:DropDownList id="ddlGroups" Runat="server" DataTextField="Title" DataValueField="Id"></asp:DropDownList>
			</td>
		</tr>
		<tr valign="top">
			<td><label for="txtUsername">
				<st:HelpToolTip id="helpUsername" runat="server" HelpText="This will be the user who is the administrator of this blog.">
				User Name:</st:HelpToolTip></label>
			</td>
			<td>
				<asp:TextBox id="txtUsername" Runat="server" MaxLength="50"></asp:TextBox>
			</td>
		</tr>
		<tr id="passwordRow" runat="server" valign="top">
			<td><label for="txtPassword">
					<st:HelpToolTip id="helpPassword" runat="server" HelpText="When editing an existing blog, you can leave this blank if you do not wish to change the password.">Password:</st:HelpToolTip></label>
			</td>
			<td>
				<asp:TextBox id="txtPassword" Runat="server" MaxLength="50" TextMode="Password"></asp:TextBox>
			</td>
		</tr>
		<tr id="passwordRowConfirm" runat="server" valign="top">
			<td><label for="txtPasswordConfirm">Confirm Password:</label></td>
			<td>
				<asp:TextBox id="txtPasswordConfirm" Runat="server" MaxLength="50" TextMode="Password"></asp:TextBox>
			</td>
		</tr>
		<tr valign="top">
			<td colspan="2">
				<asp:Button ID="btnCancel" Text="Cancel" runat="server" CssClass="button" OnClick="btnCancel_Click">
				</asp:Button>
				<asp:Button ID="btnSave" Text="Save" runat="server" CssClass="button" OnClick="btnSave_Click">
				</asp:Button>
			</td>
		</tr>
	</table>
	<asp:HiddenField ID="ViewStateBlogID" runat="server" />
</st:AdvancedPanel>
